/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.GlobalSettings;
import JSci.maths.matrices.Matrix;

public abstract class AbstractDoubleMatrix
extends Matrix {
    protected AbstractDoubleMatrix(int n, int n2) {
        super(n, n2);
    }

    public final boolean equals(Object object) {
        if (object instanceof AbstractDoubleMatrix) {
            return this.equals((AbstractDoubleMatrix)object);
        }
        return false;
    }

    public final boolean equals(AbstractDoubleMatrix abstractDoubleMatrix) {
        return this.equals(abstractDoubleMatrix, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(AbstractDoubleMatrix abstractDoubleMatrix, double d) {
        if (abstractDoubleMatrix != null && this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double d2 = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double d3 = this.getElement(i, j) - abstractDoubleMatrix.getElement(i, j);
                    d2 += d3 * d3;
                }
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.getElement(i, j));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public abstract double getElement(int var1, int var2);

    public double infNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                d2 += Math.abs(this.getElement(i, j));
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }
}

