/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.BSHType;
import bsh.CallStack;
import bsh.CollectionManager;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.Types;
import bsh.UtilEvalError;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

class BSHPrimarySuffix
extends SimpleNode {
    public int operation;
    public String field;

    BSHPrimarySuffix(int n) {
        super(n);
    }

    public Object doSuffix(Object object, boolean bl, CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.operation == 0) {
            if (object instanceof BSHType) {
                if (bl) {
                    throw new EvalError("Can't assign .class", this, callStack);
                }
                NameSpace nameSpace = callStack.top();
                return ((BSHType)object).getType(callStack, interpreter);
            }
            throw new EvalError("Attempt to use .class suffix on non class.", this, callStack);
        }
        if (object instanceof SimpleNode) {
            object = object instanceof BSHAmbiguousName ? ((BSHAmbiguousName)object).toObject(callStack, interpreter) : ((SimpleNode)object).eval(callStack, interpreter);
        } else if (object instanceof LHS) {
            try {
                object = ((LHS)object).getValue();
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError(this, callStack);
            }
        }
        try {
            switch (this.operation) {
                case 1: {
                    return this.doIndex(object, bl, callStack, interpreter);
                }
                case 2: {
                    return this.doName(object, bl, callStack, interpreter);
                }
                case 3: {
                    return this.doProperty(bl, object, callStack, interpreter);
                }
            }
            throw new InterpreterError("Unknown suffix type");
        }
        catch (ReflectError reflectError) {
            throw new EvalError("reflection error: " + reflectError, this, callStack);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TargetError("target exception", invocationTargetException.getTargetException(), this, callStack, true);
        }
    }

    private Object doName(Object object, boolean bl, CallStack callStack, Interpreter interpreter) throws EvalError, ReflectError, InvocationTargetException {
        try {
            if (this.field.equals("length") && object.getClass().isArray()) {
                if (bl) {
                    throw new EvalError("Can't assign array length", this, callStack);
                }
                return new Primitive(Array.getLength(object));
            }
            if (this.jjtGetNumChildren() == 0) {
                if (bl) {
                    return Reflect.getLHSObjectField(object, this.field);
                }
                return Reflect.getObjectFieldValue(object, this.field);
            }
            Object[] objectArray = ((BSHArguments)this.jjtGetChild(0)).getArguments(callStack, interpreter);
            try {
                return Reflect.invokeObjectMethod(object, this.field, objectArray, interpreter, callStack, this);
            }
            catch (ReflectError reflectError) {
                throw new EvalError("Error in method invocation: " + reflectError.getMessage(), this, callStack);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = "Method Invocation " + this.field;
                Throwable throwable = invocationTargetException.getTargetException();
                boolean bl2 = true;
                if (throwable instanceof EvalError) {
                    bl2 = throwable instanceof TargetError ? ((TargetError)throwable).inNativeCode() : false;
                }
                throw new TargetError(string, throwable, this, callStack, bl2);
            }
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
    }

    static int getIndexAux(Object object, CallStack callStack, Interpreter interpreter, SimpleNode simpleNode) throws EvalError {
        int n;
        if (!object.getClass().isArray()) {
            throw new EvalError("Not an array", simpleNode, callStack);
        }
        try {
            Object object2 = ((SimpleNode)simpleNode.jjtGetChild(0)).eval(callStack, interpreter);
            if (!(object2 instanceof Primitive)) {
                object2 = Types.castObject(object2, Integer.TYPE, 1);
            }
            n = ((Primitive)object2).intValue();
        }
        catch (UtilEvalError utilEvalError) {
            Interpreter.debug("doIndex: " + utilEvalError);
            throw utilEvalError.toEvalError("Arrays may only be indexed by integer types.", simpleNode, callStack);
        }
        return n;
    }

    private Object doIndex(Object object, boolean bl, CallStack callStack, Interpreter interpreter) throws EvalError, ReflectError {
        int n = BSHPrimarySuffix.getIndexAux(object, callStack, interpreter, this);
        if (bl) {
            return new LHS(object, n);
        }
        try {
            return Reflect.getIndex(object, n);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
    }

    private Object doProperty(boolean bl, Object object, CallStack callStack, Interpreter interpreter) throws EvalError {
        if (object == Primitive.VOID) {
            throw new EvalError("Attempt to access property on undefined variable or class name", this, callStack);
        }
        if (object instanceof Primitive) {
            throw new EvalError("Attempt to access property on a primitive", this, callStack);
        }
        Object object2 = ((SimpleNode)this.jjtGetChild(0)).eval(callStack, interpreter);
        if (!(object2 instanceof String)) {
            throw new EvalError("Property expression must be a String or identifier.", this, callStack);
        }
        if (bl) {
            return new LHS(object, (String)object2);
        }
        CollectionManager collectionManager = CollectionManager.getCollectionManager();
        if (collectionManager.isMap(object)) {
            Object object3 = collectionManager.getFromMap(object, object2);
            return object3 == null ? (object3 = Primitive.NULL) : object3;
        }
        try {
            return Reflect.getObjectProperty(object, (String)object2);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Property: " + object2, this, callStack);
        }
        catch (ReflectError reflectError) {
            throw new EvalError("No such property: " + object2, this, callStack);
        }
    }
}

