/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JTextField;

public class TextBox
extends PNode {
    private JTextField swingTextField;
    private ArrayList<Listener> listeners = new ArrayList();
    protected final PSwing textField;

    public TextBox(Font font) {
        this(font, 4);
    }

    public TextBox(Font font, int n) {
        this.swingTextField = new JTextField(n);
        this.swingTextField.setFont(font);
        this.swingTextField.setHorizontalAlignment(4);
        this.textField = new PSwing(this.swingTextField);
        this.addChild(this.textField);
        this.swingTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextBox.this.notifyListeners();
            }
        });
        this.swingTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TextBox.this.notifyListeners();
            }

            public void focusGained(FocusEvent focusEvent) {
                TextBox.this.swingTextField.selectAll();
            }
        });
    }

    private void notifyListeners() {
        for (Listener listener : this.listeners) {
            listener.changed();
        }
    }

    public void setText(String string) {
        if (!string.equals(this.swingTextField.getText()) && !this.swingTextField.hasFocus()) {
            this.swingTextField.setText(string);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public String getText() {
        return this.swingTextField.getText();
    }

    public void addFocusListener(FocusListener focusListener) {
        this.swingTextField.addFocusListener(focusListener);
    }

    public static interface Listener {
        public void changed();
    }
}

