/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.motion.charts.Range;
import edu.colorado.phet.common.motion.charts.TemporalDataSeries;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.movingman.MovingManResources;
import edu.colorado.phet.movingman.model.MovingMan;
import edu.colorado.phet.movingman.model.MovingManModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class MovingManNode
extends PNode {
    private Function.LinearFunction modelToView = new Function.LinearFunction(-10.0, 10.0, 0.0, 975.0);
    private MovingManModel model;
    private final Range viewRange;
    private final BooleanProperty positiveToTheRight;
    private BufferedImage imageStanding;
    private BufferedImage imageLeft;
    private BufferedImage imageRight;
    private MovingMan man;
    private final PImage imageNode;

    public MovingManNode(final MovingMan movingMan, MovingManModel movingManModel, Range range, BooleanProperty booleanProperty) {
        this.man = movingMan;
        this.model = movingManModel;
        this.viewRange = range;
        this.positiveToTheRight = booleanProperty;
        range.addObserver(new SimpleObserver(){

            public void update() {
                MovingManNode.this.updateTransform();
            }
        });
        try {
            this.imageStanding = BufferedImageUtils.multiScaleToHeight(MovingManResources.loadBufferedImage("man-standing.gif"), 100);
            this.imageLeft = BufferedImageUtils.multiScaleToHeight(MovingManResources.loadBufferedImage("man-left.gif"), 100);
            this.imageRight = BufferedImageUtils.flipX(this.imageLeft);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.imageNode = new PImage(this.imageStanding);
        this.updateTransform();
        this.addChild(this.imageNode);
        movingMan.addListener(new MovingMan.Listener(){

            public void changed() {
                MovingManNode.this.updateMan();
            }
        });
        movingManModel.getVelocityGraphSeries().addListener(new TemporalDataSeries.Adapter(){

            public void entireSeriesChanged() {
                MovingManNode.this.updateMan();
            }
        });
        this.updateMan();
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new MovingManDragger(this));
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                movingMan.setPositionDriven();
            }
        });
    }

    public BufferedImage getImageStanding() {
        return this.imageStanding;
    }

    private void updateTransform() {
        this.modelToView.setOutput(this.viewRange.getMin(), this.viewRange.getMax());
        this.updateMan();
    }

    private void updateMan() {
        double d = this.man.getVelocity();
        if (d > 0.1) {
            this.imageNode.setImage((Boolean)this.positiveToTheRight.get() != false ? this.imageRight : this.imageLeft);
        } else if (d < -0.1) {
            this.imageNode.setImage((Boolean)this.positiveToTheRight.get() != false ? this.imageLeft : this.imageRight);
        } else {
            this.imageNode.setImage(this.imageStanding);
        }
        this.imageNode.setOffset(this.modelToView.evaluate(this.man.getPosition()) - this.imageNode.getFullBounds().getWidth() / 2.0, 0.0);
    }

    public double viewToModel(double d) {
        return this.modelToView.createInverse().evaluate(d);
    }

    public double modelToView(double d) {
        return this.modelToView.evaluate(d);
    }

    private static class MovingManDragger
    extends PBasicInputEventHandler {
        private MovingManNode movingManNode;
        private double relativeGrabPoint = Double.NaN;

        private MovingManDragger(MovingManNode movingManNode) {
            this.movingManNode = movingManNode;
        }

        public void mousePressed(PInputEvent pInputEvent) {
            super.mousePressed(pInputEvent);
            this.updateRelativeGrabPoint(pInputEvent);
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            super.mouseDragged(pInputEvent);
            if (Double.isNaN(this.relativeGrabPoint)) {
                this.updateRelativeGrabPoint(pInputEvent);
            }
            this.movingManNode.model.setMousePosition(this.getModelPoint(pInputEvent) + this.relativeGrabPoint);
        }

        public void mouseReleased(PInputEvent pInputEvent) {
            this.relativeGrabPoint = Double.NaN;
        }

        private void updateRelativeGrabPoint(PInputEvent pInputEvent) {
            this.relativeGrabPoint = this.getModelPoint(pInputEvent) - this.movingManNode.model.getMousePosition();
        }

        private double getModelPoint(PInputEvent pInputEvent) {
            return this.movingManNode.viewToModel(pInputEvent.getCanvasPosition().getX());
        }
    }
}

