/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman;

import edu.colorado.phet.common.motion.charts.ChartCursor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.movingman.CrashSound;
import edu.colorado.phet.movingman.ExpressionDialog;
import edu.colorado.phet.movingman.MovingManStrings;
import edu.colorado.phet.movingman.model.ExpressionEvaluator;
import edu.colorado.phet.movingman.model.JListener;
import edu.colorado.phet.movingman.model.MovingMan;
import edu.colorado.phet.movingman.model.MovingManModel;
import edu.colorado.phet.movingman.model.MovingManState;
import edu.colorado.phet.movingman.view.MovingManSimulationPanel;
import edu.colorado.phet.recordandplayback.gui.RecordAndPlaybackControlPanel;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MovingManModule
extends Module {
    protected RecordAndPlaybackModel<MovingManState> recordAndPlaybackModel;
    private ArrayList<MovingMan.MotionStrategy> actionList = new ArrayList();
    private boolean lastPauseState;
    protected final MovingManModel movingManModel = new MovingManModel(new MovingManModel.BooleanGetter(){

        public boolean isTrue() {
            return MovingManModule.this.recordAndPlaybackModel.isPaused();
        }
    });
    private BooleanProperty positiveToTheRight = new BooleanProperty(true);
    final ExpressionDialog expressionDialog;
    final MovingManSimulationPanel simulationPanel;
    private final BooleanProperty soundEnabled = new BooleanProperty(true);
    boolean expressionDialogVisibleOnDeactivate = false;

    public MovingManModule(PhetFrame phetFrame, String string) {
        super(string, new ConstantDtClock(41, 0.041666666666666664));
        this.movingManModel.addCollisionListener(new JListener(){

            public void eventOccurred() {
                if (((Boolean)MovingManModule.this.soundEnabled.get()).booleanValue()) {
                    CrashSound.play();
                }
            }
        });
        this.recordAndPlaybackModel = new RecordAndPlaybackModel<MovingManState>(1000){

            @Override
            public MovingManState step(double d) {
                MovingManModule.this.movingManModel.simulationTimeChanged(d);
                return MovingManModule.this.movingManModel.getRecordingState();
            }

            @Override
            public void setPlaybackState(MovingManState movingManState) {
                MovingManModule.this.movingManModel.setPlaybackState(movingManState);
            }
        };
        this.recordAndPlaybackModel.addHistoryRemainderClearListener(new RecordAndPlaybackModel.HistoryRemainderClearListener(){

            public void historyRemainderCleared() {
                MovingManModule.this.movingManModel.historyRemainderCleared(MovingManModule.this.recordAndPlaybackModel.getTime());
            }
        });
        this.recordAndPlaybackModel.addObserver(new SimpleObserver(){

            public void update() {
                if (MovingManModule.this.recordAndPlaybackModel.isPaused() != MovingManModule.this.lastPauseState) {
                    if (MovingManModule.this.recordAndPlaybackModel.isPaused()) {
                        MovingManModule.this.actionList.clear();
                    } else {
                        if (MovingManModule.this.actionList.contains(MovingMan.POSITION_DRIVEN)) {
                            MovingMan.POSITION_DRIVEN.apply(MovingManModule.this.movingManModel.getMovingMan());
                        }
                        if (MovingManModule.this.actionList.contains(MovingMan.VELOCITY_DRIVEN)) {
                            MovingMan.VELOCITY_DRIVEN.apply(MovingManModule.this.movingManModel.getMovingMan());
                        }
                        if (MovingManModule.this.actionList.contains(MovingMan.ACCELERATION_DRIVEN)) {
                            MovingMan.ACCELERATION_DRIVEN.apply(MovingManModule.this.movingManModel.getMovingMan());
                        }
                    }
                    MovingManModule.this.lastPauseState = MovingManModule.this.recordAndPlaybackModel.isPaused();
                }
            }
        });
        this.movingManModel.getMovingMan().addListener(new MovingMan.Listener(){

            public void changed() {
                if (MovingManModule.this.recordAndPlaybackModel.isPaused() && !MovingManModule.this.actionList.contains(MovingManModule.this.movingManModel.getMovingMan().getMotionStrategy())) {
                    MovingManModule.this.actionList.add(MovingManModule.this.movingManModel.getMovingMan().getMotionStrategy());
                }
            }
        });
        this.lastPauseState = this.recordAndPlaybackModel.isPaused();
        this.getClock().addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                MovingManModule.this.recordAndPlaybackModel.stepInTime(clockEvent.getSimulationTimeChange());
            }
        });
        this.recordAndPlaybackModel.addHistoryClearListener(new RecordAndPlaybackModel.HistoryClearListener(){

            public void historyCleared() {
                MovingManModule.this.movingManModel.clear();
            }
        });
        this.movingManModel.getChartCursor().addListener(new ChartCursor.Adapter(){

            public void positionChanged() {
                double d = MovingManModule.this.movingManModel.getChartCursor().getTime();
                MovingManModule.this.recordAndPlaybackModel.setTime(d);
            }
        });
        this.recordAndPlaybackModel.addObserver(new SimpleObserver(){

            public void update() {
                MovingManModule.this.updateCursorVisibility(MovingManModule.this.movingManModel, MovingManModule.this.recordAndPlaybackModel);
            }
        });
        this.updateCursorVisibility(this.movingManModel, this.recordAndPlaybackModel);
        this.simulationPanel = this.createSimulationPanel(this.movingManModel, this.recordAndPlaybackModel);
        this.setSimulationPanel(this.simulationPanel);
        this.setClockControlPanel(this.createRecordAndPlaybackPanel());
        this.setLogoPanelVisible(false);
        this.expressionDialog = new ExpressionDialog(phetFrame, this);
    }

    protected RecordAndPlaybackControlPanel<MovingManState> createRecordAndPlaybackPanel() {
        RecordAndPlaybackControlPanel<MovingManState> recordAndPlaybackControlPanel = new RecordAndPlaybackControlPanel<MovingManState>(this.recordAndPlaybackModel, this.getSimulationPanel(), 20.0);
        recordAndPlaybackControlPanel.addControl(new PSwing(new ResetAllButton(new Resettable(){

            public void reset() {
                MovingManModule.this.resetAll();
            }
        }, (Component)this.getSimulationPanel())));
        recordAndPlaybackControlPanel.addControl(new PSwing(new SoundCheckBox(this.soundEnabled)));
        return recordAndPlaybackControlPanel;
    }

    protected abstract MovingManSimulationPanel createSimulationPanel(MovingManModel var1, RecordAndPlaybackModel<MovingManState> var2);

    private void updateCursorVisibility(MovingManModel movingManModel, RecordAndPlaybackModel<MovingManState> recordAndPlaybackModel) {
        movingManModel.getChartCursor().setVisible(recordAndPlaybackModel.isPlayback() && recordAndPlaybackModel.getNumRecordedPoints() > 0);
    }

    public void resetAll() {
        this.movingManModel.resetAll();
        this.recordAndPlaybackModel.resetAll();
        this.positiveToTheRight.reset();
        this.simulationPanel.resetAll();
    }

    public void setPositiveToTheRight(boolean bl) {
        this.positiveToTheRight.set(bl);
    }

    public BooleanProperty getPositiveToTheRight() {
        return this.positiveToTheRight;
    }

    public void setEvaluateExpressionDialogVisible(boolean bl) {
        this.expressionDialog.setVisible(bl);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.expressionDialogVisibleOnDeactivate = this.expressionDialog.isVisible();
        this.expressionDialog.setVisible(false);
    }

    @Override
    public void activate() {
        super.activate();
        this.setEvaluateExpressionDialogVisible(this.expressionDialogVisibleOnDeactivate);
    }

    public MovingManModel getMovingManModel() {
        return this.movingManModel;
    }

    public void setPaused(boolean bl) {
        this.recordAndPlaybackModel.setPaused(bl);
    }

    public boolean getEvaluateExpressionDialogVisible() {
        return this.expressionDialog.isVisible();
    }

    public void setExpression(ExpressionEvaluator expressionEvaluator) {
        this.movingManModel.setExpression(expressionEvaluator);
    }

    public static class SoundCheckBox
    extends JCheckBox {
        public SoundCheckBox(final BooleanProperty booleanProperty) {
            super(MovingManStrings.OPTIONS_SOUND, (boolean)((Boolean)booleanProperty.get()));
            booleanProperty.addObserver(new SimpleObserver(){

                public void update() {
                    SoundCheckBox.this.setSelected((Boolean)booleanProperty.get());
                }
            });
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    booleanProperty.set(SoundCheckBox.this.isSelected());
                }
            });
            this.setBackground(new Color(0, 0, 0, 0));
            this.setOpaque(false);
        }
    }
}

