/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.movingman.LinearTransform;
import edu.colorado.phet.movingman.view.PlayAreaObjectNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.image.BufferedImage;

public class WallNode
extends PlayAreaObjectNode {
    private BooleanProperty walls;
    private final PImage minimizeButton;
    private final PImage maximizeButton;

    public WallNode(BufferedImage bufferedImage, LinearTransform linearTransform, double d, final BooleanProperty booleanProperty, double d2, BooleanProperty booleanProperty2) {
        super(bufferedImage, linearTransform, d, d2, booleanProperty2);
        this.walls = booleanProperty;
        this.minimizeButton = new PImage(PhetCommonResources.getImage("buttons/closeButton.png"));
        this.minimizeButton.addInputEventListener(new CursorHandler());
        this.addChild(this.minimizeButton);
        this.minimizeButton.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                booleanProperty.set(false);
            }
        });
        this.maximizeButton = new PImage(PhetCommonResources.getMaximizeButtonImage());
        this.maximizeButton.addInputEventListener(new CursorHandler());
        this.addChild(this.maximizeButton);
        this.maximizeButton.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                booleanProperty.set(true);
            }
        });
        booleanProperty.addObserver(new SimpleObserver(){

            public void update() {
                WallNode.this.updateVisibility();
            }
        });
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.wallNode.setVisible((Boolean)this.walls.get());
        this.minimizeButton.setVisible((Boolean)this.walls.get());
        this.maximizeButton.setVisible((Boolean)this.walls.get() == false);
    }
}

