/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.control;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.control.GenePanel;
import edu.colorado.phet.naturalselection.control.MutationPanel;
import edu.colorado.phet.naturalselection.persistence.NaturalSelectionConfig;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class LeftPanel
extends JPanel {
    private MutationPanel mutationPanel;
    private GenePanel genePanel;

    public LeftPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = new JLabel(NaturalSelectionStrings.MUTATION_PANEL_ADD_MUTATION, new ImageIcon(NaturalSelectionResources.getImage("mutation_large.png")), 2);
        jLabel.setFont(new PhetFont(18));
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(jLabel);
        this.add(jPanel);
        this.mutationPanel = new MutationPanel();
        this.add(this.mutationPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(new JSeparator());
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.genePanel = new GenePanel();
        this.add(this.genePanel);
        this.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        jPanel.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.setBorder(new EmptyBorder(new Insets(0, 10, 10, 10)));
    }

    public void reset() {
        this.mutationPanel.reset();
        this.genePanel.reset();
    }

    public void load(NaturalSelectionConfig naturalSelectionConfig) {
        this.genePanel.load(naturalSelectionConfig);
    }

    public void save(NaturalSelectionConfig naturalSelectionConfig) {
        this.genePanel.save(naturalSelectionConfig);
    }

    public MutationPanel getMutationPanel() {
        return this.mutationPanel;
    }

    public GenePanel getGenePanel() {
        return this.genePanel;
    }
}

