/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.model;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.model.ColorGene;
import edu.colorado.phet.naturalselection.model.NaturalSelectionClock;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import edu.colorado.phet.naturalselection.model.Wolf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Frenzy
implements NaturalSelectionClock.Listener {
    private double startTime;
    private double duration;
    private NaturalSelectionClock clock;
    private NaturalSelectionModel model;
    private ArrayList<Wolf> wolves;
    private boolean running = true;
    private ArrayList<Listener> listeners;
    private List<Bunny> targets;

    public Frenzy(NaturalSelectionModel naturalSelectionModel, double d) {
        this.model = naturalSelectionModel;
        this.duration = d;
        this.listeners = new ArrayList();
        this.clock = naturalSelectionModel.getClock();
        this.startTime = this.clock.getSimulationTime();
        this.clock.addPhysicalListener(this);
    }

    public void init() {
        int n = NaturalSelectionConstants.getSettings().getWolfBase();
        int n2 = NaturalSelectionConstants.getSettings().getBunniesPerWolves();
        int n3 = this.model.getPopulation();
        int n4 = n + n3 / n2;
        this.initializeTargets();
        this.wolves = new ArrayList();
        for (int i = 0; i < n4; ++i) {
            final Wolf wolf = new Wolf(this.model, this);
            if (this.targets.isEmpty()) {
                wolf.stopHunting();
            }
            this.wolves.add(wolf);
            this.notifyWolfCreate(wolf);
            wolf.addListener(new Wolf.Listener(){

                public void onEvent(Wolf.Event event) {
                    if (event.type == 1) {
                        Frenzy.this.onBunnyKilled(wolf, wolf.getTarget());
                    }
                }
            });
        }
    }

    private void initializeTargets() {
        double d = NaturalSelectionConstants.getSettings().getWolfSelectionBunnyOffset();
        double d2 = NaturalSelectionConstants.getSettings().getWolfSelectionBunnyExponent();
        double d3 = NaturalSelectionConstants.getSettings().getWolfSelectionScale();
        double d4 = NaturalSelectionConstants.getSettings().getWolfSelectionBlendScale();
        double d5 = NaturalSelectionConstants.getSettings().getMaxKillFraction();
        this.targets = new LinkedList<Bunny>();
        double d6 = Math.pow((double)this.model.getPopulation() + d, d2) * d3;
        for (Bunny bunny : this.model.getAliveBunnyList()) {
            double d7 = d6;
            if (bunny.getColorPhenotype() == ColorGene.WHITE_ALLELE && this.model.getClimate() == 1 || bunny.getColorPhenotype() == ColorGene.BROWN_ALLELE && this.model.getClimate() == 0) {
                d7 *= d4;
            }
            if (d7 > d5) {
                d7 = d5;
            }
            if (!(Math.random() < d7)) continue;
            this.targets.add(bunny);
        }
    }

    private void onBunnyKilled(Wolf wolf, Bunny bunny) {
        this.targets.remove(bunny);
        if (this.targets.isEmpty()) {
            for (Wolf wolf2 : this.wolves) {
                wolf2.stopHunting();
            }
        }
    }

    public double getTimeLeft() {
        return (this.startTime + this.duration - this.clock.getSimulationTime()) * 1000.0 / (double)NaturalSelectionConstants.getSettings().getClockFrameRate();
    }

    public boolean isRunning() {
        return this.running;
    }

    public Bunny getNewWolfTarget(Wolf wolf) {
        if (this.targets.isEmpty()) {
            return null;
        }
        Bunny bunny = null;
        double d = Double.POSITIVE_INFINITY;
        for (Bunny bunny2 : this.targets) {
            double d2 = Point3D.distance(wolf.getPosition(), bunny2.getPosition());
            if (!(d2 < d)) continue;
            bunny = bunny2;
            d = d2;
        }
        return bunny;
    }

    public void onTick(ClockEvent clockEvent) {
        this.notifyFrenzyTimeLeft();
        if (this.startTime + this.duration <= clockEvent.getSimulationTime()) {
            this.endFrenzy();
        } else if (this.targets.isEmpty()) {
            boolean bl = false;
            for (Wolf wolf : this.wolves) {
                Point3D point3D = wolf.getPosition();
                double d = this.model.getLandscape().getMaximumX(point3D.getZ());
                if (!(point3D.getX() < d) || !(point3D.getX() > -d)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.endFrenzy();
            }
        }
    }

    public void endFrenzy() {
        if (!this.running) {
            return;
        }
        this.clock.removePhysicalListener(this);
        this.model.endFrenzy();
        this.running = false;
        for (Wolf wolf : this.wolves) {
            wolf.disable();
        }
        this.notifyFrenzyStop();
    }

    private void notifyFrenzyStop() {
        Iterator<Listener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onFrenzyStop(this);
        }
    }

    private void notifyFrenzyTimeLeft() {
        Iterator<Listener> iterator = this.listeners.iterator();
        double d = this.getTimeLeft();
        while (iterator.hasNext()) {
            iterator.next().onFrenzyTimeLeft(d);
        }
    }

    private void notifyWolfCreate(Wolf wolf) {
        Iterator<Listener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onWolfCreate(wolf);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void onFrenzyStop(Frenzy var1);

        public void onFrenzyTimeLeft(double var1);

        public void onWolfCreate(Wolf var1);
    }
}

