/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.model;

import edu.colorado.phet.naturalselection.model.Allele;
import edu.colorado.phet.naturalselection.model.Gene;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Genotype {
    private Gene gene;
    private Allele fatherAllele;
    private Allele motherAllele;
    private List<Allele> childAlleleOrder;
    private int childAlleleIndex = 0;

    public Genotype(Gene gene, Allele allele, Allele allele2) {
        this.gene = gene;
        this.fatherAllele = allele;
        this.motherAllele = allele2;
        this.childAlleleOrder = new LinkedList<Allele>();
        this.childAlleleOrder.add(allele);
        this.childAlleleOrder.add(allele);
        this.childAlleleOrder.add(allele2);
        this.childAlleleOrder.add(allele2);
        Collections.shuffle(this.childAlleleOrder);
    }

    public Allele getPhenotype() {
        if (this.fatherAllele == this.motherAllele) {
            return this.fatherAllele;
        }
        return this.gene.getDominantAllele();
    }

    public Allele getNextChildAllele() {
        if (this.childAlleleIndex > 3) {
            this.childAlleleIndex = 0;
        }
        return this.childAlleleOrder.get(this.childAlleleIndex++);
    }

    public Gene getGene() {
        return this.gene;
    }

    public Allele getFatherAllele() {
        return this.fatherAllele;
    }

    public Allele getMotherAllele() {
        return this.motherAllele;
    }

    public String toString() {
        return this.fatherAllele.toString() + this.motherAllele.toString();
    }
}

