/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.module;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.naturalselection.control.NaturalSelectionControlPanel;
import edu.colorado.phet.naturalselection.dialog.PedigreeChartCanvas;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.model.ColorGene;
import edu.colorado.phet.naturalselection.model.Gene;
import edu.colorado.phet.naturalselection.model.GeneListener;
import edu.colorado.phet.naturalselection.model.NaturalSelectionClock;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import edu.colorado.phet.naturalselection.model.TailGene;
import edu.colorado.phet.naturalselection.model.TeethGene;
import edu.colorado.phet.naturalselection.module.NaturalSelectionModule;
import edu.colorado.phet.naturalselection.view.LandscapeNode;
import edu.colorado.phet.naturalselection.view.NaturalSelectionCanvas;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class NaturalSelectionController {
    public NaturalSelectionController(final NaturalSelectionModel naturalSelectionModel, final NaturalSelectionCanvas naturalSelectionCanvas, final NaturalSelectionControlPanel naturalSelectionControlPanel, final NaturalSelectionModule naturalSelectionModule) {
        naturalSelectionModel.addListener(naturalSelectionCanvas.landscapeNode);
        naturalSelectionModel.addListener(naturalSelectionCanvas.backgroundNode);
        naturalSelectionControlPanel.getClimatePanel().getArcticButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                naturalSelectionModel.setClimate(1);
            }
        });
        naturalSelectionControlPanel.getClimatePanel().getEquatorButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                naturalSelectionModel.setClimate(0);
            }
        });
        naturalSelectionControlPanel.getSelectionPanel().getNoneButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                naturalSelectionModel.setSelectionFactor(0);
            }
        });
        naturalSelectionControlPanel.getSelectionPanel().getFoodButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                naturalSelectionModel.setSelectionFactor(1);
            }
        });
        naturalSelectionControlPanel.getSelectionPanel().getWolvesButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                naturalSelectionModel.setSelectionFactor(2);
            }
        });
        naturalSelectionControlPanel.getResetAllButton().addResettable(naturalSelectionModule);
        naturalSelectionCanvas.getLandscapeNode().addListener(new LandscapeNode.Listener(){

            public void onBunnySelected(Bunny bunny) {
                naturalSelectionControlPanel.getPedigreeChart().displayBunny(bunny);
            }
        });
        GeneListener geneListener = new GeneListener(){

            public void onChangeDominantAllele(Gene gene, boolean bl) {
            }

            public void onChangeDistribution(Gene gene, int n, int n2) {
            }

            public void onChangeMutatable(Gene gene, boolean bl) {
                naturalSelectionCanvas.handleMutationChange(gene, bl);
            }
        };
        ColorGene.getInstance().addListener(geneListener);
        TailGene.getInstance().addListener(geneListener);
        TeethGene.getInstance().addListener(geneListener);
        naturalSelectionModel.addListener(new NaturalSelectionModel.Listener(){

            public void onEvent(NaturalSelectionModel.Event event) {
                if (event.getType() == 5) {
                    naturalSelectionModule.showGameOver();
                }
            }
        });
        naturalSelectionModel.addListener(new NaturalSelectionModel.Listener(){

            public void onEvent(NaturalSelectionModel.Event event) {
                if (event.getType() == 6) {
                    naturalSelectionModule.showBunniesTakeOver();
                }
            }
        });
        ColorGene.getInstance().addListener(new GeneListener(){

            public void onChangeDominantAllele(Gene gene, boolean bl) {
            }

            public void onChangeDistribution(Gene gene, int n, int n2) {
                if (n + n2 == 0) {
                    naturalSelectionModel.endGame();
                }
            }

            public void onChangeMutatable(Gene gene, boolean bl) {
            }
        });
        naturalSelectionControlPanel.getMutationPanel().getColorButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                naturalSelectionControlPanel.getGenePanel().setColorEnabled(true);
            }
        });
        naturalSelectionControlPanel.getMutationPanel().getTailButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                naturalSelectionControlPanel.getGenePanel().setTailEnabled(true);
            }
        });
        naturalSelectionControlPanel.getMutationPanel().getTeethButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                naturalSelectionControlPanel.getGenePanel().setTeethEnabled(true);
            }
        });
        naturalSelectionControlPanel.getSwitcherPanel().getStatisticsRadioButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                naturalSelectionControlPanel.getDetachPanel().showStaticChild();
                if (Bunny.getSelectedBunny() != null) {
                    Bunny.getSelectedBunny().setSelected(false);
                }
            }
        });
        naturalSelectionControlPanel.getSwitcherPanel().getPedigreeRadioButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                naturalSelectionControlPanel.getDetachPanel().showDetachableChild();
                PedigreeChartCanvas pedigreeChartCanvas = naturalSelectionControlPanel.getPedigreeChart();
                Bunny bunny = pedigreeChartCanvas.getLastDisplayedBunny();
                if (bunny != null && Bunny.getSelectedBunny() == null && bunny.isAlive()) {
                    pedigreeChartCanvas.getLastDisplayedBunny().setSelected(true);
                }
            }
        });
        naturalSelectionControlPanel.getDetachPanel().addListener(naturalSelectionControlPanel.getSwitcherPanel());
        naturalSelectionModel.getClock().addTimeListener(new NaturalSelectionClock.Listener(){

            public void onTick(ClockEvent clockEvent) {
                naturalSelectionControlPanel.getGenerationProgressPanel().setGenerationProgressPercent(naturalSelectionModel.getGenerationProgressPercent());
            }
        });
        naturalSelectionModel.getClock().addTimeListener(new NaturalSelectionClock.Listener(){

            public void onTick(ClockEvent clockEvent) {
                naturalSelectionControlPanel.getBunnyStatsPanel().getBunnyStatsCanvas().onTick(naturalSelectionModel.getPopulation());
            }
        });
    }
}

