/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.model.Frenzy;
import edu.colorado.phet.naturalselection.model.Landscape;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import edu.colorado.phet.naturalselection.model.Shrub;
import edu.colorado.phet.naturalselection.model.Tree;
import edu.colorado.phet.naturalselection.model.Wolf;
import edu.colorado.phet.naturalselection.view.sprites.BunnyNode;
import edu.colorado.phet.naturalselection.view.sprites.NaturalSelectionSprite;
import edu.colorado.phet.naturalselection.view.sprites.Rescalable;
import edu.colorado.phet.naturalselection.view.sprites.ShrubNode;
import edu.colorado.phet.naturalselection.view.sprites.TreeNode;
import edu.colorado.phet.naturalselection.view.sprites.WolfNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class LandscapeNode
extends PNode
implements NaturalSelectionModel.Listener,
NaturalSelectionSprite.Listener {
    private List<NaturalSelectionSprite> sprites;
    private List<BunnyNode> bunnies;
    private List<WolfNode> wolves;
    private List<TreeNode> trees;
    private List<ShrubNode> shrubs;
    private int oldClimate;
    private int oldSelection;
    private AffineTransform backgroundTransform;
    private NaturalSelectionModel model;
    private Landscape landscape;
    private List<Listener> listeners = new LinkedList<Listener>();

    public LandscapeNode(NaturalSelectionModel naturalSelectionModel, Landscape landscape) {
        NaturalSelectionSprite naturalSelectionSprite;
        this.model = naturalSelectionModel;
        this.landscape = landscape;
        this.sprites = new LinkedList<NaturalSelectionSprite>();
        this.bunnies = new LinkedList<BunnyNode>();
        this.trees = new LinkedList<TreeNode>();
        this.shrubs = new LinkedList<ShrubNode>();
        this.wolves = new LinkedList<WolfNode>();
        this.backgroundTransform = new AffineTransform();
        this.oldClimate = 0;
        this.oldSelection = 0;
        for (Tree object : naturalSelectionModel.getTrees()) {
            naturalSelectionSprite = new TreeNode(this, object);
            this.addSprite(naturalSelectionSprite);
            this.trees.add((TreeNode)naturalSelectionSprite);
        }
        for (Shrub shrub : naturalSelectionModel.getShrubs()) {
            naturalSelectionSprite = new ShrubNode(this, shrub);
            this.addSprite(naturalSelectionSprite);
            this.shrubs.add((ShrubNode)naturalSelectionSprite);
            naturalSelectionSprite.setVisible(false);
        }
    }

    public void onEvent(NaturalSelectionModel.Event event) {
        if (event.getType() == 2) {
            this.onClimateChange(event.getNewClimate());
        }
        if (event.getType() == 3) {
            this.onSelectionFactorChange(event.getNewSelectionFactor());
        }
        if (event.getType() == 1) {
            this.onNewBunny(event.getNewBunny());
        }
        if (event.getType() == 4) {
            event.getFrenzy().addListener(new Frenzy.Listener(){

                public void onFrenzyStop(Frenzy frenzy) {
                    for (WolfNode wolfNode : LandscapeNode.this.wolves) {
                        LandscapeNode.this.removeSprite(wolfNode);
                    }
                    LandscapeNode.this.wolves.clear();
                }

                public void onFrenzyTimeLeft(double d) {
                }

                public void onWolfCreate(Wolf wolf) {
                    LandscapeNode.this.onNewWolf(wolf);
                }
            });
        }
    }

    private void onNewWolf(Wolf wolf) {
        WolfNode wolfNode = new WolfNode(this, wolf.getPosition());
        wolfNode.setFlipped(wolf.isMovingRight());
        this.addSprite(wolfNode);
        wolf.addListener(wolfNode);
        this.wolves.add(wolfNode);
        this.sprites.add(wolfNode);
    }

    private void onClimateChange(int n) {
        if (n == this.oldClimate) {
            return;
        }
        this.oldClimate = n;
        if (n == 0) {
            this.setTreeVisibility(true);
        } else if (n == 1) {
            this.setTreeVisibility(false);
        }
    }

    private void onSelectionFactorChange(int n) {
        if (n == this.oldSelection) {
            return;
        }
        this.oldSelection = n;
        if (n == 1) {
            this.setShrubVisibility(true);
        } else {
            this.setShrubVisibility(false);
        }
    }

    private void setTreeVisibility(boolean bl) {
        for (TreeNode treeNode : this.trees) {
            treeNode.setVisible(bl);
        }
    }

    private void setShrubVisibility(boolean bl) {
        for (ShrubNode shrubNode : this.shrubs) {
            shrubNode.setVisible(bl);
        }
    }

    public void reset() {
        LinkedList<NaturalSelectionSprite> linkedList = new LinkedList<NaturalSelectionSprite>();
        for (NaturalSelectionSprite naturalSelectionSprite : this.sprites) {
            if (this.indexOfChild(naturalSelectionSprite) == -1 || naturalSelectionSprite instanceof TreeNode || naturalSelectionSprite instanceof ShrubNode) continue;
            this.removeChild(naturalSelectionSprite);
            linkedList.add(naturalSelectionSprite);
        }
        for (NaturalSelectionSprite naturalSelectionSprite : linkedList) {
            this.sprites.remove(naturalSelectionSprite);
        }
        this.onClimateChange(0);
        this.onSelectionFactorChange(0);
        this.bunnies.clear();
        this.wolves.clear();
    }

    public void onNewBunny(final Bunny bunny) {
        if (!bunny.isAlive()) {
            return;
        }
        BunnyNode bunnyNode = new BunnyNode(this.model, bunny.getColorPhenotype(), bunny.getTeethPhenotype(), bunny.getTailPhenotype(), this, bunny.getPosition());
        bunnyNode.setFlipped(!bunny.isMovingRight());
        this.addSprite(bunnyNode);
        bunny.addListener(bunnyNode);
        this.sprites.add(bunnyNode);
        this.bunnies.add(bunnyNode);
        bunnyNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseClicked(PInputEvent pInputEvent) {
                bunny.setSelected(true);
                LandscapeNode.this.notifyBunnySelected(bunny);
            }
        });
    }

    public void addSprite(NaturalSelectionSprite naturalSelectionSprite) {
        this.sprites.add(naturalSelectionSprite);
        naturalSelectionSprite.addSpriteListener(this);
        List list = this.getChildrenReference();
        if (list.size() == 0) {
            this.addChild(naturalSelectionSprite);
            return;
        }
        ListIterator listIterator = this.getChildrenIterator();
        boolean bl = false;
        while (listIterator.hasNext()) {
            NaturalSelectionSprite naturalSelectionSprite2 = (NaturalSelectionSprite)listIterator.next();
            if (!(naturalSelectionSprite2.getPosition().getZ() < naturalSelectionSprite.getPosition().getZ())) continue;
            this.addChild(listIterator.previousIndex(), naturalSelectionSprite);
            bl = true;
            break;
        }
        if (!bl) {
            this.addChild(naturalSelectionSprite);
        }
        this.repositionSprite(naturalSelectionSprite);
    }

    public void removeSprite(NaturalSelectionSprite naturalSelectionSprite) {
        this.sprites.remove(naturalSelectionSprite);
        this.removeChild(naturalSelectionSprite);
        naturalSelectionSprite.removeSpriteListener(this);
    }

    public void spriteMoved(NaturalSelectionSprite naturalSelectionSprite, boolean bl) {
        this.repositionSprite(naturalSelectionSprite);
        if (bl) {
            this.spriteDepthCheck(naturalSelectionSprite);
        }
    }

    private void spriteDepthCheck(NaturalSelectionSprite naturalSelectionSprite) {
        List list = this.getChildrenReference();
        int n = list.indexOf(naturalSelectionSprite);
        if (n == -1) {
            return;
        }
        boolean bl = true;
        if (n > 0 && ((NaturalSelectionSprite)this.getChild(n - 1)).getPosition().getZ() < naturalSelectionSprite.getPosition().getZ()) {
            bl = false;
        }
        if (n < list.size() - 1 && ((NaturalSelectionSprite)this.getChild(n + 1)).getPosition().getZ() > naturalSelectionSprite.getPosition().getZ()) {
            bl = false;
        }
        if (!bl) {
            this.replaceSprite(naturalSelectionSprite);
        }
    }

    private void replaceSprite(NaturalSelectionSprite naturalSelectionSprite) {
        this.removeChild(naturalSelectionSprite);
        List list = this.getChildrenReference();
        for (int i = 0; i < list.size(); ++i) {
            NaturalSelectionSprite naturalSelectionSprite2 = (NaturalSelectionSprite)list.get(i);
            if (!(naturalSelectionSprite.getPosition().getZ() >= naturalSelectionSprite2.getPosition().getZ())) continue;
            this.addChild(i, naturalSelectionSprite);
            return;
        }
        this.addChild(list.size(), naturalSelectionSprite);
    }

    private void repositionSprite(NaturalSelectionSprite naturalSelectionSprite) {
        Point3D point3D = naturalSelectionSprite.getPosition();
        Point2D point2D = this.landscape.spriteToScreen(point3D);
        naturalSelectionSprite.setOffset(point2D.getX(), point2D.getY());
    }

    public void updateLayout(double d, double d2) {
        this.landscape.updateSize(d, d2);
        for (NaturalSelectionSprite naturalSelectionSprite : this.sprites) {
            this.repositionSprite(naturalSelectionSprite);
            if (!(naturalSelectionSprite instanceof Rescalable)) continue;
            ((Rescalable)((Object)naturalSelectionSprite)).rescale();
        }
    }

    public void setSpriteTransform(AffineTransform affineTransform) {
        this.backgroundTransform = affineTransform;
    }

    public AffineTransform getSpriteTransform() {
        return this.backgroundTransform;
    }

    private void notifyBunnySelected(Bunny bunny) {
        for (Listener listener : this.listeners) {
            listener.onBunnySelected(bunny);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void onBunnySelected(Bunny var1);
    }
}

