/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view.sprites;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.naturalselection.NaturalSelectionApplication;
import edu.colorado.phet.naturalselection.model.Allele;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import edu.colorado.phet.naturalselection.view.DisplayBunnyNode;
import edu.colorado.phet.naturalselection.view.LandscapeNode;
import edu.colorado.phet.naturalselection.view.sprites.NaturalSelectionSprite;
import edu.umd.cs.piccolo.PNode;

public class BunnyNode
extends NaturalSelectionSprite
implements Bunny.Listener {
    private DisplayBunnyNode displayBunnyNode;
    private PNode displayHolder;
    private boolean cachedFlip = false;

    public BunnyNode(NaturalSelectionModel naturalSelectionModel, Allele allele, Allele allele2, Allele allele3, LandscapeNode landscapeNode, Point3D point3D) {
        super(landscapeNode, point3D);
        this.landscapeNode = landscapeNode;
        this.displayBunnyNode = new DisplayBunnyNode(allele, allele2, allele3);
        this.displayHolder = new PNode();
        this.displayHolder.addChild(this.displayBunnyNode);
        this.addChild(this.displayHolder);
        this.setBunnyOffset();
        this.rescale();
        this.addInputEventListener(new CursorHandler(CursorHandler.HAND));
    }

    public void setPosition(Point3D point3D) {
        if (point3D.getX() > this.getPosition().getX()) {
            this.setFlipped(false);
        } else if (point3D.getX() < this.getPosition().getX()) {
            this.setFlipped(true);
        }
        super.setPosition(point3D);
        this.rescale();
    }

    public void setFlipped(boolean bl) {
        this.displayBunnyNode.setFlipped(bl);
        this.cachedFlip = bl;
    }

    public void onEvent(Bunny.Event event) {
        switch (event.type) {
            case 1: {
                this.landscapeNode.removeSprite(this);
                break;
            }
            case 4: {
                this.setPosition(event.getPosition());
                if (this.cachedFlip != event.getBunny().isMovingRight()) break;
                this.setFlipped(!event.getBunny().isMovingRight());
                break;
            }
            case 5: {
                this.displayBunnyNode.setSelected(event.getBunny().isSelected());
            }
        }
    }

    private void rescale() {
        double d = 37.5 / this.getPosition().getZ();
        if (NaturalSelectionApplication.isHighContrast()) {
            d *= 1.5;
        }
        this.setScale(d);
    }

    private void setBunnyOffset() {
        this.displayHolder.setOffset(-this.displayBunnyNode.getBunnyWidth() / 2.0, -this.displayBunnyNode.getBunnyHeight());
    }
}

