/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet.piccolo;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.ChartChangeListener;

public class JFreeChartNode
extends PNode
implements ChartChangeListener {
    private JFreeChart _chart;
    private ChartRenderingInfo _info;
    private boolean _buffered;
    private BufferedImage _chartImage;
    private AffineTransform _imageTransform;
    private int _bufferedImageType;
    private SwingPropertyChangeSupport _changeSupport = new SwingPropertyChangeSupport(this);

    public JFreeChartNode(JFreeChart jFreeChart) {
        this(jFreeChart, false);
    }

    public JFreeChartNode(JFreeChart jFreeChart, boolean bl) {
        this(jFreeChart, bl, 2);
    }

    public JFreeChartNode(JFreeChart jFreeChart, boolean bl, int n) {
        this._bufferedImageType = n;
        this._chart = jFreeChart;
        this._chart.addChangeListener(this);
        this._info = new ChartRenderingInfo();
        this._buffered = bl;
        this._chartImage = null;
        this._imageTransform = new AffineTransform();
        this.addPNodeUpdateHandler();
        this.updateAll();
    }

    public void updateChartRenderingInfo() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, this._bufferedImageType);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this._chart.draw(graphics2D, this.getBounds(), this._info);
        this._changeSupport.firePropertyChange("chartRenderingInfo", null, this.getChartRenderingInfo());
    }

    protected void addPNodeUpdateHandler() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JFreeChartNode.this.updateAll();
            }
        });
    }

    protected void updateAll() {
        this.rebuildBuffer();
        this.updateChartRenderingInfo();
        this.repaint();
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this._info;
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        super.internalUpdateBounds(d, d2, d3, d4);
        this.updateAll();
    }

    protected void paint(PPaintContext pPaintContext) {
        if (this._buffered) {
            this.paintBuffered(pPaintContext);
        } else {
            this.paintDirect(pPaintContext);
        }
    }

    private void paintDirect(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        this._chart.draw(graphics2D, this.getBoundsReference(), this._info);
    }

    private void paintBuffered(PPaintContext pPaintContext) {
        PBounds pBounds = this.getBoundsReference();
        if (this._chartImage == null) {
            this.rebuildBuffer();
        }
        Graphics2D graphics2D = pPaintContext.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this._imageTransform.setToTranslation(((RectangularShape)pBounds).getX(), ((RectangularShape)pBounds).getY());
        graphics2D.drawRenderedImage(this._chartImage, this._imageTransform);
    }

    private void rebuildBuffer() {
        PBounds pBounds = this.getBoundsReference();
        BufferedImage bufferedImage = this._chartImage;
        int n = (int)((RectangularShape)pBounds).getWidth();
        int n2 = (int)((RectangularShape)pBounds).getHeight();
        if (n > 0 && n2 > 0) {
            this._chartImage = this._chart.createBufferedImage(n, n2, this._bufferedImageType, this._info);
            this._changeSupport.firePropertyChange("bufferedImage", bufferedImage, this._chartImage);
        }
    }

    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        if (chartChangeEvent.getType() == ChartChangeEventType.DATASET_UPDATED) {
            this.repaint();
        } else if (chartChangeEvent.getType() == ChartChangeEventType.NEW_DATASET) {
            this.repaint();
        } else {
            this.updateAll();
        }
    }
}

