/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.control;

import edu.colorado.phet.common.phetcommon.view.LogoPanel;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.control.BunnyStatsPanel;
import edu.colorado.phet.naturalselection.control.ClimatePanel;
import edu.colorado.phet.naturalselection.control.DetachOptionPanel;
import edu.colorado.phet.naturalselection.control.GenePanel;
import edu.colorado.phet.naturalselection.control.GenerationProgressPanel;
import edu.colorado.phet.naturalselection.control.LeftPanel;
import edu.colorado.phet.naturalselection.control.MutationPanel;
import edu.colorado.phet.naturalselection.control.SelectionPanel;
import edu.colorado.phet.naturalselection.control.SwitcherPanel;
import edu.colorado.phet.naturalselection.dialog.PedigreeChartCanvas;
import edu.colorado.phet.naturalselection.module.NaturalSelectionModule;
import edu.colorado.phet.naturalselection.persistence.NaturalSelectionConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class NaturalSelectionControlPanel
extends JPanel {
    private JPanel rightPanel;
    private BunnyStatsPanel bunnyStatsPanel;
    private LeftPanel leftPanel;
    private DetachOptionPanel detachPanel;
    private PedigreeChartCanvas pedigreeChart;
    private SwitcherPanel switcherPanel;
    private ClimatePanel climatePanel;
    private SelectionPanel selectionPanel;
    private GenerationProgressPanel generationProgressPanel;
    private ResetAllButton resetAllButton;

    public NaturalSelectionControlPanel(NaturalSelectionModule naturalSelectionModule) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.switcherPanel = new SwitcherPanel();
        this.climatePanel = new ClimatePanel();
        this.selectionPanel = new SelectionPanel();
        PiccoloClockControlPanel piccoloClockControlPanel = new PiccoloClockControlPanel(naturalSelectionModule.getClock());
        piccoloClockControlPanel.setEnableStepWhileRunning(true);
        this.generationProgressPanel = new GenerationProgressPanel();
        piccoloClockControlPanel.addBetweenTimeDisplayAndButtons(this.generationProgressPanel);
        this.createRightPanel();
        this.leftPanel = new LeftPanel();
        this.bunnyStatsPanel = new BunnyStatsPanel();
        LogoPanel logoPanel = new LogoPanel();
        logoPanel.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.pedigreeChart = new PedigreeChartCanvas();
        this.detachPanel = new DetachOptionPanel(NaturalSelectionStrings.PEDIGREE_CHART, this.pedigreeChart, this.bunnyStatsPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.leftPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add((Component)this.detachPanel, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.anchor = 12;
        gridBagConstraints3.gridheight = 2;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.rightPanel, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 0.0;
        gridBagConstraints4.anchor = 15;
        this.add((Component)piccoloClockControlPanel, gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.weightx = 0.0;
        gridBagConstraints5.weighty = 0.0;
        gridBagConstraints5.anchor = 13;
        this.add((Component)logoPanel, gridBagConstraints5);
        this.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.rightPanel.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.selectionPanel.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.pedigreeChart.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                NaturalSelectionControlPanel.this.pedigreeChart.setCenterPoint(0.0);
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public void selectDefaultSelectionFactor() {
        this.selectionPanel.selectDefaultSelectionFactor();
    }

    private void createRightPanel() {
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
        this.rightPanel.add(this.selectionPanel);
        this.rightPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.rightPanel.add(this.climatePanel);
        this.rightPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.rightPanel.add(this.switcherPanel);
        this.rightPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.resetAllButton = new ResetAllButton(this);
        this.rightPanel.add(this.resetAllButton);
        this.rightPanel.add(Box.createRigidArea(new Dimension(0, 5)));
    }

    public void reset() {
        this.climatePanel.reset();
        this.selectDefaultSelectionFactor();
        this.bunnyStatsPanel.reset();
        this.leftPanel.reset();
        this.pedigreeChart.reset();
    }

    public void load(NaturalSelectionConfig naturalSelectionConfig) {
        this.leftPanel.load(naturalSelectionConfig);
        this.climatePanel.load(naturalSelectionConfig);
        this.selectionPanel.load(naturalSelectionConfig);
    }

    public void save(NaturalSelectionConfig naturalSelectionConfig) {
        this.leftPanel.save(naturalSelectionConfig);
    }

    public PedigreeChartCanvas getPedigreeChart() {
        return this.pedigreeChart;
    }

    public MutationPanel getMutationPanel() {
        return this.leftPanel.getMutationPanel();
    }

    public GenePanel getGenePanel() {
        return this.leftPanel.getGenePanel();
    }

    public DetachOptionPanel getDetachPanel() {
        return this.detachPanel;
    }

    public SwitcherPanel getSwitcherPanel() {
        return this.switcherPanel;
    }

    public BunnyStatsPanel getBunnyStatsPanel() {
        return this.bunnyStatsPanel;
    }

    public ClimatePanel getClimatePanel() {
        return this.climatePanel;
    }

    public SelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    public ResetAllButton getResetAllButton() {
        return this.resetAllButton;
    }

    public GenerationProgressPanel getGenerationProgressPanel() {
        return this.generationProgressPanel;
    }
}

