/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.model;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.naturalselection.defaults.NaturalSelectionDefaults;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Landscape {
    public static final Dimension SIZE = NaturalSelectionDefaults.VIEW_SIZE;
    private double landscapeWidth = SIZE.getWidth();
    private double landscapeHeight = SIZE.getHeight();

    public void updateSize(double d, double d2) {
        this.landscapeWidth = d;
        this.landscapeHeight = d2;
    }

    public Point3D getRandomGroundPosition() {
        double d = Math.sqrt(22500.0 + Math.random() * 67500.0);
        double d2 = this.getMaximumX(d) * (Math.random() * 2.0 - 1.0);
        double d3 = this.getGroundY(d2, d);
        return new Point3D.Double(d2, d3, d);
    }

    public double getGroundY(double d, double d2) {
        return (d2 - 300.0) * 100.0 / 150.0;
    }

    public double getMaximumX(double d) {
        return d * SIZE.getWidth() * 0.5 / this.getFactor();
    }

    private double getFactor() {
        return (SIZE.getHeight() - 120.0) * 150.0 / 100.0;
    }

    public double landscapeYToZ(double d) {
        return 45000.0 * (120.0 - SIZE.getHeight()) / (300.0 * (120.0 - d) + 150.0 * (d - SIZE.getHeight()));
    }

    public double landscapeXmodelZToX(double d, double d2) {
        return d2 * (d - SIZE.getWidth() / 2.0) / this.getFactor();
    }

    public Point3D landscapeToModel(double d, double d2) {
        double d3 = this.landscapeYToZ(d2);
        double d4 = this.landscapeXmodelZToX(d, d3);
        double d5 = this.getGroundY(d4, d3);
        return new Point3D.Double(d4, d5, d3);
    }

    public Point2D spriteToScreen(Point3D point3D) {
        double d = SIZE.getWidth() / 2.0 + point3D.getX() / point3D.getZ() * this.getFactor();
        double d2 = 120.0 - point3D.getY() / point3D.getZ() * this.getFactor();
        return new Point2D.Double(d * this.landscapeWidth / SIZE.getWidth(), d2 * this.landscapeHeight / SIZE.getHeight());
    }

    public double landscapeDistanceToModel(double d, double d2) {
        return d * d2 / this.getFactor();
    }
}

