/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.util;

import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.HashMap;
import javax.swing.ImageIcon;

public abstract class HighContrastImageFilter
extends RGBImageFilter {
    private HashMap<String, Image> cache = new HashMap();
    private static HighContrastImageFilter equator = new Equator();
    private static HighContrastImageFilter whiteBunny = new WhiteBunny();
    private static HighContrastImageFilter brownBunny = new BrownBunny();

    public Image getImage(String string) {
        if (this.cache.containsKey(string)) {
            return this.cache.get(string);
        }
        Image image = this.getImage(NaturalSelectionResources.getImage(string));
        image = new ImageIcon(image).getImage();
        System.out.println("Adding to high-contrast cache: " + string);
        this.cache.put(string, image);
        if (!(image instanceof BufferedImage)) {
            System.out.println("NOT BUFFERED");
        }
        return image;
    }

    public PImage getPImage(String string) {
        return new PImage(this.getImage(string));
    }

    public Image getImage(BufferedImage bufferedImage) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), this);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public int compact(int n, int n2, int n3, int n4) {
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    public static HighContrastImageFilter getEquator() {
        return equator;
    }

    public static HighContrastImageFilter getWhiteBunny() {
        return whiteBunny;
    }

    public static HighContrastImageFilter getBrownBunny() {
        return brownBunny;
    }

    private static class BrownBunny
    extends HighContrastImageFilter {
        private BrownBunny() {
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = (n3 & 0xFF000000) >> 24;
            int n5 = (n3 & 0xFF0000) >> 16;
            int n6 = (n3 & 0xFF00) >> 8;
            int n7 = n3 & 0xFF;
            if (n4 != 0 && n5 == 255 && n6 == 91 && n7 == 255) {
                return n3;
            }
            if (n4 != 0 && (n5 != 171 || n6 != 129 || n7 != 35)) {
                return this.compact(n4, 0, 0, 0);
            }
            return this.compact(n4, 203, 152, 45);
        }
    }

    private static class Equator
    extends HighContrastImageFilter {
        private Equator() {
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = (n3 & 0xFF000000) >> 24;
            int n5 = (n3 & 0xFF0000) >> 16;
            int n6 = (n3 & 0xFF00) >> 8;
            int n7 = n3 & 0xFF;
            if (n5 >= 119 && n5 <= 203 && n6 >= 89 && n6 <= 152 && n7 >= 15 && n7 <= 45) {
                return this.compact(n4, 171, 129, 35);
            }
            return n3;
        }
    }

    private static class WhiteBunny
    extends HighContrastImageFilter {
        private WhiteBunny() {
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = (n3 & 0xFF000000) >> 24;
            int n5 = (n3 & 0xFF0000) >> 16;
            int n6 = (n3 & 0xFF00) >> 8;
            int n7 = n3 & 0xFF;
            if (n4 != 0 && (n5 < 238 || n6 < 238 || n7 < 238)) {
                return this.compact(n4, 0, 0, 0);
            }
            return n3;
        }
    }
}

