/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.model.ColorGene;
import edu.colorado.phet.naturalselection.model.Gene;
import edu.colorado.phet.naturalselection.model.TailGene;
import edu.colorado.phet.naturalselection.model.TeethGene;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.swing.SwingLayoutNode;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class MutationPendingNode
extends PNode {
    private PText label;
    private PImage geneImage;
    private PImage mutationImage;
    private SwingLayoutNode layoutNode;

    public MutationPendingNode(Gene gene) {
        this.geneImage = NaturalSelectionResources.getImageNode(this.getImageString(gene));
        this.mutationImage = NaturalSelectionResources.getImageNode("mutation_large.png");
        this.label = new PText(NaturalSelectionStrings.MUTATION_COMING);
        this.label.setFont(new PhetFont(16, true));
        this.layoutNode = new SwingLayoutNode(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.layoutNode.addChild(this.mutationImage, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.layoutNode.addChild(this.label, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.layoutNode.addChild(this.geneImage, gridBagConstraints);
        this.layoutNode.translate(5.0, 5.0);
        PPath pPath = PPath.createRectangle(0.0f, 0.0f, (float)this.getPlacementWidth(), (float)this.getPlacementHeight());
        this.addChild(pPath);
        this.addChild(this.layoutNode);
    }

    public String getImageString(Gene gene) {
        if (gene == ColorGene.getInstance()) {
            return "bunny_color_brown.png";
        }
        if (gene == TailGene.getInstance()) {
            return "bunny_tail_long.png";
        }
        if (gene == TeethGene.getInstance()) {
            return "bunny_teeth_long.png";
        }
        throw new RuntimeException("Unknown gene");
    }

    public double getPlacementWidth() {
        return this.layoutNode.getContainer().getPreferredSize().getWidth() + 10.0;
    }

    public double getPlacementHeight() {
        return this.layoutNode.getContainer().getPreferredSize().getHeight() + 10.0;
    }
}

