/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.util.HashMap;
import org.jfree.util.LogContext;
import org.jfree.util.LogTarget;

public class Log {
    private int debuglevel = 100;
    private LogTarget[] logTargets;
    private HashMap logContexts = new HashMap();
    private static Log singleton;

    protected Log() {
        this.logTargets = new LogTarget[0];
    }

    public static synchronized Log getInstance() {
        if (singleton == null) {
            singleton = new Log();
        }
        return singleton;
    }

    public int getDebuglevel() {
        return this.debuglevel;
    }

    public static void debug(Object message) {
        Log.log(3, message);
    }

    public static void warn(Object message) {
        Log.log(1, message);
    }

    public static void warn(Object message, Exception e) {
        Log.log(1, message, e);
    }

    protected void doLog(int level, Object message) {
        if (level > 3) {
            level = 3;
        }
        if (level <= this.debuglevel) {
            for (int i = 0; i < this.logTargets.length; ++i) {
                LogTarget t = this.logTargets[i];
                t.log(level, message);
            }
        }
    }

    public static void log(int level, Object message) {
        Log.getInstance().doLog(level, message);
    }

    public static void log(int level, Object message, Exception e) {
        Log.getInstance().doLog(level, message, e);
    }

    protected void doLog(int level, Object message, Exception e) {
        if (level > 3) {
            level = 3;
        }
        if (level <= this.debuglevel) {
            for (int i = 0; i < this.logTargets.length; ++i) {
                LogTarget t = this.logTargets[i];
                t.log(level, message, e);
            }
        }
    }

    public static boolean isDebugEnabled() {
        return Log.getInstance().getDebuglevel() >= 3;
    }

    public static LogContext createContext(Class context) {
        return Log.createContext(context.getName());
    }

    public static LogContext createContext(String context) {
        return Log.getInstance().internalCreateContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogContext internalCreateContext(String context) {
        Log log = this;
        synchronized (log) {
            LogContext ctx = (LogContext)this.logContexts.get(context);
            if (ctx == null) {
                ctx = new LogContext(context);
                this.logContexts.put(context, ctx);
            }
            return ctx;
        }
    }

    public static class SimpleMessage {
        private String message;
        private Object[] param;

        public SimpleMessage(String message, Object param1, Object param2) {
            this.message = message;
            this.param = new Object[]{param1, param2};
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(this.message);
            if (this.param != null) {
                for (int i = 0; i < this.param.length; ++i) {
                    b.append(this.param[i]);
                }
            }
            return b.toString();
        }
    }
}

