/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.persistence.XMLPersistenceManager;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.naturalselection.developer.DeveloperControlsMenuItem;
import edu.colorado.phet.naturalselection.module.NaturalSelectionModule;
import edu.colorado.phet.naturalselection.persistence.NaturalSelectionConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.Enumeration;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class NaturalSelectionApplication
extends PiccoloPhetApplication {
    private XMLPersistenceManager persistenceManager;
    private static boolean overrideHighContrast = false;

    public NaturalSelectionApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar(phetApplicationConfig.getCommandLineArgs());
    }

    private void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        NaturalSelectionModule naturalSelectionModule = new NaturalSelectionModule(phetFrame);
        this.addModule(naturalSelectionModule);
        naturalSelectionModule.setLogoPanelVisible(false);
    }

    private void initMenubar(String[] stringArray) {
        PhetFrame phetFrame = this.getPhetFrame();
        phetFrame.addFileSaveLoadMenuItems();
        if (this.persistenceManager == null) {
            this.persistenceManager = new XMLPersistenceManager(phetFrame);
        }
        JMenu jMenu = this.getPhetFrame().getDeveloperMenu();
        jMenu.add(new DeveloperControlsMenuItem(this));
    }

    public static boolean isHighContrast() {
        if (overrideHighContrast) {
            return true;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Boolean bl = (Boolean)toolkit.getDesktopProperty("win.highContrast.on");
        return bl != null && bl != false;
    }

    public static Color accessibleColor(Color color) {
        if (NaturalSelectionApplication.isHighContrast()) {
            return null;
        }
        return color;
    }

    public static void setAccessibilityFontScale(final float f) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIDefaults uIDefaults = UIManager.getDefaults();
                Enumeration enumeration = uIDefaults.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    Object object = uIDefaults.get(k);
                    if (object == null || !(object instanceof Font)) continue;
                    UIManager.put(k, null);
                    Font font = UIManager.getFont(k);
                    if (font == null) continue;
                    float f2 = font.getSize2D();
                    UIManager.put(k, new FontUIResource(font.deriveFont(f2 * f)));
                }
            }
        });
    }

    public void save() {
        NaturalSelectionConfig naturalSelectionConfig = new NaturalSelectionConfig();
        naturalSelectionConfig.setVersionString(this.getSimInfo().getVersion().toString());
        naturalSelectionConfig.setVersionMajor(this.getSimInfo().getVersion().getMajor());
        naturalSelectionConfig.setVersionMinor(this.getSimInfo().getVersion().getMinor());
        naturalSelectionConfig.setVersionDev(this.getSimInfo().getVersion().getDev());
        naturalSelectionConfig.setVersionRevision(this.getSimInfo().getVersion().getRevision());
        ((NaturalSelectionModule)this.getModule(0)).save(naturalSelectionConfig);
        this.persistenceManager.save(naturalSelectionConfig);
    }

    public void load() {
        Object object = this.persistenceManager.load();
        if (object != null) {
            if (object instanceof NaturalSelectionConfig) {
                NaturalSelectionConfig naturalSelectionConfig = (NaturalSelectionConfig)object;
                ((NaturalSelectionModule)this.getModule(0)).load(naturalSelectionConfig);
            } else {
                String string = PhetCommonResources.getString("XMLPersistenceManager.message.notAConfigFile");
                PhetOptionPane.showErrorDialog(this.getPhetFrame(), string);
            }
        }
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        for (String string : stringArray) {
            if (!string.equals("-overrideHighContrast")) continue;
            overrideHighContrast = true;
        }
        new PhetApplicationLauncher().launchSim(stringArray, "natural-selection", NaturalSelectionApplication.class);
    }
}

