/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.control;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import edu.colorado.phet.naturalselection.dialog.PedigreeChartCanvas;
import edu.colorado.phet.naturalselection.module.NaturalSelectionModule;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DetachOptionPanel
extends JPanel {
    private PhetPCanvas detachableChild;
    private Component staticChild;
    private List<Listener> listeners = new LinkedList<Listener>();
    private JDialog dialog;
    private JPanel dialogContentPane;
    private PSwing buttonPanelPSwing;
    private String title;
    private JButton closeButton;
    private JPanel buttonPanel;

    public DetachOptionPanel(String string, PhetPCanvas phetPCanvas, Component component) {
        super(new GridLayout(1, 1));
        this.detachableChild = phetPCanvas;
        this.staticChild = component;
        this.title = string;
        this.buttonPanel = new JPanel(new FlowLayout(1, 1, 1));
        BufferedImage bufferedImage = NaturalSelectionResources.getImage("tear-20.png");
        BufferedImage bufferedImage2 = NaturalSelectionResources.getImage("x-20.png");
        JButton jButton = new JButton(new ImageIcon(BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage, 14)));
        this.closeButton = new JButton(new ImageIcon(BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage2, 14)));
        Insets insets = new Insets(2, 2, 2, 2);
        jButton.setMargin(insets);
        this.closeButton.setMargin(insets);
        this.buttonPanel.add(jButton);
        this.buttonPanel.setBackground(NaturalSelectionConstants.COLOR_GENERATION_CHART);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DetachOptionPanel.this.dialog == null || !DetachOptionPanel.this.dialog.isVisible()) {
                    DetachOptionPanel.this.onUndock();
                } else {
                    DetachOptionPanel.this.onDock();
                }
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetachOptionPanel.this.onClose();
            }
        });
        this.buttonPanelPSwing = new PSwing(this.buttonPanel);
        phetPCanvas.addScreenChild(this.buttonPanelPSwing);
        this.add(component);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DetachOptionPanel.this.updateButtonLocations();
            }
        });
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                DetachOptionPanel.this.updateButtonLocations();
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public void showDetachableChild() {
        this.removeAll();
        this.add(this.detachableChild);
        this.repaint();
        this.detachableChild.invalidate();
        this.validate();
        this.updateButtonLocations();
    }

    public void showStaticChild() {
        this.removeAll();
        this.add(this.staticChild);
        this.repaint();
        this.staticChild.invalidate();
        this.validate();
        this.updateButtonLocations();
    }

    private void updateButtonLocations() {
        double d = this.detachableChild.getWidth();
        double d2 = this.buttonPanelPSwing.getWidth();
        this.buttonPanelPSwing.setOffset(d - d2 - 3.0, 3.0);
    }

    private void setWindowed() {
        if (this.dialog == null) {
            this.createDialog();
        }
        this.buttonPanel.add(this.closeButton);
        this.dialog.pack();
        this.dialog.setLocation(this.getLocationOnScreen());
        this.dialogContentPane.add(this.detachableChild);
        this.dialog.setVisible(true);
        if (this.detachableChild instanceof PedigreeChartCanvas) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((PedigreeChartCanvas)DetachOptionPanel.this.detachableChild).setCenterPoint(0.0);
                }
            });
        }
        this.updateButtonLocations();
        this.dialogContentPane.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                DetachOptionPanel.this.updateButtonLocations();
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    private void createDialog() {
        NaturalSelectionModule naturalSelectionModule = NaturalSelectionModule.getModule();
        this.dialog = new JDialog(naturalSelectionModule.getParentFrame(), this.title);
        this.dialog.setResizable(true);
        this.dialogContentPane = new JPanel(new GridLayout(1, 1));
        Dimension dimension = new Dimension(600, 400);
        this.dialogContentPane.setSize(dimension);
        this.dialogContentPane.setPreferredSize(dimension);
        this.dialogContentPane.add(this.detachableChild);
        this.dialog.setContentPane(this.dialogContentPane);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DetachOptionPanel.this.onClose();
            }
        });
    }

    private void closeDialog() {
        this.buttonPanel.remove(this.closeButton);
        this.dialog.setVisible(false);
        this.updateButtonLocations();
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            jFrame.invalidate();
            jFrame.validate();
            jFrame.repaint();
        }
    }

    private void onDock() {
        this.closeDialog();
        this.remove(this.staticChild);
        this.add(this.detachableChild);
        this.detachableChild.invalidate();
        this.validate();
        if (this.detachableChild instanceof PedigreeChartCanvas) {
            ((PedigreeChartCanvas)this.detachableChild).setCenterPoint(0.0);
        }
        this.repaint();
        for (Listener listener : this.listeners) {
            listener.onDock();
        }
        this.updateButtonLocations();
    }

    private void onUndock() {
        this.remove(this.detachableChild);
        this.setWindowed();
        this.add(this.staticChild);
        this.staticChild.invalidate();
        this.repaint();
        this.validate();
        for (Listener listener : this.listeners) {
            listener.onUndock();
        }
        this.updateButtonLocations();
    }

    private void onClose() {
        this.closeDialog();
        for (Listener listener : this.listeners) {
            listener.onClose();
        }
        this.updateButtonLocations();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void onDock();

        public void onUndock();

        public void onClose();
    }
}

