/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.control;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.model.ColorGene;
import edu.colorado.phet.naturalselection.model.Gene;
import edu.colorado.phet.naturalselection.model.TailGene;
import edu.colorado.phet.naturalselection.model.TeethGene;
import edu.colorado.phet.naturalselection.persistence.NaturalSelectionConfig;
import edu.colorado.phet.naturalselection.util.ImagePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class GenePanel
extends JPanel {
    private JLabel colorLabel;
    private ImagePanel colorWhite;
    private ImagePanel colorBrown;
    private JRadioButton colorPD;
    private JRadioButton colorPR;
    private JRadioButton colorSD;
    private JRadioButton colorSR;
    private JLabel tailLabel;
    private ImagePanel tailRegular;
    private ImagePanel tailBig;
    private JRadioButton tailPD;
    private JRadioButton tailPR;
    private JRadioButton tailSD;
    private JRadioButton tailSR;
    private JLabel teethLabel;
    private ImagePanel teethRegular;
    private ImagePanel teethLong;
    private JRadioButton teethPD;
    private JRadioButton teethPR;
    private JRadioButton teethSD;
    private JRadioButton teethSR;
    private boolean colorEnabled;
    private boolean teethEnabled;
    private boolean tailEnabled;
    private static final Insets GENE_LABEL_INSETS = new Insets(0, 0, 0, 10);

    public GenePanel() {
        this.setLayout(new GridBagLayout());
        this.colorWhite = new ImagePanel("bunny_color_white.png");
        this.colorBrown = new ImagePanel("bunny_color_brown.png");
        boolean bl = ColorGene.getInstance().getPrimaryAllele() == ColorGene.getInstance().getDominantAllele();
        this.colorPD = this.createButton(bl);
        this.colorPR = this.createButton(!bl);
        this.colorSD = this.createButton(!bl);
        this.colorSR = this.createButton(bl);
        this.createFourGroup(ColorGene.getInstance(), this.colorPD, this.colorPR, this.colorSD, this.colorSR);
        this.tailRegular = new ImagePanel("bunny_tail_short.png");
        this.tailBig = new ImagePanel("bunny_tail_long.png");
        boolean bl2 = TailGene.getInstance().getPrimaryAllele() == TailGene.getInstance().getDominantAllele();
        this.tailPD = this.createButton(bl2);
        this.tailPR = this.createButton(!bl2);
        this.tailSD = this.createButton(!bl2);
        this.tailSR = this.createButton(bl2);
        this.createFourGroup(TailGene.getInstance(), this.tailPD, this.tailPR, this.tailSD, this.tailSR);
        this.teethRegular = new ImagePanel("bunny_teeth_short.png");
        this.teethLong = new ImagePanel("bunny_teeth_long.png");
        boolean bl3 = TeethGene.getInstance().getPrimaryAllele() == TeethGene.getInstance().getDominantAllele();
        this.teethPD = this.createButton(bl3);
        this.teethPR = this.createButton(!bl3);
        this.teethSD = this.createButton(!bl3);
        this.teethSR = this.createButton(bl3);
        this.createFourGroup(TeethGene.getInstance(), this.teethPD, this.teethPR, this.teethSD, this.teethSR);
        this.colorLabel = new JLabel(NaturalSelectionStrings.GENE_COLOR_NAME);
        this.tailLabel = new JLabel(NaturalSelectionStrings.GENE_TAIL_NAME);
        this.teethLabel = new JLabel(NaturalSelectionStrings.GENE_TEETH_NAME);
        this.setColorEnabled(false);
        this.setTailEnabled(false);
        this.setTeethEnabled(false);
        this.initLabels();
        this.initGeneArea(2, 3, this.colorLabel, this.colorWhite, this.colorBrown, this.colorPD, this.colorPR, this.colorSD, this.colorSR);
        this.initGeneArea(5, 6, this.tailLabel, this.tailRegular, this.tailBig, this.tailPD, this.tailPR, this.tailSD, this.tailSR);
        this.initGeneArea(8, 9, this.teethLabel, this.teethRegular, this.teethLong, this.teethPD, this.teethPR, this.teethSD, this.teethSR);
        this.initSeparators();
        this.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
    }

    private void initGeneArea(int n, int n2, JLabel jLabel, ImagePanel imagePanel, ImagePanel imagePanel2, JRadioButton jRadioButton, JRadioButton jRadioButton2, JRadioButton jRadioButton3, JRadioButton jRadioButton4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        this.add((Component)imagePanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2;
        this.add((Component)imagePanel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        this.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        this.add((Component)jRadioButton2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2;
        this.add((Component)jRadioButton3, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n2;
        this.add((Component)jRadioButton4, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridheight = 2;
        jLabel.setBorder(new EmptyBorder(GENE_LABEL_INSETS));
        this.add((Component)jLabel, gridBagConstraints);
    }

    private void initSeparators() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.add((Component)new JSeparator(), gridBagConstraints);
    }

    private void initLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        JLabel jLabel = new JLabel(NaturalSelectionStrings.GENE_PANEL_DOMINANT);
        jLabel.setBorder(new EmptyBorder(new Insets(0, 10, 0, 10)));
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.add((Component)new JLabel(NaturalSelectionStrings.GENE_PANEL_RECESSIVE), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        JLabel jLabel2 = new JLabel(NaturalSelectionStrings.GENE_PANEL_EDIT_GENES);
        jLabel2.setBorder(new EmptyBorder(new Insets(0, 0, 5, 0)));
        jLabel2.setFont(new PhetFont(18));
        this.add((Component)jLabel2, gridBagConstraints);
    }

    private JRadioButton createButton(boolean bl) {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setIconTextGap(0);
        jRadioButton.setSelected(bl);
        jRadioButton.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        return jRadioButton;
    }

    private void createFourGroup(final Gene gene, final JRadioButton jRadioButton, final JRadioButton jRadioButton2, final JRadioButton jRadioButton3, final JRadioButton jRadioButton4) {
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup2.add(jRadioButton3);
        buttonGroup2.add(jRadioButton4);
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenePanel.this.changeDominance(gene, true);
                if (!jRadioButton4.isSelected()) {
                    jRadioButton4.setSelected(true);
                }
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenePanel.this.changeDominance(gene, false);
                if (!jRadioButton3.isSelected()) {
                    jRadioButton3.setSelected(true);
                }
            }
        });
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenePanel.this.changeDominance(gene, false);
                if (!jRadioButton2.isSelected()) {
                    jRadioButton2.setSelected(true);
                }
            }
        });
        jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenePanel.this.changeDominance(gene, true);
                if (!jRadioButton.isSelected()) {
                    jRadioButton.setSelected(true);
                }
            }
        });
    }

    public void setColorEnabled(boolean bl) {
        this.colorEnabled = bl;
        this.colorLabel.setEnabled(bl);
        this.colorWhite.setEnabled(bl);
        this.colorBrown.setEnabled(bl);
        this.colorPD.setEnabled(bl);
        this.colorPR.setEnabled(bl);
        this.colorSD.setEnabled(bl);
        this.colorSR.setEnabled(bl);
    }

    public void setTailEnabled(boolean bl) {
        this.tailEnabled = bl;
        this.tailLabel.setEnabled(bl);
        this.tailRegular.setEnabled(bl);
        this.tailBig.setEnabled(bl);
        this.tailPD.setEnabled(bl);
        this.tailPR.setEnabled(bl);
        this.tailSD.setEnabled(bl);
        this.tailSR.setEnabled(bl);
    }

    public void setTeethEnabled(boolean bl) {
        this.teethEnabled = bl;
        this.teethLabel.setEnabled(bl);
        this.teethRegular.setEnabled(bl);
        this.teethLong.setEnabled(bl);
        this.teethPD.setEnabled(bl);
        this.teethPR.setEnabled(bl);
        this.teethSD.setEnabled(bl);
        this.teethSR.setEnabled(bl);
    }

    private void changeDominance(Gene gene, boolean bl) {
        if (bl) {
            gene.setDominantAllele(gene.getPrimaryAllele());
        } else {
            gene.setDominantAllele(gene.getSecondaryAllele());
        }
    }

    public void reset() {
        this.colorPR.setSelected(true);
        this.colorSD.setSelected(true);
        this.tailPR.setSelected(true);
        this.tailSD.setSelected(true);
        this.teethPR.setSelected(true);
        this.teethSD.setSelected(true);
        this.setColorEnabled(false);
        this.setTailEnabled(false);
        this.setTeethEnabled(false);
    }

    public void load(NaturalSelectionConfig naturalSelectionConfig) {
        this.setColorEnabled(naturalSelectionConfig.isColorMutated());
        this.setTeethEnabled(naturalSelectionConfig.isTeethMutated());
        this.setTailEnabled(naturalSelectionConfig.isTailMutated());
        if (naturalSelectionConfig.isColorRegularDominant()) {
            this.colorPD.setSelected(true);
            this.colorSR.setSelected(true);
        } else {
            this.colorPR.setSelected(true);
            this.colorSD.setSelected(true);
        }
        if (naturalSelectionConfig.isTeethRegularDominant()) {
            this.teethPD.setSelected(true);
            this.teethSR.setSelected(true);
        } else {
            this.teethPR.setSelected(true);
            this.teethSD.setSelected(true);
        }
        if (naturalSelectionConfig.isTailRegularDominant()) {
            this.tailPD.setSelected(true);
            this.tailSR.setSelected(true);
        } else {
            this.tailPR.setSelected(true);
            this.tailSD.setSelected(true);
        }
    }

    public void save(NaturalSelectionConfig naturalSelectionConfig) {
        naturalSelectionConfig.setColorMutated(this.colorEnabled);
        naturalSelectionConfig.setTeethMutated(this.teethEnabled);
        naturalSelectionConfig.setTailMutated(this.tailEnabled);
    }
}

