/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.control;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.control.DetachOptionPanel;
import edu.colorado.phet.naturalselection.model.Bunny;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SwitcherPanel
extends JPanel
implements DetachOptionPanel.Listener {
    private JRadioButton statisticsRadioButton;
    private JRadioButton pedigreeRadioButton;

    public SwitcherPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.statisticsRadioButton = new JRadioButton(NaturalSelectionStrings.STATS_POPULATION);
        this.pedigreeRadioButton = new JRadioButton(NaturalSelectionStrings.PEDIGREE_CHART);
        this.statisticsRadioButton.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.pedigreeRadioButton.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.statisticsRadioButton);
        buttonGroup.add(this.pedigreeRadioButton);
        JLabel jLabel = new JLabel(NaturalSelectionStrings.CHART);
        jLabel.setFont(new PhetFont(12, true));
        jLabel.setAlignmentX(0.0f);
        this.statisticsRadioButton.setAlignmentX(0.0f);
        this.pedigreeRadioButton.setAlignmentX(0.0f);
        this.add(jLabel);
        this.add(Box.createRigidArea(new Dimension(5, 2)));
        this.add(this.statisticsRadioButton);
        this.add(this.pedigreeRadioButton);
        this.statisticsRadioButton.setSelected(true);
        this.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
    }

    public void onDock() {
        this.statisticsRadioButton.setEnabled(true);
        this.pedigreeRadioButton.setEnabled(true);
        this.pedigreeRadioButton.setSelected(true);
    }

    public void onUndock() {
        this.statisticsRadioButton.setEnabled(false);
        this.pedigreeRadioButton.setEnabled(false);
        this.statisticsRadioButton.setSelected(true);
    }

    public void onClose() {
        this.statisticsRadioButton.setEnabled(true);
        this.pedigreeRadioButton.setEnabled(true);
        if (Bunny.getSelectedBunny() != null) {
            Bunny.getSelectedBunny().setSelected(false);
        }
    }

    public JRadioButton getStatisticsRadioButton() {
        return this.statisticsRadioButton;
    }

    public JRadioButton getPedigreeRadioButton() {
        return this.pedigreeRadioButton;
    }
}

