/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.model;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.model.Allele;
import edu.colorado.phet.naturalselection.model.ColorGene;
import edu.colorado.phet.naturalselection.model.Gene;
import edu.colorado.phet.naturalselection.model.Genotype;
import edu.colorado.phet.naturalselection.model.NaturalSelectionClock;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import edu.colorado.phet.naturalselection.model.Shrub;
import edu.colorado.phet.naturalselection.model.TailGene;
import edu.colorado.phet.naturalselection.model.TeethGene;
import edu.colorado.phet.naturalselection.persistence.BunnyConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bunny {
    private Bunny father;
    private Bunny mother;
    private Genotype colorGenotype;
    private Genotype teethGenotype;
    private Genotype tailGenotype;
    private Bunny potentialMate;
    private boolean mated = false;
    private boolean mutated = false;
    private boolean alive;
    private ArrayList<Bunny> children;
    private int age;
    private final int generation;
    public int bunnyId;
    public static int bunnyCount = 0;
    private Allele colorPhenotype;
    private Allele teethPhenotype;
    private Allele tailPhenotype;
    private static final Random random = new Random(System.currentTimeMillis());
    private Point3D position;
    private int sinceHopTime = 0;
    private boolean movingRight;
    private boolean selected = false;
    private int hunger = random.nextInt(NaturalSelectionConstants.getSettings().getBunnyMaxHunger());
    private Point3D hopDirection;
    private NaturalSelectionModel model;
    private NaturalSelectionClock.Listener clockListener;
    private ArrayList<Listener> listeners;
    private static Bunny selectedBunny = null;
    private static Bunny lastSelectedBunny = null;

    public Bunny(NaturalSelectionModel naturalSelectionModel, Bunny bunny, Bunny bunny2, int n) {
        this.model = naturalSelectionModel;
        this.bunnyId = bunnyCount++;
        this.sinceHopTime = random.nextInt(NaturalSelectionConstants.getSettings().getBunnyBetweenHopTime() + NaturalSelectionConstants.getSettings().getBunnyHopTime());
        this.movingRight = true;
        if (random.nextInt(2) == 0) {
            this.movingRight = false;
        }
        this.father = bunny;
        this.mother = bunny2;
        this.generation = n;
        this.alive = true;
        this.children = new ArrayList();
        this.listeners = new ArrayList();
        this.setAge(0);
        if (this.father == null || this.mother == null) {
            this.colorGenotype = new Genotype(ColorGene.getInstance(), ColorGene.WHITE_ALLELE, ColorGene.WHITE_ALLELE);
            this.teethGenotype = new Genotype(TeethGene.getInstance(), TeethGene.TEETH_SHORT_ALLELE, TeethGene.TEETH_SHORT_ALLELE);
            this.tailGenotype = new Genotype(TailGene.getInstance(), TailGene.TAIL_SHORT_ALLELE, TailGene.TAIL_SHORT_ALLELE);
        } else {
            this.colorGenotype = Bunny.combineGenotypes(this.father.getColorGenotype(), this.mother.getColorGenotype());
            this.teethGenotype = Bunny.combineGenotypes(this.father.getTeethGenotype(), this.mother.getTeethGenotype());
            this.tailGenotype = Bunny.combineGenotypes(this.father.getTailGenotype(), this.mother.getTailGenotype());
        }
        this.colorPhenotype = this.colorGenotype.getPhenotype();
        this.teethPhenotype = this.teethGenotype.getPhenotype();
        this.tailPhenotype = this.tailGenotype.getPhenotype();
        this.addListener(ColorGene.getInstance());
        this.addListener(TeethGene.getInstance());
        this.addListener(TailGene.getInstance());
        this.setInitialPosition();
        this.clockListener = new NaturalSelectionClock.Listener(){

            public void onTick(ClockEvent clockEvent) {
                Bunny.this.onPhysicalTick(clockEvent);
            }
        };
        naturalSelectionModel.getClock().addPhysicalListener(this.clockListener);
    }

    public BunnyConfig getConfig() {
        BunnyConfig bunnyConfig = new BunnyConfig();
        bunnyConfig.setId(this.bunnyId);
        if (this.potentialMate != null) {
            bunnyConfig.setPotentialMateId(this.potentialMate.bunnyId);
        } else {
            bunnyConfig.setPotentialMateId(-1);
        }
        bunnyConfig.setMated(this.mated);
        bunnyConfig.setMutated(this.mutated);
        bunnyConfig.setAlive(this.alive);
        if (this.mated) {
            int[] nArray = new int[this.children.size()];
            int n = 0;
            for (Bunny bunny : this.children) {
                nArray[n++] = bunny.getId();
            }
            bunnyConfig.setChildrenIds(nArray);
        } else {
            bunnyConfig.setChildrenIds(new int[0]);
        }
        bunnyConfig.setFatherId(this.father != null ? this.father.getId() : -1);
        bunnyConfig.setMotherId(this.mother != null ? this.mother.getId() : -1);
        bunnyConfig.setAge(this.age);
        bunnyConfig.setGeneration(this.generation);
        bunnyConfig.setColorPhenotypeRegular(this.colorPhenotype == ColorGene.WHITE_ALLELE);
        bunnyConfig.setTeethPhenotypeRegular(this.teethPhenotype == TeethGene.TEETH_SHORT_ALLELE);
        bunnyConfig.setTailPhenotypeRegular(this.tailPhenotype == TailGene.TAIL_SHORT_ALLELE);
        bunnyConfig.setColorFatherGenotypeRegular(this.colorGenotype.getFatherAllele() == ColorGene.WHITE_ALLELE);
        bunnyConfig.setTeethFatherGenotypeRegular(this.teethGenotype.getFatherAllele() == TeethGene.TEETH_SHORT_ALLELE);
        bunnyConfig.setTailFatherGenotypeRegular(this.tailGenotype.getFatherAllele() == TailGene.TAIL_SHORT_ALLELE);
        bunnyConfig.setColorMotherGenotypeRegular(this.colorGenotype.getMotherAllele() == ColorGene.WHITE_ALLELE);
        bunnyConfig.setTeethMotherGenotypeRegular(this.teethGenotype.getMotherAllele() == TeethGene.TEETH_SHORT_ALLELE);
        bunnyConfig.setTailMotherGenotypeRegular(this.tailGenotype.getMotherAllele() == TailGene.TAIL_SHORT_ALLELE);
        bunnyConfig.setX(this.position.getX());
        bunnyConfig.setY(this.position.getY());
        bunnyConfig.setZ(this.position.getZ());
        bunnyConfig.setSinceHopTime(this.sinceHopTime);
        bunnyConfig.setMovingRight(this.movingRight);
        bunnyConfig.setHunger(this.hunger);
        bunnyConfig.setHopX(this.hopDirection.getX());
        bunnyConfig.setHopY(this.hopDirection.getY());
        bunnyConfig.setHopZ(this.hopDirection.getZ());
        return bunnyConfig;
    }

    public boolean isMovingRight() {
        return this.movingRight;
    }

    private void setInitialPosition() {
        double d;
        this.position = this.model.getLandscape().getRandomGroundPosition();
        if (this.model.getSelectionFactor() == 1) {
            d = Double.POSITIVE_INFINITY;
            for (Shrub shrub : this.model.getShrubs()) {
                for (Shrub shrub2 : this.model.getShrubs()) {
                    if (shrub == shrub2) continue;
                    d = Math.min(d, Point3D.distance(shrub.getPosition(), shrub2.getPosition()));
                }
            }
            double d2 = d * 0.5;
            boolean bl = this.teethPhenotype == TeethGene.TEETH_SHORT_ALLELE;
            while (bl != this.getDistanceFromShrubs() > d2 && !(Math.random() < 0.3)) {
                this.position = this.model.getLandscape().getRandomGroundPosition();
            }
        }
        d = this.model.getLandscape().getMaximumX(this.position.getZ());
        this.position.setLocation(this.position.getX() * (d - NaturalSelectionConstants.getSettings().getBunnySideSpacer()) / d, this.position.getY(), this.position.getZ());
    }

    private double getDistanceFromShrubs() {
        double d = Double.POSITIVE_INFINITY;
        for (Shrub shrub : this.model.getShrubs()) {
            d = Math.min(d, Point3D.distance(this.position, shrub.getPosition()));
        }
        return d;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void die() {
        if (!this.isAlive()) {
            return;
        }
        this.alive = false;
        this.setSelected(false);
        this.notifyDeath();
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int n) {
        this.age = n;
        if (this.isAlive() && this.age >= NaturalSelectionConstants.getSettings().getBunniesDieWhenTheyAreThisOld()) {
            if (this.model.isFriendAdded() && this.model.getGeneration() == 0) {
                return;
            }
            this.die();
        }
    }

    public ArrayList<Bunny> getChildren() {
        return this.children;
    }

    public void ageMe() {
        this.setAge(this.getAge() + 1);
        if (this.isAlive()) {
            this.notifyAging();
        }
    }

    public Genotype getColorGenotype() {
        return this.colorGenotype;
    }

    public Genotype getTeethGenotype() {
        return this.teethGenotype;
    }

    public Genotype getTailGenotype() {
        return this.tailGenotype;
    }

    public Allele getColorPhenotype() {
        return this.colorPhenotype;
    }

    public Allele getTeethPhenotype() {
        return this.teethPhenotype;
    }

    public Allele getTailPhenotype() {
        return this.tailPhenotype;
    }

    public void setPotentialMate(Bunny bunny) {
        if (bunny == null) {
            System.out.println("WARNING: setting potential mate to null on " + this);
        }
        this.potentialMate = bunny;
    }

    public Point3D getPosition() {
        return this.position;
    }

    public boolean isMutated() {
        return this.mutated;
    }

    public int getId() {
        return this.bunnyId;
    }

    public void setId(int n) {
        this.bunnyId = n;
    }

    public NaturalSelectionModel getModel() {
        return this.model;
    }

    public void reproduce(Bunny[] bunnyArray) {
        for (int i = 0; i < bunnyArray.length; ++i) {
            this.children.add(bunnyArray[i]);
        }
        this.mated = true;
        this.notifyReproduces();
    }

    private Point3D getNewHopDirection() {
        double d = NaturalSelectionConstants.getSettings().getBunnyNormalHopDistance();
        if (this.hunger > NaturalSelectionConstants.getSettings().getBunnyHungerThreshold() && this.model.getSelectionFactor() == 1 && this.teethPhenotype == TeethGene.TEETH_LONG_ALLELE) {
            List<Shrub> list = this.model.getShrubs();
            double d2 = Double.POSITIVE_INFINITY;
            Point3D point3D = null;
            Point3D point3D2 = this.getPosition();
            for (Shrub shrub : list) {
                Point3D point3D3 = shrub.getPosition();
                double d3 = Point3D.distance(point3D2, point3D3);
                if (!(d3 < d2)) continue;
                d2 = d3;
                point3D = point3D3;
            }
            if (point3D == null) {
                throw new RuntimeException("No shrubs?");
            }
            double d4 = point3D.getX() - point3D2.getX();
            double d5 = point3D.getZ() - point3D2.getZ();
            this.movingRight = d4 >= 0.0;
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (d6 > d) {
                d4 *= d / d6;
                d5 *= d / d6;
            } else {
                this.hunger = 0;
                this.sinceHopTime = 0;
                if (this.teethPhenotype == TeethGene.TEETH_LONG_ALLELE) {
                    this.sinceHopTime = -20;
                }
                this.movingRight = random.nextInt(2) == 0;
            }
            return new Point3D.Double(d4 *= 0.7, 0.0, d5 *= 0.7);
        }
        double d7 = Math.random() * Math.PI * 2.0;
        double d8 = d * Math.cos(d7);
        double d9 = d * Math.sin(d7);
        boolean bl = Math.abs(d8) < Math.abs(d9);
        Point3D.Double double_ = new Point3D.Double(Math.abs(bl ? d9 : d8), 0.0, bl ? d8 : d9);
        double d10 = this.getMaxX();
        if (this.movingRight && this.position.getX() + double_.getX() > d10) {
            this.movingRight = false;
        }
        if (!this.movingRight && this.position.getX() - double_.getX() < -d10) {
            this.movingRight = true;
        }
        if (!this.movingRight) {
            double_.setLocation(-double_.getX(), 0.0, double_.getZ());
        }
        return double_;
    }

    private void moveAround() {
        this.hunger += random.nextInt(3);
        if (this.hunger > NaturalSelectionConstants.getSettings().getBunnyMaxHunger()) {
            this.hunger = NaturalSelectionConstants.getSettings().getBunnyMaxHunger();
        }
        int n = NaturalSelectionConstants.getSettings().getBunnyBetweenHopTime();
        double d = NaturalSelectionConstants.getSettings().getBunnyHopTime();
        double d2 = NaturalSelectionConstants.getSettings().getBunnyHopHeight();
        ++this.sinceHopTime;
        if ((double)this.sinceHopTime > (double)n + d) {
            this.sinceHopTime = 0;
        }
        if (this.sinceHopTime == n) {
            this.hopDirection = this.getNewHopDirection();
        } else if (this.hopDirection == null) {
            this.hopDirection = this.getNewHopDirection();
        }
        if (this.sinceHopTime > n) {
            int n2 = this.sinceHopTime - n;
            double d3 = (double)n2 / d;
            double d4 = this.position.getX() + this.hopDirection.getX() / d;
            double d5 = this.position.getZ() + this.hopDirection.getZ() / d;
            double d6 = this.model.getLandscape().getGroundY(d4, d5) + d2 * 2.0 * (-d3 * d3 + d3);
            this.setPosition(new Point3D.Double(d4, d6, d5));
            if (this.movingRight) {
                if (this.position.getX() >= this.getMaxX()) {
                    this.movingRight = false;
                    this.hopDirection.setLocation(-this.hopDirection.getX(), 0.0, this.hopDirection.getZ());
                    --this.sinceHopTime;
                }
            } else if (this.position.getX() <= -this.getMaxX()) {
                this.movingRight = true;
                this.hopDirection.setLocation(-this.hopDirection.getX(), 0.0, this.hopDirection.getZ());
                --this.sinceHopTime;
            }
            if (this.position.getZ() >= this.getMaxZ() || this.position.getZ() <= this.getMinZ()) {
                this.hopDirection.setLocation(this.hopDirection.getX(), 0.0, -this.hopDirection.getZ());
                --this.sinceHopTime;
            }
        }
    }

    private double getMaxX() {
        return this.model.getLandscape().getMaximumX(this.position.getZ()) - NaturalSelectionConstants.getSettings().getBunnySideSpacer();
    }

    private double getMinZ() {
        return 150.0;
    }

    private double getMaxZ() {
        return 300.0;
    }

    public void setPosition(Point3D point3D) {
        this.position = point3D;
        this.notifyChangePosition();
    }

    public Bunny getFather() {
        return this.father;
    }

    public Bunny getMother() {
        return this.mother;
    }

    public void mutateGene(Gene gene, Allele allele) {
        this.mutated = true;
        if (gene == ColorGene.getInstance()) {
            this.colorPhenotype = allele;
            this.colorGenotype = new Genotype(gene, allele, allele);
        } else if (gene == TailGene.getInstance()) {
            this.tailPhenotype = allele;
            this.tailGenotype = new Genotype(gene, allele, allele);
        } else if (gene == TeethGene.getInstance()) {
            this.teethPhenotype = allele;
            this.teethGenotype = new Genotype(gene, allele, allele);
        }
    }

    public void setColorGenotype(Genotype genotype) {
        this.colorGenotype = genotype;
    }

    public void setTeethGenotype(Genotype genotype) {
        this.teethGenotype = genotype;
    }

    public void setTailGenotype(Genotype genotype) {
        this.tailGenotype = genotype;
    }

    public void setMated(boolean bl) {
        this.mated = bl;
    }

    public void setMutated(boolean bl) {
        this.mutated = bl;
    }

    public void setAlive(boolean bl) {
        this.alive = bl;
    }

    public void setColorPhenotype(Allele allele) {
        this.colorPhenotype = allele;
    }

    public void setTeethPhenotype(Allele allele) {
        this.teethPhenotype = allele;
    }

    public void setTailPhenotype(Allele allele) {
        this.tailPhenotype = allele;
    }

    public void setSinceHopTime(int n) {
        this.sinceHopTime = n;
    }

    public void setMovingRight(boolean bl) {
        this.movingRight = bl;
    }

    public void setHunger(int n) {
        this.hunger = n;
    }

    public void setHopDirection(Point3D point3D) {
        this.hopDirection = point3D;
    }

    public static synchronized boolean isBunnySelected() {
        return selectedBunny != null && selectedBunny.isSelected();
    }

    public static synchronized Bunny getSelectedBunny() {
        if (Bunny.isBunnySelected()) {
            return selectedBunny;
        }
        return null;
    }

    public static synchronized void reset() {
        if (Bunny.isBunnySelected()) {
            selectedBunny.setSelected(false);
        }
        selectedBunny = null;
        lastSelectedBunny = null;
    }

    public synchronized boolean isSelected() {
        return this.selected;
    }

    public synchronized void setSelected(boolean bl) {
        if (this.selected == bl) {
            return;
        }
        if (bl && Bunny.isBunnySelected()) {
            selectedBunny.setSelected(false);
        }
        this.selected = bl;
        if (bl) {
            selectedBunny = this;
            lastSelectedBunny = this;
        } else {
            selectedBunny = null;
        }
        this.notifySelectionChange();
    }

    private void onPhysicalTick(ClockEvent clockEvent) {
        if (this.isAlive()) {
            this.moveAround();
        } else {
            this.model.getClock().removePhysicalListener(this.clockListener);
        }
    }

    public static Genotype combineGenotypes(Genotype genotype, Genotype genotype2) {
        if (genotype.getGene() != genotype2.getGene()) {
            throw new RuntimeException("Genotype mismatch");
        }
        return new Genotype(genotype.getGene(), genotype.getNextChildAllele(), genotype2.getNextChildAllele());
    }

    public static Bunny[] mateBunnies(Bunny bunny, Bunny bunny2, int n) {
        Bunny bunny3 = new Bunny(bunny.getModel(), bunny, bunny2, n);
        Bunny bunny4 = new Bunny(bunny.getModel(), bunny, bunny2, n);
        Bunny bunny5 = new Bunny(bunny.getModel(), bunny, bunny2, n);
        Bunny bunny6 = new Bunny(bunny.getModel(), bunny, bunny2, n);
        bunny3.setPotentialMate(bunny4);
        bunny4.setPotentialMate(bunny3);
        bunny5.setPotentialMate(bunny6);
        bunny6.setPotentialMate(bunny5);
        Bunny[] bunnyArray = new Bunny[]{bunny3, bunny4, bunny5, bunny6};
        bunny.reproduce(bunnyArray);
        bunny2.reproduce(bunnyArray);
        return bunnyArray;
    }

    public void notifyInit() {
        this.notifyListenersOfEvent(new Event(this, 0));
    }

    private void notifyDeath() {
        this.notifyListenersOfEvent(new Event(this, 1));
    }

    private void notifyReproduces() {
        this.notifyListenersOfEvent(new Event(this, 2));
    }

    private void notifyAging() {
        this.notifyListenersOfEvent(new Event(this, 3));
    }

    private void notifyChangePosition() {
        Event event = new Event(this, 4);
        event.setPosition(this.position.getX(), this.position.getY(), this.position.getZ());
        this.notifyListenersOfEvent(event);
    }

    private void notifySelectionChange() {
        this.notifyListenersOfEvent(new Event(this, 5));
    }

    private void notifyListenersOfEvent(Event event) {
        Iterator<Listener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onEvent(event);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public String toString() {
        String string = "#" + String.valueOf(this.bunnyId) + "[ " + this.colorGenotype + " " + this.teethGenotype + " " + this.tailGenotype + " (";
        string = string + this.colorPhenotype.toString();
        string = string + this.teethPhenotype.toString();
        string = string + this.tailPhenotype.toString();
        string = string + ")]";
        return string;
    }

    public class Event {
        public final int type;
        public final Bunny bunny;
        private Point3D position;

        public Event(Bunny bunny2, int n) {
            this.bunny = bunny2;
            this.type = n;
        }

        public Bunny getBunny() {
            return this.bunny;
        }

        public Point3D getPosition() {
            return this.position;
        }

        private void setPosition(double d, double d2, double d3) {
            this.position = new Point3D.Double(d, d2, d3);
        }
    }

    public static interface Listener {
        public void onEvent(Event var1);
    }
}

