/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.model.NaturalSelectionClock;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import edu.colorado.phet.naturalselection.model.TeethGene;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Famine
implements NaturalSelectionClock.Listener {
    private double startTime;
    private double duration;
    private NaturalSelectionClock clock;
    private NaturalSelectionModel model;
    private boolean running = true;
    private ArrayList<Listener> listeners;
    private List<Bunny> targets = new LinkedList<Bunny>();
    private int totalTargets;

    public Famine(NaturalSelectionModel naturalSelectionModel, double d) {
        this.model = naturalSelectionModel;
        this.duration = d;
        this.listeners = new ArrayList();
        this.clock = naturalSelectionModel.getClock();
        this.startTime = this.clock.getSimulationTime();
        this.clock.addPhysicalListener(this);
    }

    public void init() {
        this.initializeTargets();
    }

    private void initializeTargets() {
        double d = NaturalSelectionConstants.getSettings().getFoodSelectionBunnyOffset();
        double d2 = NaturalSelectionConstants.getSettings().getFoodSelectionBunnyExponent();
        double d3 = NaturalSelectionConstants.getSettings().getFoodSelectionScale();
        double d4 = NaturalSelectionConstants.getSettings().getFoodSelectionBlendScale();
        double d5 = NaturalSelectionConstants.getSettings().getMaxKillFraction();
        Iterator<Bunny> iterator = this.model.getBunnyList().iterator();
        double d6 = Math.pow((double)this.model.getPopulation() + d, d2) * d3;
        while (iterator.hasNext()) {
            Bunny bunny = iterator.next();
            if (!bunny.isAlive()) continue;
            double d7 = d6;
            if (bunny.getTeethPhenotype() == TeethGene.TEETH_LONG_ALLELE) {
                d7 *= d4;
            }
            if (d7 > d5) {
                d7 = d5;
            }
            if (!(Math.random() < d7)) continue;
            this.targets.add(bunny);
        }
        this.totalTargets = this.targets.size();
    }

    public double getTimeLeft() {
        return (this.startTime + this.duration - this.clock.getSimulationTime()) * 1000.0 / (double)NaturalSelectionConstants.getSettings().getClockFrameRate();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void onTick(ClockEvent clockEvent) {
        this.notifyFamineTimeLeft();
        if (this.startTime + this.duration <= clockEvent.getSimulationTime()) {
            this.endFamine();
        } else if (this.targets.isEmpty()) {
            this.endFamine();
        }
        double d = 1.0 - (this.duration - (clockEvent.getSimulationTime() - this.startTime)) / this.duration;
        int n = (int)(d * (double)this.totalTargets) + 1;
        int n2 = this.totalTargets - n;
        while (!this.targets.isEmpty() && this.targets.size() > n2) {
            Bunny bunny = this.targets.get(0);
            bunny.die();
            this.targets.remove(bunny);
        }
    }

    public void endFamine() {
        if (!this.running) {
            return;
        }
        this.clock.removePhysicalListener(this);
        this.model.endFamine();
        this.running = false;
        this.notifyFamineStop();
    }

    private void notifyFamineStop() {
        Iterator<Listener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onFamineStop(this);
        }
    }

    private void notifyFamineTimeLeft() {
        Iterator<Listener> iterator = this.listeners.iterator();
        double d = this.getTimeLeft();
        while (iterator.hasNext()) {
            iterator.next().onFamineTimeLeft(d);
        }
    }

    public static interface Listener {
        public void onFamineStop(Famine var1);

        public void onFamineTimeLeft(double var1);
    }
}

