/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.model;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.model.Bunny;
import edu.colorado.phet.naturalselection.model.Frenzy;
import edu.colorado.phet.naturalselection.model.NaturalSelectionClock;
import edu.colorado.phet.naturalselection.model.NaturalSelectionModel;
import java.util.ArrayList;
import java.util.Random;

public class Wolf
implements NaturalSelectionClock.Listener {
    private Point3D position;
    private boolean movingRight;
    private ArrayList<Listener> listeners;
    private NaturalSelectionModel model;
    private boolean enabled = true;
    private boolean hunting = true;
    private Bunny target;
    private Frenzy frenzy;
    private static final Random random = new Random(System.currentTimeMillis());

    public Wolf(NaturalSelectionModel naturalSelectionModel, Frenzy frenzy) {
        this.model = naturalSelectionModel;
        this.frenzy = frenzy;
        this.movingRight = true;
        if (random.nextInt(2) == 0) {
            this.movingRight = false;
        }
        this.listeners = new ArrayList();
        this.position = naturalSelectionModel.getLandscape().getRandomGroundPosition();
        naturalSelectionModel.getClock().addPhysicalListener(this);
        this.getNewTarget();
    }

    private void getNewTarget() {
        this.target = this.frenzy.getNewWolfTarget(this);
    }

    public void disable() {
        if (this.enabled) {
            this.model.getClock().removePhysicalListener(this);
        }
        this.enabled = false;
    }

    public Point3D getPosition() {
        return this.position;
    }

    public boolean isMovingRight() {
        return this.movingRight;
    }

    public Bunny getTarget() {
        return this.target;
    }

    private void setX(double d) {
        this.position = new Point3D.Double(d, this.position.getY(), this.position.getZ());
    }

    public void stopHunting() {
        this.hunting = false;
        this.movingRight = this.getPosition().getX() > 0.0;
    }

    private void moveAround() {
        double d = NaturalSelectionConstants.getSettings().getWolfKillDistance();
        double d2 = NaturalSelectionConstants.getSettings().getWolfDoubleBackDistance();
        double d3 = NaturalSelectionConstants.getSettings().getWolfMaxStep();
        if (this.hunting) {
            double d4;
            if (this.target == null) {
                this.stopHunting();
                return;
            }
            if (!this.target.isAlive()) {
                this.getNewTarget();
            }
            if (this.target == null) {
                this.stopHunting();
                return;
            }
            double d5 = this.position.getX();
            double d6 = this.position.getY();
            double d7 = this.position.getZ();
            Point3D point3D = this.target.getPosition();
            double d8 = point3D.getX();
            double d9 = point3D.getY();
            double d10 = point3D.getZ();
            double d11 = this.model.getLandscape().getGroundY(d8, d10);
            boolean bl = d5 > d8;
            double d12 = bl ? d8 + this.model.getLandscape().landscapeDistanceToModel(Wolf.wolfScale(this.position) * 490.0 / 2.0, d7) : d8 - this.model.getLandscape().landscapeDistanceToModel(Wolf.wolfScale(this.position) * 490.0 / 2.0, d7);
            boolean bl2 = d5 > d12;
            double d13 = 0.0;
            double d14 = 0.0;
            boolean bl3 = true;
            if (bl == bl2 && bl != this.movingRight) {
                d13 = d8;
                d14 = d10;
                d4 = Point3D.distance(d12, 0.0, d10, d5, 0.0, d7);
                if (d4 < d) {
                    this.target.die();
                    this.notifyKilledBunny();
                }
            } else if (bl == bl2 && Math.abs(d12 - d5) >= d2 && bl == this.movingRight) {
                this.movingRight = !bl;
                bl3 = false;
            } else {
                this.movingRight = bl;
                d13 = bl ? d12 + d2 + 10.0 : d12 - d2 - 10.0;
                d14 = d10;
            }
            if (bl3) {
                d4 = d13 - d5;
                double d15 = d14 - d7;
                double d16 = Math.sqrt(d4 * d4 + d15 * d15);
                if (d16 > d3) {
                    d4 = d3 * d4 / d16;
                    d15 = d3 * d15 / d16;
                }
                double d17 = d5 + d4;
                double d18 = d7 + d15;
                this.position = new Point3D.Double(d17, this.model.getLandscape().getGroundY(d17, d18), d18);
            }
        } else if (this.movingRight) {
            this.setX(this.position.getX() + d3);
        } else {
            this.setX(this.position.getX() - d3);
        }
        this.notifyPositionChanged();
    }

    public static double wolfScale(Point3D point3D) {
        return 37.5 / point3D.getZ();
    }

    public void onTick(ClockEvent clockEvent) {
        this.moveAround();
    }

    public boolean isFlipped() {
        return !this.movingRight;
    }

    private void notifyPositionChanged() {
        this.notifyListenersOfEvent(new Event(this, 0));
    }

    private void notifyKilledBunny() {
        this.notifyListenersOfEvent(new Event(this, 1));
    }

    private void notifyListenersOfEvent(Event event) {
        for (Listener listener : this.listeners) {
            listener.onEvent(event);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public class Event {
        public final int type;
        public final Wolf wolf;

        public Event(Wolf wolf2, int n) {
            this.type = n;
            this.wolf = wolf2;
        }
    }

    public static interface Listener {
        public void onEvent(Event var1);
    }
}

