/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.util;

import edu.colorado.phet.naturalselection.NaturalSelectionApplication;
import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private BufferedImage image;
    private boolean enabled = true;

    public ImagePanel(String string) {
        this.image = NaturalSelectionResources.getImage(string);
        this.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.repaint();
        }
    }

    public void paintComponent(Graphics graphics) {
        Color color = NaturalSelectionConstants.COLOR_CONTROL_PANEL;
        if (NaturalSelectionApplication.isHighContrast()) {
            color = Color.BLACK;
        }
        if (this.enabled) {
            graphics.drawImage(this.image, 0, 0, color, null);
        } else {
            graphics.drawImage(this.image, 0, 0, color, null);
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 175);
            graphics.setColor(color2);
            graphics.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        }
    }
}

