/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view.sprites;

import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import edu.colorado.phet.naturalselection.model.Shrub;
import edu.colorado.phet.naturalselection.view.LandscapeNode;
import edu.colorado.phet.naturalselection.view.sprites.NaturalSelectionSprite;
import edu.colorado.phet.naturalselection.view.sprites.Rescalable;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.Point2D;

public class ShrubNode
extends NaturalSelectionSprite
implements Rescalable {
    private final double baseScale;
    private PImage shrubImage;
    private Shrub shrub;
    private LandscapeNode landscapeNode;

    public ShrubNode(LandscapeNode landscapeNode, Shrub shrub) {
        super(landscapeNode, shrub.getPosition());
        this.landscapeNode = landscapeNode;
        this.shrub = shrub;
        this.baseScale = shrub.getBaseScale();
        this.shrubImage = NaturalSelectionResources.getImageNode("shrub.png");
        Point2D point2D = NaturalSelectionConstants.IMAGE_SHRUB_OFFSET;
        this.shrubImage.setOffset(point2D.getX() - this.shrubImage.getWidth() / 2.0, point2D.getY() - this.shrubImage.getHeight());
        this.addChild(this.shrubImage);
        this.rescale();
        this.setPickable(false);
    }

    public void rescale() {
        double d = this.baseScale * this.landscapeNode.getSpriteTransform().getScaleY();
        this.setScale(d);
    }
}

