/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.view.sprites;

import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import edu.colorado.phet.naturalselection.model.Tree;
import edu.colorado.phet.naturalselection.view.LandscapeNode;
import edu.colorado.phet.naturalselection.view.sprites.NaturalSelectionSprite;
import edu.colorado.phet.naturalselection.view.sprites.Rescalable;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.Point2D;

public class TreeNode
extends NaturalSelectionSprite
implements Rescalable {
    private final double baseScale;
    private PImage treeImage;

    public TreeNode(LandscapeNode landscapeNode, Tree tree) {
        super(landscapeNode, tree.getPosition());
        this.baseScale = tree.getBaseScale();
        this.treeImage = NaturalSelectionResources.getImageNode("tree.png");
        Point2D point2D = NaturalSelectionConstants.IMAGE_TREE_OFFSET;
        this.treeImage.setOffset(point2D.getX() - this.treeImage.getWidth() / 2.0, point2D.getY() - this.treeImage.getHeight());
        this.addChild(this.treeImage);
        this.rescale();
        this.setPickable(false);
    }

    public void rescale() {
        double d = this.baseScale * this.landscapeNode.getSpriteTransform().getScaleY();
        this.setScale(d);
    }
}

