/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule;

import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.BuildAMoleculeSimSharing;
import edu.colorado.phet.buildamolecule.BuildAMoleculeStrings;
import edu.colorado.phet.buildamolecule.model.MoleculeList;
import edu.colorado.phet.buildamolecule.module.AbstractBuildAMoleculeModule;
import edu.colorado.phet.buildamolecule.module.CollectMultipleModule;
import edu.colorado.phet.buildamolecule.module.LargerMoleculesModule;
import edu.colorado.phet.buildamolecule.module.MakeMoleculeModule;
import edu.colorado.phet.buildamolecule.tests.MoleculeTableDialog;
import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.controls.ColorControl;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBoxMenuItem;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BuildAMoleculeApplication
extends PiccoloPhetApplication {
    public static final Property<Boolean> allowBondBreaking = new Property<Boolean>(true);
    private static final GameAudioPlayer audioPlayer = new GameAudioPlayer(true){
        {
            this.init();
        }
    };
    public static final Property<Boolean> soundEnabled = new Property<Boolean>(true);

    public BuildAMoleculeApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar();
    }

    private void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        MakeMoleculeModule makeMoleculeModule = new MakeMoleculeModule(phetFrame);
        this.addModule(makeMoleculeModule);
        CollectMultipleModule collectMultipleModule = new CollectMultipleModule(phetFrame);
        this.addModule(collectMultipleModule);
        LargerMoleculesModule largerMoleculesModule = new LargerMoleculesModule(phetFrame);
        this.addModule(largerMoleculesModule);
    }

    private void initMenubar() {
        final PhetFrame phetFrame = this.getPhetFrame();
        OptionsMenu optionsMenu = new OptionsMenu();
        optionsMenu.add(new JMenuItem(BuildAMoleculeStrings.RESET_CURRENT_TAB){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BuildAMoleculeApplication.this.getActiveModule().reset();
                        SimSharingManager.sendUserMessage(BuildAMoleculeSimSharing.UserComponent.resetCurrentTab, UserComponentTypes.menuItem, UserActions.activated);
                    }
                });
            }
        });
        if (optionsMenu.getMenuComponentCount() > 0) {
            phetFrame.addMenu(optionsMenu);
        }
        JMenu jMenu = phetFrame.getDeveloperMenu();
        jMenu.add(new JMenuItem("Show Table of Molecules"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new MoleculeTableDialog(BuildAMoleculeApplication.this.getPhetFrame()).setVisible(true);
                    }
                });
            }
        });
        jMenu.add(new JMenuItem("Regenerate model"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((AbstractBuildAMoleculeModule)BuildAMoleculeApplication.this.getActiveModule()).addGeneratedCollection();
                    }
                });
            }
        });
        jMenu.add(new PropertyCheckBoxMenuItem("Enable bond breaking", allowBondBreaking));
        jMenu.add(new JMenuItem("Change Filled Collection Box Color"){
            {
                super(string);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new JDialog(phetFrame){
                            {
                                this.setTitle("Build a Molecule Colors");
                                this.setResizable(false);
                                final ColorControl colorControl = new ColorControl(phetFrame, "box highlight:", BuildAMoleculeConstants.MOLECULE_COLLECTION_BOX_HIGHLIGHT.get());
                                colorControl.addChangeListener(new ChangeListener(){

                                    public void stateChanged(ChangeEvent changeEvent) {
                                        BuildAMoleculeConstants.MOLECULE_COLLECTION_BOX_HIGHLIGHT.set(colorControl.getColor());
                                    }
                                });
                                this.setContentPane(colorControl);
                                this.pack();
                                SwingUtils.centerInParent(this);
                            }
                        }.setVisible(true);
                    }
                });
            }
        });
        jMenu.add(new JMenuItem("Trigger complete dialog"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((AbstractBuildAMoleculeModule)BuildAMoleculeApplication.this.getActiveModule()).getCanvas().getCurrentCollection().allCollectionBoxesFilled.set(true);
                    }
                });
            }
        });
        jMenu.add(new JMenuItem("Load additional data for profiling"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        MoleculeList.testLoadingForProfiling();
                    }
                });
            }
        });
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        MoleculeList.startInitialization();
        new PhetApplicationLauncher().launchSim(stringArray, "build-a-molecule", BuildAMoleculeApplication.class);
    }

    public static void playCollectionBoxFilledSound() {
        if (soundEnabled.get().booleanValue()) {
            audioPlayer.correctAnswer();
        }
    }
}

