/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.control;

import edu.colorado.phet.buildamolecule.BuildAMoleculeStrings;
import edu.colorado.phet.buildamolecule.control.CollectionBoxNode;
import edu.colorado.phet.buildamolecule.model.CollectionBox;
import edu.colorado.phet.buildamolecule.model.CompleteMolecule;
import edu.colorado.phet.buildamolecule.model.MoleculeList;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleCollectionBoxNode
extends CollectionBoxNode {
    private static double maxWidth = 0.0;
    private static double maxHeight = 0.0;

    public MultipleCollectionBoxNode(final CollectionBox collectionBox, Function1<PNode, Rectangle2D> function1) {
        super(collectionBox, function1);
        this.addHeaderNode(new PNode(){
            {
                HTMLNode hTMLNode = new HTMLNode(MessageFormat.format(BuildAMoleculeStrings.COLLECTION_MULTIPLE_GOAL_FORMAT, collectionBox.getCapacity(), collectionBox.getMoleculeType().getGeneralFormulaFragment())){
                    {
                        this.setFont(new PhetFont(15, true));
                    }
                };
                this.addChild(hTMLNode);
            }
        });
        this.addHeaderNode(new HTMLNode(){
            {
                this.setFont(new PhetFont(14));
                collectionBox.quantity.addObserver(new SimpleObserver(){

                    public void update() {
                        if (collectionBox.quantity.get() == 0) {
                            this.setHTML("<sub> </sub>" + BuildAMoleculeStrings.COLLECTION_MULTIPLE_QUANTITY_EMPTY + "<sub> </sub>");
                        } else {
                            this.setHTML(MessageFormat.format("<sub> </sub>" + BuildAMoleculeStrings.COLLECTION_MULTIPLE_QUANTITY_FORMAT + "<sub> </sub>", collectionBox.quantity.get(), collectionBox.getMoleculeType().getGeneralFormulaFragment()));
                        }
                    }
                });
            }
        });
    }

    public static double getMaxWidth() {
        return maxWidth;
    }

    public static double getMaxHeight() {
        return maxHeight;
    }

    static {
        for (CompleteMolecule completeMolecule : MoleculeList.COLLECTION_BOX_MOLECULES) {
            PBounds pBounds = new MultipleCollectionBoxNode(new CollectionBox(completeMolecule, 1), new Function1<PNode, Rectangle2D>(){

                @Override
                public Rectangle2D apply(PNode pNode) {
                    return null;
                }
            }).getFullBounds();
            maxWidth = Math.max(maxWidth, pBounds.getWidth());
            maxHeight = Math.max(maxHeight, pBounds.getHeight());
        }
    }
}

