/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.buildamolecule.BuildAMoleculeSimSharing;
import edu.colorado.phet.buildamolecule.model.Atom2D;
import edu.colorado.phet.buildamolecule.model.Bond;
import edu.colorado.phet.buildamolecule.model.Bucket;
import edu.colorado.phet.buildamolecule.model.CollectionBox;
import edu.colorado.phet.buildamolecule.model.CompleteMolecule;
import edu.colorado.phet.buildamolecule.model.LayoutBounds;
import edu.colorado.phet.buildamolecule.model.LewisDotModel;
import edu.colorado.phet.buildamolecule.model.Molecule;
import edu.colorado.phet.buildamolecule.model.MoleculeStructure;
import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.Pair;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kit {
    private final List<Bucket> buckets;
    private final List<Atom2D> atoms = new LinkedList<Atom2D>();
    private final List<Atom2D> atomsInCollectionBox = new LinkedList<Atom2D>();
    private LewisDotModel lewisDotModel;
    private final Set<Molecule> molecules = new HashSet<Molecule>();
    private final Set<Pair<Molecule, CollectionBox>> removedMolecules = new HashSet<Pair<Molecule, CollectionBox>>();
    public final Property<Boolean> visible = new Property<Boolean>(false);
    public final Property<Boolean> hasMoleculesInBoxes = new Property<Boolean>(false);
    private LayoutBounds layoutBounds;
    private final List<MoleculeListener> moleculeListeners = new LinkedList<MoleculeListener>();

    public Kit(LayoutBounds layoutBounds, Bucket ... bucketArray) {
        this.buckets = new LinkedList<Bucket>(Arrays.asList(bucketArray));
        this.layoutBounds = layoutBounds;
        this.resetKit();
        this.layoutBuckets(bucketArray);
    }

    public void resetKit() {
        this.hasMoleculesInBoxes.reset();
        for (Molecule object : new ArrayList<Molecule>(this.molecules)) {
            this.removeMolecule(object);
            SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.molecule, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.moleculeRemovedMisc, ParameterSet.parameterSet((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeId, object.getMoleculeId()));
        }
        this.atoms.addAll(this.atomsInCollectionBox);
        for (Atom2D atom2D : this.atoms) {
            atom2D.reset();
            this.getBucketForElement(atom2D.getElement()).placeAtom(atom2D);
        }
        this.atoms.clear();
        this.atomsInCollectionBox.clear();
        this.lewisDotModel = new LewisDotModel();
        this.molecules.clear();
        this.removedMolecules.clear();
        for (Bucket bucket : this.buckets) {
            this.atoms.addAll(bucket.getAtoms());
            for (Atom2D atom2D : bucket.getAtoms()) {
                this.lewisDotModel.addAtom(atom2D);
            }
        }
    }

    private void layoutBuckets(Bucket[] bucketArray) {
        double d = this.getAvailableKitBounds().getCenterY() - 20.0;
        double d2 = this.getAvailableKitBounds().getCenterX();
        double d3 = 0.0;
        for (int i = 0; i < this.buckets.size(); ++i) {
            Bucket bucket = this.buckets.get(i);
            if (i != 0) {
                d3 += 50.0;
            }
            bucket.setPosition(new Point2D.Double(d3, d));
            d3 += bucket.getWidth();
        }
        for (Bucket bucket : bucketArray) {
            bucket.setPosition(new Point2D.Double(bucket.getPosition().getX() - d3 / 2.0 + d2 + bucket.getWidth() / 2.0, d));
        }
    }

    public void show() {
        this.visible.set(true);
    }

    public void hide() {
        this.visible.set(false);
    }

    public boolean isContainedInBucket(Atom2D atom2D) {
        for (Bucket bucket : this.buckets) {
            if (!bucket.containsParticle(atom2D)) continue;
            return true;
        }
        return false;
    }

    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    public List<Atom2D> getAtoms() {
        return this.atoms;
    }

    public Bucket getBucketForElement(Element element) {
        for (Bucket bucket : this.buckets) {
            if (!bucket.getElement().isSameElement(element)) continue;
            return bucket;
        }
        throw new RuntimeException("Bucket not found for element: " + element);
    }

    public PBounds getAvailableKitBounds() {
        return this.layoutBounds.getAvailableKitBounds();
    }

    public PBounds getAvailablePlayAreaBounds() {
        return this.layoutBounds.getAvailablePlayAreaBounds();
    }

    public void atomDropped(Atom2D atom2D) {
        boolean bl = this.isAtomInPlay(atom2D);
        boolean bl2 = this.getAvailableKitBounds().contains(atom2D.getPosition().toPoint2D());
        SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.atom, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.atomDropped, ParameterSet.parameterSet((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.atomWasInKitArea, !bl).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.atomDroppedInKitArea, bl2).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.atomId, atom2D.getId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.atomElement, atom2D.getSymbol()));
        if (bl2) {
            if (bl) {
                this.recycleMoleculeIntoBuckets(this.getMolecule(atom2D));
            } else {
                this.recycleAtomIntoBuckets(atom2D, true);
            }
        } else if (bl) {
            this.attemptToBondMolecule(this.getMolecule(atom2D));
            this.separateMoleculeDestinations();
        } else {
            this.addAtomToPlay(atom2D);
        }
    }

    public void atomDragged(Atom2D atom2D, Vector2D vector2D) {
        atom2D.translatePositionAndDestination(vector2D);
        if (this.isAtomInPlay(atom2D)) {
            for (Atom2D atom2D2 : this.getMolecule(atom2D).getAtoms()) {
                if (atom2D == atom2D2) continue;
                atom2D2.translatePositionAndDestination(vector2D);
            }
        }
    }

    public void moleculePutInCollectionBox(Molecule molecule, CollectionBox collectionBox) {
        System.out.println("You have collected: " + collectionBox.getMoleculeType().getCommonName());
        this.hasMoleculesInBoxes.set(true);
        this.removeMolecule(molecule);
        for (Atom2D atom2D : molecule.getAtoms()) {
            this.atoms.remove(atom2D);
            this.atomsInCollectionBox.add(atom2D);
            atom2D.visible.set(false);
        }
        collectionBox.addMolecule(molecule);
        this.removedMolecules.add(new Pair<Molecule, CollectionBox>(molecule, collectionBox));
    }

    public boolean isAtomInPlay(Atom atom) {
        return this.getMolecule(atom) != null;
    }

    public Molecule getMolecule(Atom atom) {
        for (Molecule molecule : this.molecules) {
            for (Atom atom2 : molecule.getAtoms()) {
                if (atom2 != atom) continue;
                return molecule;
            }
        }
        return null;
    }

    public void breakMolecule(Molecule molecule) {
        ArrayList<Molecule> arrayList = new ArrayList<Molecule>();
        this.removeMolecule(molecule);
        for (final Atom2D atom2D : molecule.getAtoms()) {
            this.lewisDotModel.breakBondsOfAtom(atom2D);
            Molecule molecule2 = new Molecule(){
                {
                    this.addAtom(atom2D);
                }
            };
            this.addMolecule(molecule2);
            arrayList.add(molecule);
        }
        this.separateMoleculeDestinations();
        SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.molecule, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.moleculeBroken, new ParameterSet().with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeDestroyed, molecule.getMoleculeId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculesCreated, FunctionalUtils.mkString(arrayList, new Function1<Molecule, String>(){

            @Override
            public String apply(Molecule molecule) {
                return Integer.toString(molecule.getMoleculeId());
            }
        }, ",")));
    }

    public void breakBond(Atom2D atom2D, Atom2D atom2D2) {
        Molecule molecule = this.getMolecule(atom2D);
        List<Molecule> list = MoleculeStructure.getMoleculesFromBrokenBond(molecule, molecule.getBond(atom2D, atom2D2), new Molecule(), new Molecule());
        this.lewisDotModel.breakBond(atom2D, atom2D2);
        this.removeMolecule(molecule);
        for (Molecule molecule2 : list) {
            this.addMolecule(molecule2);
        }
        SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.molecule, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.bondBroken, new ParameterSet().with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeDestroyed, molecule.getMoleculeId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculesCreated, FunctionalUtils.mkString(list, new Function1<Molecule, String>(){

            @Override
            public String apply(Molecule molecule) {
                return Integer.toString(molecule.getMoleculeId());
            }
        }, ",")).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondAtomA, atom2D.getId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondAtomB, atom2D2.getId()));
        this.separateMoleculeDestinations();
    }

    public void addMoleculeListener(MoleculeListener moleculeListener) {
        this.moleculeListeners.add(moleculeListener);
    }

    public LewisDotModel.Direction getBondDirection(Atom atom, Atom atom2) {
        return this.lewisDotModel.getBondDirection(atom, atom2);
    }

    public boolean hasAtomsOutsideOfBuckets() {
        return !this.molecules.isEmpty() || this.hasMoleculesInBoxes.get() != false;
    }

    /*
     * WARNING - void declaration
     */
    private void addMolecule(Molecule molecule) {
        this.molecules.add(molecule);
        for (MoleculeListener object : this.moleculeListeners) {
            object.addedMolecule(molecule);
        }
        if (SimSharingManager.getInstance().isEnabled()) {
            void var3_7;
            ArrayList arrayList = new ArrayList(molecule.getAtoms());
            Collections.sort(arrayList, new Comparator<Atom2D>(){

                @Override
                public int compare(Atom2D atom2D, Atom2D atom2D2) {
                    return Double.compare(atom2D.hashCode(), atom2D2.hashCode());
                }
            });
            ParameterSet parameterSet = new ParameterSet().with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeId, molecule.getMoleculeId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.atomIds, FunctionalUtils.mkString(arrayList, new Function1<Atom2D, String>(){

                @Override
                public String apply(Atom2D atom2D) {
                    return atom2D.getId();
                }
            }, ",")).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bonds, FunctionalUtils.mkString(molecule.getBonds(), new Function1<Bond<Atom2D>, String>(){

                @Override
                public String apply(Bond<Atom2D> bond) {
                    return ((Atom2D)bond.a).getId() + "-" + ((Atom2D)bond.b).getId();
                }
            }, ",")).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeSerial2, molecule.toSerial2()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeGeneralFormula, molecule.getGeneralFormula());
            CompleteMolecule completeMolecule = molecule.getMatchingCompleteMolecule();
            ParameterSet parameterSet2 = parameterSet.with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeIsCompleteMolecule, completeMolecule != null);
            if (completeMolecule != null) {
                ParameterSet parameterSet3 = parameterSet2.with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.completeMoleculeMolecularFormula, completeMolecule.getMolecularFormula()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.completeMoleculeCommonName, completeMolecule.getCommonName()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.completeMoleculeSerial2, completeMolecule.toSerial2()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.completeMoleculeCID, completeMolecule.getCID());
            }
            SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.molecule, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.moleculeAdded, (ParameterSet)var3_7);
        }
    }

    private void removeMolecule(Molecule molecule) {
        this.molecules.remove(molecule);
        for (MoleculeListener moleculeListener : this.moleculeListeners) {
            moleculeListener.removedMolecule(molecule);
        }
        SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.molecule, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.moleculeRemoved, ParameterSet.parameterSet((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeId, molecule.getMoleculeId()));
    }

    private void addAtomToPlay(final Atom2D atom2D) {
        Molecule molecule = new Molecule(){
            {
                this.addAtom(atom2D);
            }
        };
        this.addMolecule(molecule);
        SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.atom, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.atomAddedIntoPlay, new ParameterSet().with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.atomId, atom2D.getId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.atomElement, atom2D.getSymbol()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeId, molecule.getMoleculeId()));
        this.attemptToBondMolecule(molecule);
    }

    private void recycleAtomIntoBuckets(Atom2D atom2D, boolean bl) {
        this.lewisDotModel.breakBondsOfAtom(atom2D);
        Bucket bucket = this.getBucketForElement(atom2D.getElement());
        bucket.addParticleNearestOpen(atom2D, !bl);
    }

    private void recycleMoleculeIntoBuckets(Molecule molecule) {
        for (Atom2D atom2D : molecule.getAtoms()) {
            this.recycleAtomIntoBuckets(atom2D, true);
        }
        this.removeMolecule(molecule);
        SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.molecule, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.moleculeRecycled, ParameterSet.parameterSet((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeId, molecule.getMoleculeId()));
    }

    private PBounds padMoleculeBounds(PBounds pBounds) {
        double d = 75.0;
        return new PBounds(pBounds.x - d, pBounds.y - d, pBounds.width + 150.0, pBounds.height + 150.0);
    }

    private Set<Molecule> separateMoleculeDestinations() {
        int n = 500;
        double d = 10.0;
        HashSet<Molecule> hashSet = new HashSet<Molecule>();
        boolean bl = true;
        while (bl && n-- >= 0) {
            bl = false;
            for (Molecule molecule : this.molecules) {
                PBounds pBounds = this.padMoleculeBounds(molecule.getDestinationBounds());
                if (pBounds.getMinX() < this.getAvailablePlayAreaBounds().getMinX()) {
                    molecule.shiftDestination(new Vector2D(this.getAvailablePlayAreaBounds().getMinX() - pBounds.getMinX(), 0.0));
                    pBounds = this.padMoleculeBounds(molecule.getDestinationBounds());
                }
                if (pBounds.getMaxX() > this.getAvailablePlayAreaBounds().getMaxX()) {
                    molecule.shiftDestination(new Vector2D(this.getAvailablePlayAreaBounds().getMaxX() - pBounds.getMaxX(), 0.0));
                    pBounds = this.padMoleculeBounds(molecule.getDestinationBounds());
                }
                if (pBounds.getMinY() < this.getAvailablePlayAreaBounds().getMinY()) {
                    molecule.shiftDestination(new Vector2D(0.0, this.getAvailablePlayAreaBounds().getMinY() - pBounds.getMinY()));
                    pBounds = this.padMoleculeBounds(molecule.getDestinationBounds());
                }
                if (pBounds.getMaxY() > this.getAvailablePlayAreaBounds().getMaxY()) {
                    molecule.shiftDestination(new Vector2D(0.0, this.getAvailablePlayAreaBounds().getMaxY() - pBounds.getMaxY()));
                }
                for (Molecule molecule2 : this.molecules) {
                    PBounds pBounds2;
                    if (molecule.getMoleculeId() >= molecule2.getMoleculeId() || !pBounds.intersects(pBounds2 = this.padMoleculeBounds(molecule2.getDestinationBounds()))) continue;
                    bl = true;
                    hashSet.add(molecule);
                    hashSet.add(molecule2);
                    Vector2D vector2D = new Vector2D(pBounds.getCenter2D()).plus(Math.random() - 0.5, Math.random() - 0.5);
                    Vector2D vector2D2 = new Vector2D(pBounds2.getCenter2D()).plus(Math.random() - 0.5, Math.random() - 0.5);
                    Vector2D vector2D3 = vector2D2.minus(vector2D).normalized().times(d);
                    double d2 = 1.0;
                    double d3 = Math.pow(molecule.getApproximateMolecularWeight(), d2) / (Math.pow(molecule.getApproximateMolecularWeight(), d2) + Math.pow(molecule2.getApproximateMolecularWeight(), d2));
                    molecule2.shiftDestination(vector2D3.times(d3));
                    Vector2D vector2D4 = vector2D3.times(-1.0 * (1.0 - d3));
                    molecule.shiftDestination(vector2D4);
                    pBounds = this.padMoleculeBounds(molecule.getDestinationBounds());
                }
            }
        }
        return hashSet;
    }

    private void bond(Atom2D atom2D, LewisDotModel.Direction direction, Atom2D atom2D2) {
        this.lewisDotModel.bond(atom2D, direction, atom2D2);
        Molecule molecule = this.getMolecule(atom2D);
        Molecule molecule2 = this.getMolecule(atom2D2);
        if (molecule == molecule2) {
            throw new RuntimeException("WARNING: loop or other invalid structure detected in a molecule");
        }
        Molecule molecule3 = MoleculeStructure.getCombinedMoleculeFromBond(molecule, molecule2, atom2D, atom2D2, new Molecule());
        if (!molecule3.isValid()) {
            System.out.println("invalid molecule!");
            System.out.println("bonding: " + atom2D.getSymbol() + "(" + atom2D.hashCode() + "), " + (Object)((Object)direction) + " " + atom2D2.getSymbol() + " (" + atom2D2.hashCode() + ")");
            System.out.println("A");
            System.out.println(molecule.getDebuggingDump());
            System.out.println("B");
            System.out.println(molecule2.getDebuggingDump());
            System.out.println("combined");
            System.out.println(molecule3.getDebuggingDump());
            System.out.println("found: " + molecule3.isAllowedStructure());
            return;
        }
        this.removeMolecule(molecule);
        this.removeMolecule(molecule2);
        this.addMolecule(molecule3);
        String string = this.getMolecule(atom2D).toSerial2();
        System.out.println("created structure: " + string);
        SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.molecule, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.bonding, new ParameterSet().with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondMoleculeDestroyedA, molecule.getMoleculeId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondMoleculeDestroyedB, molecule2.getMoleculeId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondMoleculeCreated, molecule3.getMoleculeId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeStructureDestroyedA, molecule.toSerial2()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeStructureDestroyedB, molecule2.toSerial2()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeStructureCreated, molecule3.toSerial2()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondAtomA, atom2D.getId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondAtomB, atom2D2.getId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondDirection, direction.toString()));
        Molecule molecule4 = this.getMolecule(atom2D);
        if (molecule4.getAtoms().size() > 2) {
            for (Bond bond : molecule4.getBonds()) {
                if (!((Atom2D)bond.a).hasSameElement((Atom)bond.b) || !((Atom2D)bond.a).getSymbol().equals("H")) continue;
                System.out.println("WARNING: Hydrogen bonded to another hydrogen in a molecule which is not diatomic hydrogen");
            }
        }
        assert (this.getMolecule(atom2D) == this.getMolecule(atom2D2));
    }

    private Molecule getPossibleMoleculeStructureFromBond(Atom2D atom2D, Atom2D atom2D2) {
        Molecule molecule = this.getMolecule(atom2D);
        Molecule molecule2 = this.getMolecule(atom2D2);
        assert (molecule != molecule2);
        return MoleculeStructure.getCombinedMoleculeFromBond(molecule, molecule2, atom2D, atom2D2, new Molecule());
    }

    private boolean attemptToBondMolecule(Molecule molecule) {
        Object object;
        Object object222;
        BondingOption bondingOption = null;
        double d = Double.POSITIVE_INFINITY;
        for (Object object222 : molecule.getAtoms()) {
            for (Atom2D object3 : this.atoms) {
                if (this.getMolecule(object3) == molecule || this.isContainedInBucket(object3) || object3 == object222 || !this.canBond((Atom2D)object222, object3)) continue;
                for (LewisDotModel.Direction direction : this.lewisDotModel.getOpenDirections(object3)) {
                    LewisDotModel.Direction direction2 = LewisDotModel.Direction.opposite(direction);
                    if (!this.lewisDotModel.getOpenDirections((Atom)object222).contains((Object)direction2) || !this.lewisDotModel.willAllowBond((Atom)object222, direction2, object3)) continue;
                    BondingOption bondingOption2 = new BondingOption(object3, direction, (Atom2D)object222);
                    double d2 = ((Atom2D)object222).getPosition().distance(bondingOption2.getIdealLocation());
                    if (!(d2 < d)) continue;
                    bondingOption = bondingOption2;
                    d = d2;
                }
            }
        }
        boolean bl = bondingOption == null || d > 200.0;
        object222 = ParameterSet.parameterSet((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondOccurs, !bl).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeId, molecule.getMoleculeId());
        SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.molecule, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.bondAttempt, (ParameterSet)(bl ? object222 : ((ParameterSet)object222).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondAtomA, bondingOption.a.getId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondAtomB, bondingOption.b.getId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondDirection, bondingOption.direction.toString()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondMoleculeIdA, this.getMolecule(bondingOption.a).getMoleculeId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondMoleculeIdB, this.getMolecule(bondingOption.b).getMoleculeId())));
        if (bl) {
            object = this.separateMoleculeDestinations();
            SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.molecule, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.moleculeStatusAfterDrop, new ParameterSet().with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondOccurs, false).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeRepulsed, object.contains(molecule)).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeId, molecule.getMoleculeId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculesRepulsed, FunctionalUtils.mkString(object, new Function1<Molecule, String>(){

                @Override
                public String apply(Molecule molecule) {
                    return Integer.toString(molecule.getMoleculeId());
                }
            }, ",")));
            return false;
        }
        SimSharingManager.sendModelMessage(BuildAMoleculeSimSharing.ModelComponent.molecule, ModelComponentTypes.modelElement, BuildAMoleculeSimSharing.ModelAction.moleculeStatusAfterDrop, new ParameterSet().with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.bondOccurs, true).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeRepulsed, false).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.moleculeId, molecule.getMoleculeId()));
        object = bondingOption.getIdealLocation().minus(bondingOption.b.getPosition());
        for (Object object2 : this.getMolecule(bondingOption.b).getAtoms()) {
            ((Atom2D)object2).setDestination(((Atom2D)object2).getPosition().plus((AbstractVector2D)object));
        }
        this.bond(bondingOption.a, bondingOption.direction, bondingOption.b);
        return true;
    }

    private boolean canBond(Atom2D atom2D, Atom2D atom2D2) {
        return this.getMolecule(atom2D) != this.getMolecule(atom2D2) && this.getPossibleMoleculeStructureFromBond(atom2D, atom2D2).isAllowedStructure();
    }

    private static class BondingOption {
        public final Atom2D a;
        public final LewisDotModel.Direction direction;
        public final Atom2D b;

        private BondingOption(Atom2D atom2D, LewisDotModel.Direction direction, Atom2D atom2D2) {
            this.a = atom2D;
            this.direction = direction;
            this.b = atom2D2;
        }

        public Vector2D getIdealLocation() {
            return this.a.getPosition().plus(this.direction.getVector().times(this.a.getRadius() + this.b.getRadius()));
        }
    }

    public static class MoleculeAdapter
    implements MoleculeListener {
        public void addedMolecule(Molecule molecule) {
        }

        public void removedMolecule(Molecule molecule) {
        }
    }

    public static interface MoleculeListener {
        public void addedMolecule(Molecule var1);

        public void removedMolecule(Molecule var1);
    }
}

