/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.buildamolecule.model.Bond;
import edu.colorado.phet.buildamolecule.model.CompleteMolecule;
import edu.colorado.phet.buildamolecule.model.ElementHistogram;
import edu.colorado.phet.buildamolecule.model.MoleculeList;
import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.chemistry.utils.ChemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoleculeStructure<AtomT extends Atom> {
    private final ArrayList<AtomT> atoms;
    private final ArrayList<Bond<AtomT>> bonds;
    private static int nextMoleculeId = 0;
    private final int moleculeId = nextMoleculeId++;
    private static final Map<String, String> formulaExceptions = new HashMap<String, String>();

    public MoleculeStructure() {
        this(12, 12);
    }

    public MoleculeStructure(int n, int n2) {
        this.atoms = new ArrayList(n);
        this.bonds = new ArrayList(n2);
    }

    public Atom addAtom(AtomT AtomT) {
        assert (!this.atoms.contains(AtomT));
        this.atoms.add(AtomT);
        return AtomT;
    }

    public void addBond(Bond<AtomT> bond) {
        assert (this.atoms.contains(bond.a));
        assert (this.atoms.contains(bond.b));
        this.bonds.add(bond);
    }

    public void addBond(AtomT AtomT, AtomT AtomT2) {
        this.addBond(new Bond<AtomT>(AtomT, AtomT2));
    }

    public Set<Bond<AtomT>> getBondsInvolving(AtomT AtomT) {
        HashSet<Bond<AtomT>> hashSet = new HashSet<Bond<AtomT>>();
        for (Bond<AtomT> bond : this.bonds) {
            if (!bond.contains(AtomT)) continue;
            hashSet.add(bond);
        }
        return hashSet;
    }

    public CompleteMolecule getMatchingCompleteMolecule() {
        return MoleculeList.getMasterInstance().findMatchingCompleteMolecule(this);
    }

    public boolean isAllowedStructure() {
        return this.getAtoms().size() < 2 || MoleculeList.getMasterInstance().isAllowedStructure(this);
    }

    public String getHillSystemFormulaFragment() {
        return ChemUtils.hillOrderedSymbol(this.getElementList());
    }

    public String getGeneralFormula() {
        boolean bl = this.containsElement(Element.C);
        boolean bl2 = this.containsElement(Element.H);
        boolean bl3 = bl && bl2;
        List<Element> list = this.getElementList();
        if (bl3) {
            Collections.sort(list, new Comparator<Element>(){

                @Override
                public int compare(Element element, Element element2) {
                    return new Double(MoleculeStructure.organicSortValue(element)).compareTo(MoleculeStructure.organicSortValue(element2));
                }
            });
        } else {
            Collections.sort(list, new Comparator<Element>(){

                @Override
                public int compare(Element element, Element element2) {
                    return new Double(MoleculeStructure.electronegativeSortValue(element)).compareTo(MoleculeStructure.electronegativeSortValue(element2));
                }
            });
        }
        String string = ChemUtils.createSymbolWithoutSubscripts(list.toArray(new Element[list.size()]));
        return formulaExceptions.containsKey(string) ? formulaExceptions.get(string) : string;
    }

    public String getGeneralFormulaFragment() {
        return ChemUtils.toSubscript(this.getGeneralFormula());
    }

    private static double electronegativeSortValue(Element element) {
        return element.getElectronegativity();
    }

    private static double organicSortValue(Element element) {
        if (element.isCarbon()) {
            return 0.0;
        }
        if (element.isHydrogen()) {
            return 1.0;
        }
        return MoleculeStructure.alphabeticSortValue(element);
    }

    private static double alphabeticSortValue(Element element) {
        int n = 1000 * element.getSymbol().charAt(0);
        if (element.getSymbol().length() > 1) {
            n += element.getSymbol().charAt(1);
        }
        return n;
    }

    public List<AtomT> getAtoms() {
        return this.atoms;
    }

    public List<Bond<AtomT>> getBonds() {
        return this.bonds;
    }

    public List<AtomT> getNeighbors(AtomT AtomT) {
        ArrayList<AtomT> arrayList = new ArrayList<AtomT>();
        for (Bond<AtomT> bond : this.getBondsInvolving(AtomT)) {
            arrayList.add(bond.getOtherAtom(AtomT));
        }
        return arrayList;
    }

    public double getApproximateMolecularWeight() {
        double d = 0.0;
        for (Atom atom : this.atoms) {
            d += atom.getAtomicWeight();
        }
        return d;
    }

    public boolean isValid() {
        return !this.hasWeirdHydrogenProperties() && !this.hasLoopsOrIsDisconnected();
    }

    public boolean hasWeirdHydrogenProperties() {
        for (Atom atom : this.atoms) {
            if (!atom.isHydrogen() || this.getNeighbors(atom).size() <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean hasLoopsOrIsDisconnected() {
        HashSet<Atom> hashSet = new HashSet<Atom>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        hashSet2.add(this.atoms.iterator().next());
        while (!hashSet2.isEmpty()) {
            Atom atom = (Atom)hashSet2.iterator().next();
            int n = 0;
            for (Atom atom2 : this.getNeighbors(atom)) {
                if (hashSet.contains(atom2)) {
                    ++n;
                    continue;
                }
                hashSet2.add(atom2);
            }
            if (n > 1) {
                return true;
            }
            hashSet2.remove(atom);
            hashSet.add(atom);
        }
        return hashSet.size() != this.atoms.size();
    }

    public static <U extends Atom, M extends MoleculeStructure<U>> M getCombinedMoleculeFromBond(MoleculeStructure<U> moleculeStructure, MoleculeStructure<U> moleculeStructure2, U u, U u2, M m) {
        for (Atom object : moleculeStructure.getAtoms()) {
            m.addAtom((Atom)object);
        }
        for (Atom atom : moleculeStructure2.getAtoms()) {
            m.addAtom((Atom)atom);
        }
        for (Bond bond : moleculeStructure.getBonds()) {
            m.addBond(bond);
        }
        for (Bond bond : moleculeStructure2.getBonds()) {
            m.addBond(bond);
        }
        m.addBond(u, u2);
        return m;
    }

    public static <U extends Atom, M extends MoleculeStructure<U>> List<M> getMoleculesFromBrokenBond(MoleculeStructure<U> moleculeStructure, final Bond<U> bond, final M m, final M m2) {
        HashSet hashSet = new HashSet<U>(){
            {
                this.add(bond.a);
            }
        };
        HashSet<U> hashSet2 = new HashSet<U>(moleculeStructure.getAtoms());
        hashSet2.remove(bond.a);
        HashSet hashSet3 = new HashSet<U>(){
            {
                this.add(bond.a);
            }
        };
        while (!hashSet3.isEmpty()) {
            Iterator<Bond<U>> iterator = (Atom)hashSet3.iterator().next();
            hashSet3.remove(iterator);
            for (Bond bond2 : moleculeStructure.bonds) {
                Iterator<Bond<U>> iterator2;
                if (bond2 == bond || !bond2.contains(iterator) || !hashSet2.contains(iterator2 = bond2.getOtherAtom(iterator))) continue;
                hashSet2.remove(iterator2);
                hashSet3.add(iterator2);
                hashSet.add(iterator2);
            }
        }
        for (Bond<U> bond3 : moleculeStructure.getAtoms()) {
            if (hashSet.contains(bond3)) {
                m.addAtom((Object)bond3);
                continue;
            }
            m2.addAtom((Object)bond3);
        }
        for (Bond<U> bond3 : moleculeStructure.getBonds()) {
            if (bond3 == bond) continue;
            if (hashSet.contains(bond3.a)) {
                assert (hashSet.contains(bond3.b));
                m.addBond(bond3);
                continue;
            }
            m2.addBond(bond3);
        }
        System.out.println("splitting " + moleculeStructure.toSerial() + " into:");
        System.out.println(m.toSerial());
        System.out.println(m2.toSerial());
        return new ArrayList<M>(2){
            {
                super(n);
                this.add(m);
                this.add(m2);
            }
        };
    }

    public String getDebuggingDump() {
        String string = "Molecule\n";
        for (Atom object : this.atoms) {
            string = string + "atom: " + object.getSymbol() + " " + object.hashCode() + "\n";
        }
        for (Bond bond : this.bonds) {
            string = string + "bond: " + bond.a.hashCode() + " - " + bond.b.hashCode() + "\n";
        }
        return string;
    }

    private boolean containsElement(Element element) {
        for (Atom atom : this.atoms) {
            if (!atom.getElement().equals(element)) continue;
            return true;
        }
        return false;
    }

    public Bond<AtomT> getBond(AtomT AtomT, AtomT AtomT2) {
        for (Bond<AtomT> bond : this.bonds) {
            if (!bond.contains(AtomT) || !bond.contains(AtomT2)) continue;
            return bond;
        }
        throw new RuntimeException("Could not find bond!");
    }

    public ElementHistogram getHistogram() {
        return new ElementHistogram(this);
    }

    public int getMoleculeId() {
        return this.moleculeId;
    }

    public MoleculeStructure<Atom> getAtomCopy() {
        MoleculeStructure<Atom> moleculeStructure = new MoleculeStructure<Atom>(this.atoms.size(), this.bonds.size());
        for (Atom object : this.atoms) {
            moleculeStructure.addAtom(object);
        }
        for (Bond bond : this.bonds) {
            moleculeStructure.addBond(new Bond(bond.a, bond.b));
        }
        return moleculeStructure;
    }

    public <U extends Atom> boolean isEquivalent(MoleculeStructure<U> moleculeStructure) {
        if (this == moleculeStructure) {
            return true;
        }
        if (this.getAtoms().size() != moleculeStructure.getAtoms().size()) {
            return false;
        }
        if (!this.getHistogram().equals(moleculeStructure.getHistogram())) {
            return false;
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Atom atom = (Atom)this.atoms.iterator().next();
        for (Atom atom2 : moleculeStructure.getAtoms()) {
            if (!this.checkEquivalency(moleculeStructure, hashSet, hashSet2, atom, atom2)) continue;
            return true;
        }
        return false;
    }

    public List<AtomT> getNeighborsNotInSet(AtomT AtomT, Set<AtomT> set) {
        LinkedList<Atom> linkedList = new LinkedList<Atom>();
        for (Atom atom : this.getNeighbors(AtomT)) {
            if (set.contains(atom)) continue;
            linkedList.add(atom);
        }
        return linkedList;
    }

    private <U extends Atom> boolean checkEquivalency(MoleculeStructure<U> moleculeStructure, Set<AtomT> set, Set<U> set2, AtomT AtomT, U u) {
        if (!((Atom)AtomT).hasSameElement(u)) {
            return false;
        }
        List<AtomT> list = this.getNeighborsNotInSet(AtomT, set);
        List<U> list2 = moleculeStructure.getNeighborsNotInSet(u, set2);
        if (list.size() != list2.size()) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        int n = list.size();
        set.add(AtomT);
        set2.add(u);
        boolean[][] blArray = new boolean[n][n];
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int i = 0; i < n; ++i) {
            linkedList.add(i);
            for (int j = 0; j < n; ++j) {
                blArray[i][j] = this.checkEquivalency(moleculeStructure, set, set2, (Atom)list.get(i), (Atom)list2.get(j));
            }
        }
        set.remove(AtomT);
        set2.remove(u);
        return MoleculeStructure.checkEquivalencyMatrix(blArray, 0, linkedList);
    }

    public static boolean checkEquivalencyMatrix(boolean[][] blArray, int n, List<Integer> list) {
        for (Integer n2 : new ArrayList<Integer>(list)) {
            if (!blArray[n][n2]) continue;
            list.remove(n2);
            boolean bl = n == blArray.length - 1 || MoleculeStructure.checkEquivalencyMatrix(blArray, n + 1, list);
            list.add(n2);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private List<Element> getElementList() {
        return new LinkedList<Element>(){
            {
                for (Atom atom : MoleculeStructure.this.atoms) {
                    this.add(atom.getElement());
                }
            }
        };
    }

    public String toSerial() {
        String string = this.atoms.size() + "|" + this.bonds.size();
        LinkedList<AtomT> linkedList = new LinkedList<AtomT>(this.getAtoms());
        for (Atom object : linkedList) {
            string = string + "|" + object.getSymbol();
        }
        for (Bond bond : this.bonds) {
            int n = linkedList.indexOf(bond.a);
            int n2 = linkedList.indexOf(bond.b);
            string = string + "|" + n + "|" + n2;
        }
        return string;
    }

    public String toSerial2() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getAtoms().size() + "|" + this.getBonds().size());
        for (int i = 0; i < this.getAtoms().size(); ++i) {
            Atom atom = (Atom)this.getAtoms().get(i);
            stringBuilder.append("|" + atom.toString());
            for (Bond<AtomT> bond : this.bonds) {
                if (!bond.contains(atom)) continue;
                Atom atom2 = bond.getOtherAtom(atom);
                int n = this.getAtoms().indexOf(atom2);
                if (n >= i) continue;
                stringBuilder.append("," + bond.toSerial2(n));
            }
        }
        return stringBuilder.toString();
    }

    public static <U extends Atom, B extends Bond<U>, M extends MoleculeStructure<U>> M fromSerial2(String string, MoleculeGenerator<U, M> moleculeGenerator, AtomParser<U> atomParser, BondParser<U, B> bondParser) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        MoleculeStructure moleculeStructure = (MoleculeStructure)moleculeGenerator.createMolecule(n, n2);
        for (int i = 0; i < n; ++i) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            U u = atomParser.parseAtom(stringTokenizer2.nextToken());
            moleculeStructure.addAtom(u);
            while (stringTokenizer2.hasMoreTokens()) {
                Bond bond = (Bond)bondParser.parseBond(stringTokenizer2.nextToken(), u, moleculeStructure);
                moleculeStructure.addBond(bond);
            }
        }
        return (M)moleculeStructure;
    }

    public static MoleculeStructure<Atom> fromSerial2Basic(String string) {
        return MoleculeStructure.fromSerial2(string, new DefaultMoleculeGenerator(), new DefaultAtomParser(), new DefaultBondParser());
    }

    static {
        formulaExceptions.put("H3N", "NH3");
        formulaExceptions.put("CHN", "HCN");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AtomParser<U extends Atom> {
        public U parseAtom(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BondParser<U extends Atom, B> {
        public B parseBond(String var1, U var2, MoleculeStructure<U> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultAtomParser
    implements AtomParser<Atom> {
        @Override
        public Atom parseAtom(String string) {
            return new Atom(Element.getElementBySymbol(string));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultBondParser
    implements BondParser<Atom, Bond<Atom>> {
        @Override
        public Bond<Atom> parseBond(String string, Atom atom, MoleculeStructure<Atom> moleculeStructure) {
            return new Bond<Atom>(atom, moleculeStructure.getAtoms().get(Integer.parseInt(string)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultMoleculeGenerator
    implements MoleculeGenerator<Atom, MoleculeStructure<Atom>> {
        @Override
        public MoleculeStructure<Atom> createMolecule(int n, int n2) {
            return new MoleculeStructure<Atom>(n, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MoleculeGenerator<U extends Atom, M> {
        public M createMolecule(int var1, int var2);
    }
}

