/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.view;

import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.BuildAMoleculeSimSharing;
import edu.colorado.phet.buildamolecule.model.Atom2D;
import edu.colorado.phet.buildamolecule.model.Bond;
import edu.colorado.phet.buildamolecule.model.Kit;
import edu.colorado.phet.buildamolecule.model.LewisDotModel;
import edu.colorado.phet.buildamolecule.view.BuildAMoleculeCanvas;
import edu.colorado.phet.buildamolecule.view.ScissorsNode;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoleculeBondNode
extends PNode {
    private ScissorsNode scissorsNode;
    private BuildAMoleculeCanvas canvas;
    private RichSimpleObserver positionObserver;
    private Atom2D a;
    private Atom2D b;

    public MoleculeBondNode(Bond<Atom2D> bond, final Kit kit, BuildAMoleculeCanvas buildAMoleculeCanvas) {
        this.canvas = buildAMoleculeCanvas;
        this.a = (Atom2D)bond.a;
        this.b = (Atom2D)bond.b;
        LewisDotModel.Direction direction = kit.getBondDirection(this.a, this.b);
        final boolean bl = direction == LewisDotModel.Direction.West || direction == LewisDotModel.Direction.East;
        this.scissorsNode = new ScissorsNode(){
            {
                if (bl) {
                    this.rotateInPlace(-1.5707963267948966);
                }
                this.setVisible(false);
                this.setPickable(false);
            }
        };
        buildAMoleculeCanvas.addScreenChild(this.scissorsNode);
        this.addChild(new PhetPPath(new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0)){
            private boolean isDragging;
            private boolean isOver;
            {
                super(shape);
                this.isDragging = false;
                this.isOver = false;
                this.setPaint(Color.RED);
                this.setStrokePaint(Color.BLUE);
                this.setTransparency(0.0f);
                this.addInputEventListener(new CursorHandler(MoleculeBondNode.createEmptyCursor()){

                    public void mouseClicked(PInputEvent pInputEvent) {
                        SimSharingManager.sendButtonPressed(BuildAMoleculeSimSharing.UserComponent.scissorsButton);
                        kit.breakBond(MoleculeBondNode.this.a, MoleculeBondNode.this.b);
                        this.mouseExited(pInputEvent);
                    }

                    public void mouseEntered(PInputEvent pInputEvent) {
                        super.mouseEntered(pInputEvent);
                        if ((pInputEvent.getModifiersEx() & 0x400) == 1024) {
                            return;
                        }
                        isOver = true;
                        MoleculeBondNode.this.scissorsNode.setVisible(true);
                    }

                    public void mouseExited(PInputEvent pInputEvent) {
                        super.mouseExited(pInputEvent);
                        isOver = false;
                        if (!isDragging) {
                            MoleculeBondNode.this.scissorsNode.setVisible(false);
                        }
                    }

                    public void mousePressed(PInputEvent pInputEvent) {
                        super.mousePressed(pInputEvent);
                        isDragging = true;
                        MoleculeBondNode.this.scissorsNode.setClosed(true);
                    }

                    public void mouseReleased(PInputEvent pInputEvent) {
                        super.mouseReleased(pInputEvent);
                        isDragging = false;
                        if (!isOver) {
                            MoleculeBondNode.this.scissorsNode.setVisible(false);
                        }
                        MoleculeBondNode.this.scissorsNode.setClosed(false);
                    }

                    private void updateScissorsPosition(PInputEvent pInputEvent) {
                        MoleculeBondNode.this.scissorsNode.centerFullBoundsOnPoint(pInputEvent.getCanvasPosition().getX(), pInputEvent.getCanvasPosition().getY());
                    }

                    public void mouseDragged(PInputEvent pInputEvent) {
                        super.mouseDragged(pInputEvent);
                        if (MoleculeBondNode.this.scissorsNode.getVisible()) {
                            this.updateScissorsPosition(pInputEvent);
                        }
                    }

                    public void mouseMoved(PInputEvent pInputEvent) {
                        super.mouseMoved(pInputEvent);
                        if (MoleculeBondNode.this.scissorsNode.getVisible()) {
                            this.updateScissorsPosition(pInputEvent);
                        }
                    }
                });
            }
        });
        this.positionObserver = new RichSimpleObserver(){

            public void update() {
                Vector2D vector2D = MoleculeBondNode.this.b.getPosition().minus(MoleculeBondNode.this.a.getPosition()).normalized().times(MoleculeBondNode.this.a.getRadius()).plus(MoleculeBondNode.this.a.getPosition());
                MoleculeBondNode.this.setOffset(BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM.modelToView(vector2D.toPoint2D()));
            }
        };
        this.positionObserver.observe(this.a.position, this.b.position);
    }

    private static Cursor createEmptyCursor() {
        return Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(16, 16, 2), new Point(0, 0), "invisibleCursor");
    }

    public void destruct() {
        this.canvas.removeScreenChild(this.scissorsNode);
        this.positionObserver.unobserve(this.a.position, this.b.position);
    }
}

