/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chemistry.model;

import edu.colorado.phet.chemistry.model.Element;
import java.awt.Color;

public class Atom {
    public final Element element;

    public Atom(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public String getSymbol() {
        return this.element.getSymbol();
    }

    public double getRadius() {
        return this.element.getRadius();
    }

    public double getAtomicWeight() {
        return this.element.getAtomicWeight();
    }

    public Color getColor() {
        return this.element.getColor();
    }

    public double getDiameter() {
        return this.getRadius() * 2.0;
    }

    public boolean hasSameElement(Atom atom) {
        return this.getElement().isSameElement(atom.getElement());
    }

    public boolean isHydrogen() {
        return this.getElement().isSameElement(Element.H);
    }

    public String toString() {
        return this.getSymbol();
    }
}

