/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chemistry.model;

import java.awt.Color;

public class Element {
    private final String symbol;
    private final double radius;
    private final double electronegativity;
    private final double atomicWeight;
    private final Color color;
    public static final Element B = new Element("B", 85.0, 2.04, 10.811, new Color(255, 170, 119));
    public static final Element Be = new Element("Be", 105.0, 1.57, 9.012182, new Color(12779264));
    public static final Element Br = new Element("Br", 114.0, 2.96, 79.904, new Color(190, 30, 20));
    public static final Element C = new Element("C", 77.0, 2.55, 12.0107, new Color(178, 178, 178));
    public static final Element Cl = new Element("Cl", 100.0, 3.16, 35.4527, new Color(153, 242, 57));
    public static final Element F = new Element("F", 72.0, 3.98, 18.9984032, new Color(247, 255, 74));
    public static final Element H = new Element("H", 37.0, 2.2, 1.00794, Color.WHITE);
    public static final Element I = new Element("I", 133.0, 2.66, 126.90447, new Color(0x940094));
    public static final Element N = new Element("N", 75.0, 3.04, 14.00674, Color.BLUE);
    public static final Element O = new Element("O", 73.0, 3.44, 15.9994, new Color(255, 85, 0));
    public static final Element P = new Element("P", 110.0, 2.19, 30.973762, new Color(255, 128, 0));
    public static final Element S = new Element("S", 103.0, 2.58, 32.066, new Color(212, 181, 59));
    public static final Element Si = new Element("Si", 118.0, 1.9, 28.0855, new Color(240, 200, 160));
    public static final Element Sn = new Element("Sn", 145.0, 1.96, 118.71, new Color(0x668080));
    public static final Element Xe = new Element("Xe", 108.0, 2.6, 131.293, new Color(4366000));
    private static final Element[] ELEMENTS = new Element[]{B, Be, Br, C, Cl, F, H, I, N, O, P, S, Si, Xe};

    private Element(String string, double d, double d2, double d3, Color color) {
        this.symbol = string;
        this.radius = d;
        this.electronegativity = d2;
        this.atomicWeight = d3;
        this.color = color;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getElectronegativity() {
        return this.electronegativity;
    }

    public double getAtomicWeight() {
        return this.atomicWeight;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isSameElement(Element element) {
        return element.getSymbol().equals(this.getSymbol());
    }

    public boolean isHydrogen() {
        return this.isSameElement(H);
    }

    public boolean isCarbon() {
        return this.isSameElement(C);
    }

    public String toString() {
        return this.getSymbol();
    }

    public static Element getElementBySymbol(String string) {
        for (Element element : ELEMENTS) {
            if (!element.getSymbol().equals(string)) continue;
            return element;
        }
        throw new RuntimeException("Element not found with symbol: " + string);
    }
}

