/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.simsharing.Log;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingConfig;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingFileLogger;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingMessage;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingPropertiesFile;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingIdDialog;
import edu.colorado.phet.common.phetcommon.simsharing.logs.ConsoleLog;
import edu.colorado.phet.common.phetcommon.simsharing.logs.MongoLog;
import edu.colorado.phet.common.phetcommon.simsharing.logs.StringLog;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IMessageType;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IModelAction;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IModelComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IModelComponentType;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ISystemAction;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ISystemComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ISystemComponentType;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserAction;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponentType;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelMessage;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemComponents;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemMessage;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserMessage;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimSharingManager {
    private final ISystemComponent SYSTEM_COMPONENT = SystemComponents.simsharingManager;
    private final ISystemComponentType SYSTEM_COMPONENT_TYPE = SystemComponentTypes.simsharingManager;
    private static SimSharingManager INSTANCE = null;
    public static final ArrayList<VoidFunction1<SimSharingManager>> initListeners = new ArrayList();
    private final boolean enabled;
    private final long simStartedTime;
    private final String sessionId;
    private String studyName;
    private SimSharingConfig simSharingConfig;
    private String studentId;
    private String machineCookie;
    private int messageCount;
    private final ArrayList<Log> logs = new ArrayList();
    public final StringLog stringLog = new StringLog();

    public static final SimSharingManager getInstance() {
        if (INSTANCE == null) {
            SimSharingManager.init(new PhetApplicationConfig(new String[0], "sim-sharing-manager"));
        }
        assert (INSTANCE != null);
        return INSTANCE;
    }

    public static void init(PhetApplicationConfig phetApplicationConfig) {
        SimSharingManager.init(phetApplicationConfig, "sessions");
    }

    public static void init(PhetApplicationConfig phetApplicationConfig, String string) {
        INSTANCE = new SimSharingManager(phetApplicationConfig, string);
        for (VoidFunction1<SimSharingManager> voidFunction1 : initListeners) {
            voidFunction1.apply(INSTANCE);
        }
    }

    private SimSharingManager(PhetApplicationConfig phetApplicationConfig, String string) {
        this.enabled = phetApplicationConfig.hasCommandLineArg("-study");
        this.simStartedTime = System.currentTimeMillis();
        this.sessionId = SimSharingManager.generateSessionId();
        if (this.enabled) {
            this.studyName = phetApplicationConfig.getOptionArg("-study");
            this.simSharingConfig = SimSharingConfig.getConfig(this.studyName);
            this.studentId = this.getStudentId();
            SimSharingPropertiesFile simSharingPropertiesFile = new SimSharingPropertiesFile();
            this.machineCookie = simSharingPropertiesFile.getMachineCookie();
            this.logs.add(new ConsoleLog());
            this.logs.add(this.stringLog);
            if (this.simSharingConfig.sendToLogFile) {
                this.logs.add(new SimSharingFileLogger(this.machineCookie, this.sessionId, false));
            }
            if (this.simSharingConfig.sendToLogFileNearJAR) {
                this.logs.add(new SimSharingFileLogger(this.machineCookie, this.sessionId, true));
            }
            if (this.simSharingConfig.sendToServer) {
                try {
                    this.logs.add(new MongoLog(this.sessionId, string));
                }
                catch (UnknownHostException unknownHostException) {
                    unknownHostException.printStackTrace();
                }
            }
            this.sendStartupMessage(phetApplicationConfig);
            new Thread(){

                public void run() {
                }
            }.start();
        }
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static void sendSystemMessage(ISystemComponent iSystemComponent, ISystemComponentType iSystemComponentType, ISystemAction iSystemAction) {
        SimSharingManager.sendSystemMessage(iSystemComponent, iSystemComponentType, iSystemAction, new ParameterSet());
    }

    public static void sendSystemMessage(ISystemComponent iSystemComponent, ISystemComponentType iSystemComponentType, ISystemAction iSystemAction, ParameterSet parameterSet) {
        SimSharingManager.getInstance().sendMessage(new SystemMessage((IMessageType)SimSharingMessage.MessageType.system, iSystemComponent, iSystemComponentType, iSystemAction, parameterSet));
    }

    public void sendSystemMessageNS(ISystemComponent iSystemComponent, ISystemComponentType iSystemComponentType, ISystemAction iSystemAction, ParameterSet parameterSet) {
        this.sendMessage(new SystemMessage((IMessageType)SimSharingMessage.MessageType.system, iSystemComponent, iSystemComponentType, iSystemAction, parameterSet));
    }

    public static void sendButtonPressed(IUserComponent iUserComponent) {
        SimSharingManager.sendUserMessage(iUserComponent, UserComponentTypes.button, UserActions.pressed);
    }

    public static void sendUserMessage(IUserComponent iUserComponent, IUserComponentType iUserComponentType, IUserAction iUserAction) {
        SimSharingManager.sendUserMessage(iUserComponent, iUserComponentType, iUserAction, new ParameterSet());
    }

    public static void sendUserMessage(IUserComponent iUserComponent, IUserComponentType iUserComponentType, IUserAction iUserAction, ParameterSet parameterSet) {
        SimSharingManager.getInstance().sendMessage(new UserMessage((IMessageType)SimSharingMessage.MessageType.user, iUserComponent, iUserComponentType, iUserAction, parameterSet));
    }

    public static void sendModelMessage(IModelComponent iModelComponent, IModelComponentType iModelComponentType, IModelAction iModelAction, ParameterSet parameterSet) {
        SimSharingManager.getInstance().sendMessage(new ModelMessage((IMessageType)SimSharingMessage.MessageType.model, iModelComponent, iModelComponentType, iModelAction, parameterSet));
    }

    private void sendMessage(SimSharingMessage simSharingMessage) {
        if (this.enabled) {
            for (Log log : this.logs) {
                try {
                    log.addMessage(simSharingMessage);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            ++this.messageCount;
            if (this.messageCount % 100 == 0 && this.messageCount > 0) {
                SimSharingManager.sendSystemMessage(this.SYSTEM_COMPONENT, this.SYSTEM_COMPONENT_TYPE, SystemActions.sentEvent, ParameterSet.parameterSet((IParameterKey)ParameterKeys.messageCount, this.messageCount));
            }
        }
    }

    private String getStudentId() {
        assert (this.enabled);
        String string = null;
        if (this.simSharingConfig.requestId) {
            SimSharingIdDialog simSharingIdDialog = new SimSharingIdDialog(null, this.simSharingConfig.idPrompt, this.simSharingConfig.idRequired, this.simSharingConfig.characterValidation);
            SwingUtils.centerWindowOnScreen(simSharingIdDialog);
            simSharingIdDialog.setVisible(true);
            string = simSharingIdDialog.getId();
        }
        return string;
    }

    private void sendStartupMessage(PhetApplicationConfig phetApplicationConfig) {
        assert (this.enabled);
        this.sendSystemMessageNS(this.SYSTEM_COMPONENT, this.SYSTEM_COMPONENT_TYPE, SystemActions.started, ParameterSet.parameterSet((IParameterKey)ParameterKeys.time, this.simStartedTime).with((IParameterKey)ParameterKeys.name, phetApplicationConfig.getName()).with((IParameterKey)ParameterKeys.version, phetApplicationConfig.getVersion().formatForAboutDialog()).with((IParameterKey)ParameterKeys.project, phetApplicationConfig.getProjectName()).with((IParameterKey)ParameterKeys.flavor, phetApplicationConfig.getFlavor()).with((IParameterKey)ParameterKeys.locale, phetApplicationConfig.getLocale().toString()).with((IParameterKey)ParameterKeys.distributionTag, phetApplicationConfig.getDistributionTag()).with((IParameterKey)ParameterKeys.javaVersion, System.getProperty("java.version")).with((IParameterKey)ParameterKeys.osName, System.getProperty("os.name")).with((IParameterKey)ParameterKeys.osVersion, System.getProperty("os.version")).with((IParameterKey)ParameterKeys.parserVersion, 2).with((IParameterKey)ParameterKeys.study, this.studyName).with((IParameterKey)ParameterKeys.id, this.studentId).with((IParameterKey)ParameterKeys.commandLineArgs, new ObservableList<String>(phetApplicationConfig.getCommandLineArgs()).mkString(" ")).with((IParameterKey)ParameterKeys.machineCookie, this.machineCookie).with((IParameterKey)ParameterKeys.sessionId, this.sessionId));
    }

    public static String generateSessionId() {
        return "s" + SimSharingManager.generateStrongId();
    }

    public static String generateMachineCookie() {
        return SimSharingManager.generateStrongId();
    }

    private static String generateStrongId() {
        return new BigInteger(130, new SecureRandom()).toString(32);
    }

    public ArrayList<String> getLogNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Log log : this.logs) {
            arrayList.add(log.getName());
        }
        return arrayList;
    }

    public void shutdown() {
        for (Log log : this.logs) {
            log.shutdown();
        }
    }
}

