/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing.messages;

import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSet
implements Iterable<Parameter> {
    private final ArrayList<Parameter> parameters;

    public ParameterSet() {
        this(new ArrayList<Parameter>());
    }

    public ParameterSet(ArrayList<Parameter> arrayList) {
        this.parameters = arrayList;
    }

    public ParameterSet(final Parameter parameter) {
        this(new ArrayList<Parameter>(){
            {
                this.add(parameter);
            }
        });
    }

    public static ParameterSet parameterSet(IParameterKey iParameterKey, boolean bl) {
        return new ParameterSet(new Parameter(iParameterKey, bl));
    }

    public static ParameterSet parameterSet(IParameterKey iParameterKey, long l) {
        return new ParameterSet(new Parameter(iParameterKey, l));
    }

    public static ParameterSet parameterSet(IParameterKey iParameterKey, String string) {
        return new ParameterSet(new Parameter(iParameterKey, string));
    }

    private String getValue(IParameterKey iParameterKey) {
        return this.get((IParameterKey)iParameterKey).value;
    }

    public Parameter get(IParameterKey iParameterKey) {
        for (Parameter parameter : this.parameters) {
            if (!parameter.name.equals(iParameterKey)) continue;
            return parameter;
        }
        return null;
    }

    private boolean containsKey(IParameterKey iParameterKey) {
        return this.get(iParameterKey) != null;
    }

    public String toString(String string) {
        return new ObservableList<Parameter>(this.parameters).mkString(string);
    }

    public ParameterSet with(final Parameter parameter) {
        if (this.containsKey(parameter.name)) {
            if (!this.getValue(parameter.name).equals(parameter.value)) {
                throw new RuntimeException("Parameter name already contained with different value: " + this.get(parameter.name) + ", newValue = " + parameter.value);
            }
            return this;
        }
        return new ParameterSet(new ArrayList<Parameter>(this.parameters){
            {
                super(collection);
                this.add(parameter);
            }
        });
    }

    public ParameterSet with(IParameterKey iParameterKey, boolean bl) {
        return this.with(new Parameter(iParameterKey, bl));
    }

    public ParameterSet with(IParameterKey iParameterKey, double d) {
        return this.with(new Parameter(iParameterKey, d));
    }

    public ParameterSet with(IParameterKey iParameterKey, String string) {
        return this.with(new Parameter(iParameterKey, string));
    }

    public ParameterSet with(IParameterKey iParameterKey, int n) {
        return this.with(new Parameter(iParameterKey, n));
    }

    public ParameterSet with(Parameter[] parameterArray) {
        ParameterSet parameterSet = this;
        for (Parameter parameter : parameterArray) {
            parameterSet = parameterSet.with(parameter);
        }
        return parameterSet;
    }

    public ParameterSet with(ParameterSet parameterSet) {
        return this.with(parameterSet.parameters.toArray(new Parameter[parameterSet.parameters.size()]));
    }

    @Override
    public Iterator<Parameter> iterator() {
        return this.parameters.iterator();
    }
}

