/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomSetCollection {
    private String fileTypeName;
    private String collectionName;
    private Map<String, Object> atomSetCollectionAuxiliaryInfo = new Hashtable<String, Object>();
    private static final String[] globalBooleans = new String[]{"someModelsHaveFractionalCoordinates", "someModelsHaveSymmetry", "someModelsHaveUnitcells", "someModelsHaveCONECT", "isPDB"};
    public static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    private int atomCount;
    private Atom[] atoms = new Atom[256];
    private int bondCount;
    private Bond[] bonds = new Bond[256];
    private int structureCount;
    private Structure[] structures = new Structure[16];
    private int atomSetCount;
    private int currentAtomSetIndex = -1;
    private int[] atomSetNumbers = new int[16];
    private int[] atomSetAtomCounts = new int[16];
    private int[] atomSetBondCounts = new int[16];
    private Map<String, Object>[] atomSetAuxiliaryInfo = new Hashtable[16];
    private int[] latticeCells;
    public String errorMessage;
    public boolean coordinatesAreFractional;
    private boolean isTrajectory;
    private int trajectoryStepCount = 0;
    private Point3f[] trajectoryStep;
    private List<Point3f[]> trajectorySteps;
    boolean doFixPeriodic;
    float[] notionalUnitCell = new float[6];
    private boolean allowMultiple;
    List<int[]> vConnect;
    int connectNextAtomIndex = 0;
    int connectNextAtomSet = 0;
    int[] connectLast;
    float symmetryRange;
    private float[] scTemp;
    SymmetryInterface symmetry;
    boolean haveUnitCell = false;
    boolean doNormalize = true;
    boolean doPackUnitCell = false;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private final Point3f ptOffset = new Point3f();
    private Point3f unitCellOffset;
    private Point3i minXYZ;
    private Point3i maxXYZ;
    private boolean needEllipsoids;
    Point3f[] cartesians;
    int bondCount0;
    int bondIndex0;
    boolean applySymmetryToBonds = false;
    boolean checkSpecial = true;
    private final Point3f ptTemp = new Point3f();
    private final Point3f ptTemp1 = new Point3f();
    private final Point3f ptTemp2 = new Point3f();
    Map<Object, Integer> atomSymbolicMap = new Hashtable<Object, Integer>();
    boolean haveMappedSerials;
    VolumeDataInterface vd;
    public BitSet bsAtoms;

    public String getFileTypeName() {
        return this.fileTypeName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String string) {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                return;
            }
            this.collectionName = string;
        }
    }

    public Map<String, Object> getAtomSetCollectionAuxiliaryInfo() {
        return this.atomSetCollectionAuxiliaryInfo;
    }

    public void setIsPDB() {
        this.setGlobalBoolean(4);
    }

    public void clearGlobalBoolean(int n) {
        this.atomSetCollectionAuxiliaryInfo.remove(globalBooleans[n]);
    }

    private void setGlobalBoolean(int n) {
        this.setAtomSetCollectionAuxiliaryInfo(globalBooleans[n], Boolean.TRUE);
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtom(int n) {
        return this.atoms[n];
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public int getStructureCount() {
        return this.structureCount;
    }

    public Structure[] getStructures() {
        return this.structures;
    }

    public int getAtomSetCount() {
        return this.atomSetCount;
    }

    public int getCurrentAtomSetIndex() {
        return this.currentAtomSetIndex;
    }

    public AtomSetCollection(String string, AtomSetCollectionReader atomSetCollectionReader) {
        this.fileTypeName = string;
        this.allowMultiple = atomSetCollectionReader == null || atomSetCollectionReader.desiredVibrationNumber < 0;
        Properties properties = new Properties();
        properties.put("PATH_KEY", ".PATH");
        properties.put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
        this.setAtomSetCollectionAuxiliaryInfo("properties", properties);
    }

    public AtomSetCollection(AtomSetCollection[] atomSetCollectionArray) {
        this("Array", null);
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        for (int i = 0; i < atomSetCollectionArray.length; ++i) {
            this.appendAtomSetCollection(i, atomSetCollectionArray[i]);
        }
    }

    public AtomSetCollection(List<?> list) {
        this("Array", null);
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        this.appendAtomSetCollection(list);
    }

    private void appendAtomSetCollection(List<?> list) {
        int n = list.size();
        if (n == 0) {
            this.errorMessage = "No file found!";
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            if (obj instanceof List) {
                this.appendAtomSetCollection((List)obj);
                continue;
            }
            this.appendAtomSetCollection(i, (AtomSetCollection)obj);
        }
    }

    public void setTrajectory() {
        if (!this.isTrajectory) {
            this.trajectorySteps = new ArrayList<Point3f[]>();
        }
        this.isTrajectory = true;
        this.addTrajectoryStep();
    }

    protected void appendAtomSetCollection(int n, AtomSetCollection atomSetCollection) {
        Object object;
        int n2;
        int n3 = this.atomCount;
        int n4 = 0;
        this.setAtomSetCollectionAuxiliaryInfo("loadState", atomSetCollection.getAtomSetCollectionAuxiliaryInfo("loadState"));
        for (n2 = 0; n2 < atomSetCollection.atomSetCount; ++n2) {
            int n5;
            this.newAtomSet();
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex] = atomSetCollection.atomSetAuxiliaryInfo[n2];
            object = this.atomSetAuxiliaryInfo[this.currentAtomSetIndex];
            int[] nArray = (int[])object.get("PDB_CONECT_firstAtom_count_max");
            if (nArray != null) {
                nArray[0] = nArray[0] + n3;
            }
            this.setAtomSetAuxiliaryInfo("title", atomSetCollection.collectionName);
            this.setAtomSetName(atomSetCollection.getAtomSetName(n2));
            for (n5 = 0; n5 < atomSetCollection.atomSetAtomCounts[n2]; ++n5) {
                try {
                    this.newCloneAtom(atomSetCollection.atoms[n4]);
                }
                catch (Exception exception) {
                    this.errorMessage = "appendAtomCollection error: " + exception;
                }
                ++n4;
            }
            for (n5 = 0; n5 < atomSetCollection.structureCount; ++n5) {
                if (atomSetCollection.structures[n5].modelIndex != n2 && atomSetCollection.structures[n5].modelIndex != -1) continue;
                this.addStructure(atomSetCollection.structures[n5]);
            }
            this.atomSetNumbers[this.currentAtomSetIndex] = (n + 1) * 1000000 + atomSetCollection.atomSetNumbers[n2];
        }
        for (n2 = 0; n2 < atomSetCollection.bondCount; ++n2) {
            object = atomSetCollection.bonds[n2];
            this.addNewBond(((Bond)object).atomIndex1 + n3, ((Bond)object).atomIndex2 + n3, ((Bond)object).order);
        }
        n2 = globalBooleans.length;
        while (--n2 >= 0) {
            if (!Boolean.TRUE.equals(atomSetCollection.getAtomSetCollectionAuxiliaryInfo(globalBooleans[n2]))) continue;
            this.setGlobalBoolean(n2);
        }
    }

    void setNoAutoBond() {
        this.setAtomSetCollectionAuxiliaryInfo("noAutoBond", Boolean.TRUE);
    }

    void freeze() {
        if (this.isTrajectory) {
            this.finalizeTrajectory();
        }
        this.getList(true);
        this.getList(false);
        for (int i = 0; i < this.atomSetCount; ++i) {
            this.setAtomSetAuxiliaryInfo("initialAtomCount", this.atomSetAtomCounts[i], i);
            this.setAtomSetAuxiliaryInfo("initialBondCount", this.atomSetBondCounts[i], i);
        }
    }

    private void getList(boolean bl) {
        int n = this.atomCount;
        while (--n >= 0 && (this.atoms[n] == null || (bl ? this.atoms[n].alternateLocationID : this.atoms[n].insertionCode) == '\u0000')) {
        }
        if (n < 0) {
            return;
        }
        String[] stringArray = new String[this.atomSetCount];
        for (n = 0; n < this.atomSetCount; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.atomCount; ++n) {
            int n2;
            char c;
            if (this.atoms[n] == null) continue;
            char c2 = c = bl ? this.atoms[n].alternateLocationID : this.atoms[n].insertionCode;
            if (c == '\u0000' || stringArray[n2 = this.atoms[n].atomSetIndex].indexOf(c) >= 0) continue;
            int n3 = n2;
            stringArray[n3] = stringArray[n3] + c;
        }
        String string = bl ? "altLocs" : "insertionCodes";
        for (n = 0; n < this.atomSetCount; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo(string, stringArray[n], n);
        }
    }

    void finish() {
        this.atoms = null;
        this.atomSetAtomCounts = new int[16];
        this.atomSetAuxiliaryInfo = new Hashtable[16];
        this.atomSetCollectionAuxiliaryInfo = new Hashtable<String, Object>();
        this.atomSetCount = 0;
        this.atomSetNumbers = new int[16];
        this.atomSymbolicMap = new Hashtable<Object, Integer>();
        this.bonds = null;
        this.cartesians = null;
        this.connectLast = null;
        this.currentAtomSetIndex = -1;
        this.latticeCells = null;
        this.notionalUnitCell = null;
        this.symmetry = null;
        this.structures = new Structure[16];
        this.structureCount = 0;
        this.trajectoryStep = null;
        this.trajectorySteps = null;
        this.vConnect = null;
        this.vd = null;
    }

    public void discardPreviousAtoms() {
        int n = this.atomCount;
        while (--n >= 0) {
            this.atoms[n] = null;
        }
        this.atomCount = 0;
        this.clearSymbolicMap();
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
        n = this.atomSetAuxiliaryInfo.length;
        while (--n >= 0) {
            this.atomSetAtomCounts[n] = 0;
            this.atomSetBondCounts[n] = 0;
            this.atomSetAuxiliaryInfo[n] = null;
        }
    }

    public void removeAtomSet() {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        --this.currentAtomSetIndex;
        --this.atomSetCount;
    }

    Atom newCloneAtom(Atom atom) throws Exception {
        Atom atom2 = atom.cloneAtom();
        this.addAtom(atom2);
        return atom2;
    }

    public int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public int getLastAtomSetAtomIndex() {
        return this.atomCount - this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = this.atomCount > 200000 ? (Atom[])ArrayUtil.ensureLength(this.atoms, this.atomCount + 50000) : (Atom[])ArrayUtil.doubleLength(this.atoms);
        }
        atom.atomIndex = this.atomCount;
        this.atoms[this.atomCount++] = atom;
        if (this.atomSetCount == 0) {
            this.newAtomSet();
        }
        atom.atomSetIndex = this.currentAtomSetIndex;
        int n = this.currentAtomSetIndex;
        int n2 = this.atomSetAtomCounts[n];
        this.atomSetAtomCounts[n] = n2 + 1;
        atom.atomSite = n2;
    }

    public void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    public void addAtomWithMappedSerialNumber(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomSerialNumber();
    }

    public Bond addNewBond(int n, int n2) {
        return this.addNewBond(n, n2, 1);
    }

    public Bond addNewBond(int n, int n2, int n3) {
        if (n < 0 || n >= this.atomCount || n2 < 0 || n2 >= this.atomCount) {
            return null;
        }
        Bond bond = new Bond(n, n2, n3);
        this.addBond(bond);
        return bond;
    }

    public Bond addNewBond(String string, String string2, int n) {
        return this.addNewBond(this.getAtomNameIndex(string), this.getAtomNameIndex(string2), n);
    }

    public Bond addNewBondWithMappedSerialNumbers(int n, int n2, int n3) {
        return this.addNewBond(this.getAtomSerialNumberIndex(n), this.getAtomSerialNumberIndex(n2), n3);
    }

    public void addBond(Bond bond) {
        if (this.trajectoryStepCount > 0) {
            return;
        }
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order < 0 || this.atoms[bond.atomIndex1].atomSetIndex != this.atoms[bond.atomIndex2].atomSetIndex) {
            if (Logger.debugging) {
                Logger.debug(">>>>>>BAD BOND:" + bond.atomIndex1 + "-" + bond.atomIndex2 + " order=" + bond.order);
            }
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
        int n = this.currentAtomSetIndex;
        this.atomSetBondCounts[n] = this.atomSetBondCounts[n] + 1;
    }

    public void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength(this.structures, this.structureCount + 32);
        }
        structure.modelIndex = this.currentAtomSetIndex;
        this.structures[this.structureCount++] = structure;
        if (structure.strandCount >= 1) {
            int n = this.structureCount;
            n = this.structureCount;
            while (--n >= 0 && this.structures[n].modelIndex == this.currentAtomSetIndex && this.structures[n].structureID.equals(structure.structureID)) {
            }
            int n2 = this.structureCount - ++n;
            while (n < this.structureCount) {
                this.structures[n].strandCount = n2;
                ++n;
            }
        }
    }

    void setAtomSetSpaceGroupName(String string) {
        this.setAtomSetAuxiliaryInfo("spaceGroup", string + "");
    }

    public void setCoordinatesAreFractional(boolean bl) {
        this.coordinatesAreFractional = bl;
        this.setAtomSetAuxiliaryInfo("coordinatesAreFractional", bl);
        if (bl) {
            this.setGlobalBoolean(0);
        }
    }

    void setSymmetryRange(float f) {
        this.symmetryRange = f;
        this.setAtomSetCollectionAuxiliaryInfo("symmetryRange", new Float(f));
    }

    void setLatticeCells(int[] nArray, boolean bl, boolean bl2, String string) {
        this.latticeCells = nArray;
        boolean bl3 = nArray[0] <= 555 && nArray[1] >= 555 && (nArray[2] == 0 || nArray[2] == 1 || nArray[2] == -1);
        this.doNormalize = nArray[0] != 0 && (!bl3 || nArray[2] == 1);
        this.applySymmetryToBonds = bl;
        this.doPackUnitCell = bl2;
        if (string != null) {
            this.setSuperCell(string);
        }
    }

    private void setSuperCell(String string) {
        if (this.scTemp != null) {
            return;
        }
        this.scTemp = new float[16];
        if (this.getSymmetry().getMatrixFromString(string, this.scTemp, true) == null) {
            this.scTemp = null;
            return;
        }
        Logger.info("Using supercell \n" + new Matrix4f(this.scTemp));
    }

    public SymmetryInterface getSymmetry() {
        if (this.symmetry == null) {
            this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
        return this.symmetry;
    }

    public void setNotionalUnitCell(float[] fArray, Matrix3f matrix3f, Point3f point3f) {
        this.notionalUnitCell = new float[fArray.length];
        this.unitCellOffset = point3f;
        for (int i = 0; i < fArray.length; ++i) {
            this.notionalUnitCell[i] = fArray[i];
        }
        this.haveUnitCell = true;
        this.setAtomSetAuxiliaryInfo("notionalUnitcell", this.notionalUnitCell);
        this.setGlobalBoolean(2);
        this.getSymmetry().setUnitCell(this.notionalUnitCell);
        if (point3f != null) {
            this.symmetry.setUnitCellOffset(point3f);
            this.setAtomSetAuxiliaryInfo("unitCellOffset", point3f);
        }
        if (matrix3f != null) {
            this.symmetry.setUnitCellOrientation(matrix3f);
            this.setAtomSetAuxiliaryInfo("matUnitCellOrientation", matrix3f);
        }
    }

    boolean addSpaceGroupOperation(String string) {
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        return this.symmetry.addSpaceGroupOperation(string, 0) >= 0;
    }

    void applySymmetry() throws Exception {
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], Math.abs(this.latticeCells[2]));
    }

    void applySymmetry(SymmetryInterface symmetryInterface) throws Exception {
        this.getSymmetry().setSpaceGroup(symmetryInterface);
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], Math.abs(this.latticeCells[2]));
    }

    private void applySymmetry(int n, int n2, int n3) throws Exception {
        if (!this.coordinatesAreFractional || !this.getSymmetry().haveSpaceGroup()) {
            return;
        }
        if (this.scTemp != null) {
            int n4;
            int n5;
            this.rminx = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminz = Float.MAX_VALUE;
            this.rmaxx = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
            Point3f point3f = this.setSym(0, 1, 2);
            Point3f point3f2 = this.setSym(4, 5, 6);
            Point3f point3f3 = this.setSym(8, 9, 10);
            this.minXYZ = new Point3i((int)this.rminx, (int)this.rminy, (int)this.rminz);
            this.maxXYZ = new Point3i((int)this.rmaxx, (int)this.rmaxy, (int)this.rmaxz);
            this.applyAllSymmetry();
            for (n5 = n4 = this.getLastAtomSetAtomIndex(); n5 < this.atomCount; ++n5) {
                this.symmetry.toCartesian(this.atoms[n5], true);
            }
            this.symmetry = null;
            this.setNotionalUnitCell(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, point3f.x, point3f.y, point3f.z, point3f2.x, point3f2.y, point3f2.z, point3f3.x, point3f3.y, point3f3.z}, null, (Point3f)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, "unitCellOffset"));
            this.setAtomSetSpaceGroupName("P1");
            this.getSymmetry().setSpaceGroup(this.doNormalize);
            this.symmetry.addSpaceGroupOperation("x,y,z", 0);
            for (n5 = n4; n5 < this.atomCount; ++n5) {
                this.symmetry.toFractional(this.atoms[n5], true);
            }
            this.needEllipsoids = false;
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].remove("matUnitCellOrientation");
        }
        this.minXYZ = new Point3i();
        this.maxXYZ = new Point3i(n, n2, n3);
        this.applyAllSymmetry();
        this.scTemp = null;
    }

    private Point3f setSym(int n, int n2, int n3) {
        Point3f point3f = new Point3f();
        point3f.set(this.scTemp[n], this.scTemp[n2], this.scTemp[n3]);
        this.setSymmetryMinMax(point3f);
        this.symmetry.toCartesian(point3f, false);
        return point3f;
    }

    private void setSymmetryMinMax(Point3f point3f) {
        if (this.rminx > point3f.x) {
            this.rminx = point3f.x;
        }
        if (this.rminy > point3f.y) {
            this.rminy = point3f.y;
        }
        if (this.rminz > point3f.z) {
            this.rminz = point3f.z;
        }
        if (this.rmaxx < point3f.x) {
            this.rmaxx = point3f.x;
        }
        if (this.rmaxy < point3f.y) {
            this.rmaxy = point3f.y;
        }
        if (this.rmaxz < point3f.z) {
            this.rmaxz = point3f.z;
        }
    }

    private boolean isInSymmetryRange(Point3f point3f) {
        return point3f.x >= this.rminx && point3f.y >= this.rminy && point3f.z >= this.rminz && point3f.x <= this.rmaxx && point3f.y <= this.rmaxy && point3f.z <= this.rmaxz;
    }

    private static boolean isWithinCell(Point3f point3f, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = 0.02f;
        return point3f.x > (float)n - f && point3f.x < (float)n2 + f && point3f.y > (float)n3 - f && point3f.y < (float)n4 + f && point3f.z > (float)n5 - f && point3f.z < (float)n6 + f;
    }

    public void setAnisoBorU(Atom atom, float[] fArray, int n) {
        this.needEllipsoids = true;
        atom.anisoBorU = fArray;
        fArray[6] = n;
    }

    public float[] getAnisoBorU(Atom atom) {
        return atom.anisoBorU;
    }

    private void applyAllSymmetry() throws Exception {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4;
        int n5;
        int n6 = this.getLastAtomSetAtomCount();
        int n7 = this.getLastAtomSetAtomIndex();
        if (this.needEllipsoids) {
            for (n5 = n7; n5 < this.atomCount; ++n5) {
                this.atoms[n5].ellipsoid = this.symmetry.getEllipsoid(this.atoms[n5].anisoBorU);
            }
        }
        this.bondCount0 = this.bondCount;
        this.symmetry.setFinalOperations(this.atoms, n7, n6, this.doNormalize);
        n5 = this.symmetry.getSpaceGroupOperationCount();
        this.getSymmetry().setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
        if (this.doPackUnitCell || this.symmetryRange != 0.0f && this.maxXYZ.x - this.minXYZ.x == 1 && this.maxXYZ.y - this.minXYZ.y == 1 && this.maxXYZ.z - this.minXYZ.z == 1) {
            switch ((int)this.getSymmetry().getUnitCellInfo(6)) {
                case 3: {
                    --this.minXYZ.z;
                    ++this.maxXYZ.z;
                }
                case 2: {
                    --this.minXYZ.y;
                    ++this.maxXYZ.y;
                }
                case 1: {
                    --this.minXYZ.x;
                    ++this.maxXYZ.x;
                }
            }
        }
        int n8 = (this.maxXYZ.x - this.minXYZ.x) * (this.maxXYZ.y - this.minXYZ.y) * (this.maxXYZ.z - this.minXYZ.z);
        int n9 = this.checkSpecial ? n6 * n5 * n8 : (this.symmetryRange > 0.0f ? n6 * n5 : (this.symmetryRange < 0.0f ? 1 : 1));
        this.cartesians = new Point3f[n9];
        for (n4 = 0; n4 < n6; ++n4) {
            this.atoms[n4 + n7].bsSymmetry = new BitSet(n5 * (n8 + 1));
        }
        n4 = 0;
        int[] nArray = new int[n8];
        int n10 = 0;
        int n11 = 0;
        float f = Math.abs(this.symmetryRange);
        boolean bl2 = this.symmetryRange != 0.0f;
        boolean bl3 = this.symmetryRange < 0.0f;
        boolean bl4 = bl = this.symmetryRange > 0.0f;
        if (bl2) {
            this.rminx = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminz = Float.MAX_VALUE;
            this.rmaxx = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
        }
        Matrix4f matrix4f = this.symmetry.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    nArray[n10++] = 555 + n3 * 100 + n2 * 10 + n;
                    if (n3 != 0 || n2 != 0 || n != 0 || this.cartesians.length == 0) continue;
                    for (n4 = 0; n4 < n6; ++n4) {
                        Atom atom = this.atoms[n7 + n4];
                        Point3f point3f = new Point3f(atom);
                        matrix4f.transform(point3f);
                        this.symmetry.toCartesian(point3f, false);
                        if (this.doPackUnitCell) {
                            this.symmetry.toUnitCell(point3f, this.ptOffset);
                            atom.set(point3f);
                            this.symmetry.toFractional(atom, false);
                        }
                        atom.bsSymmetry.set(n10 * n5);
                        atom.bsSymmetry.set(0);
                        if (bl2) {
                            this.setSymmetryMinMax(point3f);
                        }
                        if (n4 >= n9) continue;
                        this.cartesians[n4] = point3f;
                    }
                    if (bl3) {
                        this.rminx -= f;
                        this.rminy -= f;
                        this.rminz -= f;
                        this.rmaxx += f;
                        this.rmaxy += f;
                        this.rmaxz += f;
                    }
                    n11 = n4 = this.symmetryAddAtoms(n7, n6, 0, 0, 0, 0, n4, n10 * n5);
                }
            }
        }
        if (bl) {
            this.rminx -= f;
            this.rminy -= f;
            this.rminz -= f;
            this.rmaxx += f;
            this.rmaxy += f;
            this.rmaxz += f;
        }
        if (this.scTemp != null) {
            // empty if block
        }
        n10 = 0;
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    ++n10;
                    if (n3 == 0 && n2 == 0 && n == 0) continue;
                    n4 = this.symmetryAddAtoms(n7, n6, n3, n2, n, n11, n4, n10 * n5);
                }
            }
        }
        if (n10 * n6 == this.atomCount - n7) {
            this.appendAtomProperties(n10);
        }
        this.setSymmetryOps();
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", n7);
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", n6);
        this.setAtomSetAuxiliaryInfo("latticeDesignation", this.symmetry.getLatticeDesignation());
        this.setAtomSetAuxiliaryInfo("unitCellRange", nArray);
        this.symmetry.setSpaceGroup(null);
        this.notionalUnitCell = new float[6];
        this.coordinatesAreFractional = false;
        this.setAtomSetAuxiliaryInfo("hasSymmetry", Boolean.TRUE);
        this.setGlobalBoolean(1);
    }

    private void setSymmetryOps() {
        int n = this.symmetry.getSpaceGroupOperationCount();
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "" + this.symmetry.getSpaceGroupXyz(i, this.doNormalize);
            }
            this.setAtomSetAuxiliaryInfo("symmetryOperations", stringArray);
        }
        this.setAtomSetAuxiliaryInfo("symmetryCount", n);
    }

    public void setCheckSpecial(boolean bl) {
        this.checkSpecial = bl;
    }

    private int symmetryAddAtoms(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws Exception {
        boolean bl;
        int[] nArray;
        boolean bl2 = n6 == 0;
        boolean bl3 = this.bondCount0 > this.bondIndex0 && this.applySymmetryToBonds;
        int[] nArray2 = nArray = bl3 ? new int[n2] : null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(n3, n4, n5);
        }
        float f = this.symmetryRange * this.symmetryRange;
        boolean bl4 = this.symmetryRange < 0.0f;
        boolean bl5 = this.symmetryRange > 0.0f;
        boolean bl6 = bl2 && bl5;
        boolean bl7 = bl4 || (bl5 &= !bl2);
        boolean bl8 = this.checkSpecial || bl7;
        boolean bl9 = bl = this.checkSpecial || bl6;
        if (bl4) {
            n6 = n2;
        }
        int n9 = this.symmetry.getSpaceGroupOperationCount();
        int n10 = n + n2;
        Point3f point3f = new Point3f();
        for (int i = 0; i < n9; ++i) {
            Point3f point3f2;
            Object object;
            int n11;
            if (bl2 && this.symmetry.getSpaceGroupXyz(i, true).equals("x,y,z")) continue;
            int n12 = this.checkSpecial ? n7 : (bl5 ? n6 : 0);
            for (n11 = n; n11 < n10; ++n11) {
                if (this.atoms[n11].ignoreSymmetry) continue;
                this.symmetry.newSpaceGroupPoint(i, this.atoms[n11], point3f, n3, n4, n5);
                object = null;
                point3f2 = new Point3f(point3f);
                this.symmetry.toCartesian(point3f2, false);
                if (this.doPackUnitCell) {
                    this.symmetry.toUnitCell(point3f2, this.ptOffset);
                    point3f.set(point3f2);
                    this.symmetry.toFractional(point3f, false);
                    if (!AtomSetCollection.isWithinCell(point3f, this.minXYZ.x + 1, this.maxXYZ.x - 1, this.minXYZ.y + 1, this.maxXYZ.y - 1, this.minXYZ.z + 1, this.maxXYZ.z - 1)) continue;
                }
                if (bl6) {
                    this.setSymmetryMinMax(point3f2);
                }
                if (bl8) {
                    float f2 = Float.MAX_VALUE;
                    if (bl7 && !this.isInSymmetryRange(point3f2)) continue;
                    int n13 = n12;
                    while (--n13 >= 0) {
                        float f3 = point3f2.distanceSquared(this.cartesians[n13]);
                        if (this.checkSpecial && (double)f3 < 1.0E-4) {
                            object = this.atoms[n + n13];
                            break;
                        }
                        if (!bl5 || n13 >= n6 || !(f3 < f2)) continue;
                        f2 = f3;
                    }
                    if (bl5 && f2 > f) continue;
                }
                int n14 = this.atoms[n11].atomSite;
                if (object != null) {
                    if (bl3) {
                        nArray[n14] = ((Atom)object).atomIndex;
                    }
                    ((Atom)object).bsSymmetry.set(n8 + i);
                    ((Atom)object).bsSymmetry.set(i);
                    continue;
                }
                if (bl3) {
                    nArray[n14] = this.atomCount;
                }
                Atom atom = this.newCloneAtom(this.atoms[n11]);
                atom.set(point3f);
                atom.atomSite = n14;
                atom.bsSymmetry = BitSetUtil.setBit(n8 + i);
                atom.bsSymmetry.set(i);
                if (bl) {
                    this.cartesians[n7++] = point3f2;
                }
                if (this.atoms[n11].ellipsoid == null) continue;
                Object object2 = this.atoms[n11].ellipsoid[0];
                Object object3 = this.atoms[n11].ellipsoid[1];
                if (object2 != null) {
                    if (bl) {
                        this.ptTemp.set(this.cartesians[n11 - n]);
                    } else {
                        this.ptTemp.set(this.atoms[n11]);
                        this.symmetry.toCartesian(this.ptTemp, false);
                    }
                    object2 = this.symmetry.rotateEllipsoid(i, this.ptTemp, (Vector3f[])object2, this.ptTemp1, this.ptTemp2);
                }
                atom.ellipsoid = new Object[]{object2, object3};
            }
            if (!bl3) continue;
            for (n11 = this.bondIndex0; n11 < this.bondCount0; ++n11) {
                object = this.bonds[n11];
                point3f2 = this.atoms[((Bond)object).atomIndex1];
                Atom atom = this.atoms[((Bond)object).atomIndex2];
                if (point3f2 == null || atom == null) continue;
                int n15 = nArray[((Atom)point3f2).atomSite];
                int n16 = nArray[atom.atomSite];
                if (n15 < n10 && n16 < n10) continue;
                this.addNewBond(n15, n16, ((Bond)object).order);
            }
        }
        return n7;
    }

    void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int n = this.atomCount - 1;
            String string = this.atoms[n].atomName;
            if (string != null) {
                this.atomSymbolicMap.put(string, n);
            }
        }
    }

    public void clearSymbolicMap() {
        this.atomSymbolicMap.clear();
        this.haveMappedSerials = false;
    }

    void mapMostRecentAtomSerialNumber() {
        if (this.atomCount == 0) {
            return;
        }
        int n = this.atomCount - 1;
        int n2 = this.atoms[n].atomSerial;
        if (n2 != Integer.MIN_VALUE) {
            this.atomSymbolicMap.put(n2, n);
        }
        this.haveMappedSerials = true;
    }

    public int getAtomNameIndex(String string) {
        int n = -1;
        Integer n2 = this.atomSymbolicMap.get(string);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public int getAtomSerialNumberIndex(int n) {
        int n2 = -1;
        Integer n3 = this.atomSymbolicMap.get(n);
        if (n3 != null) {
            n2 = n3;
        }
        return n2;
    }

    public void setAtomSetCollectionAuxiliaryInfo(String string, Object object) {
        this.atomSetCollectionAuxiliaryInfo.put(string, object);
    }

    public Object getAtomSetCollectionAuxiliaryInfo(String string) {
        return this.atomSetCollectionAuxiliaryInfo.get(string);
    }

    private void addTrajectoryStep() {
        this.trajectoryStep = new Point3f[this.atomCount];
        Point3f[] point3fArray = this.trajectoryStepCount == 0 ? null : this.trajectorySteps.get(this.trajectoryStepCount - 1);
        for (int i = 0; i < this.atomCount; ++i) {
            Point3f point3f = new Point3f(this.atoms[i]);
            if (this.doFixPeriodic && point3fArray != null) {
                point3f = this.fixPeriodic(point3f, point3fArray[i]);
            }
            this.trajectoryStep[i] = point3f;
        }
        this.trajectorySteps.add(this.trajectoryStep);
        ++this.trajectoryStepCount;
    }

    private Point3f fixPeriodic(Point3f point3f, Point3f point3f2) {
        point3f.x = this.fixPoint(point3f.x, point3f2.x);
        point3f.y = this.fixPoint(point3f.y, point3f2.y);
        point3f.z = this.fixPoint(point3f.z, point3f2.z);
        return point3f;
    }

    private float fixPoint(float f, float f2) {
        while ((double)(f - f2) > 0.9) {
            f -= 1.0f;
        }
        while ((double)(f - f2) < -0.9) {
            f += 1.0f;
        }
        return f;
    }

    void finalizeTrajectory(List<Point3f[]> list) {
        this.trajectorySteps = list;
        this.trajectoryStepCount = list.size();
        this.finalizeTrajectory();
    }

    private void finalizeTrajectory() {
        if (this.trajectoryStepCount == 0) {
            return;
        }
        Point3f[] point3fArray = this.trajectorySteps.get(0);
        for (int i = 0; i < this.atomCount; ++i) {
            this.atoms[i].set(point3fArray[i]);
        }
        this.setAtomSetCollectionAuxiliaryInfo("trajectorySteps", this.trajectorySteps);
    }

    public void newAtomSet() {
        if (!this.allowMultiple && this.currentAtomSetIndex >= 0) {
            this.discardPreviousAtoms();
        }
        this.bondIndex0 = this.bondCount;
        if (this.isTrajectory) {
            this.discardPreviousAtoms();
        }
        this.currentAtomSetIndex = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetAtomCounts = ArrayUtil.doubleLength(this.atomSetAtomCounts);
            this.atomSetBondCounts = ArrayUtil.doubleLength(this.atomSetBondCounts);
            this.atomSetAuxiliaryInfo = (Map[])ArrayUtil.doubleLength(this.atomSetAuxiliaryInfo);
        }
        if (this.atomSetCount + this.trajectoryStepCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = ArrayUtil.doubleLength(this.atomSetNumbers);
        }
        if (this.isTrajectory) {
            this.atomSetNumbers[this.currentAtomSetIndex + this.trajectoryStepCount] = this.atomSetCount + this.trajectoryStepCount;
        } else {
            this.atomSetNumbers[this.currentAtomSetIndex] = this.atomSetCount;
        }
        this.atomSymbolicMap.clear();
        this.setAtomSetAuxiliaryInfo("title", this.collectionName);
    }

    public void setAtomSetName(String string) {
        this.setAtomSetAuxiliaryInfo("name", string, this.currentAtomSetIndex);
        if (!this.allowMultiple) {
            this.setCollectionName(string);
        }
    }

    private void appendAtomProperties(int n) {
        Map map = (Map)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, "atomProperties");
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = n;
            while (--n2 >= 0) {
                stringBuilder.append(string2);
            }
            map.put(string, stringBuilder.toString());
        }
    }

    public void setAtomSetAuxiliaryInfo(String string, Object object) {
        this.setAtomSetAuxiliaryInfo(string, object, this.currentAtomSetIndex);
    }

    Object getAtomSetAuxiliaryInfo(int n, String string) {
        return this.atomSetAuxiliaryInfo[n].get(string);
    }

    void setAtomSetAuxiliaryInfo(String string, Object object, int n) {
        if (n < 0) {
            return;
        }
        if (this.atomSetAuxiliaryInfo[n] == null) {
            this.atomSetAuxiliaryInfo[n] = new Hashtable<String, Object>();
        }
        if (object == null) {
            this.atomSetAuxiliaryInfo[n].remove(string);
        } else {
            this.atomSetAuxiliaryInfo[n].put(string, object);
        }
    }

    int getAtomSetNumber(int n) {
        return this.atomSetNumbers[n >= this.atomSetCount ? 0 : n];
    }

    String getAtomSetName(int n) {
        if (n >= this.atomSetCount) {
            n = this.atomSetCount - 1;
        }
        return (String)this.getAtomSetAuxiliaryInfo(n, "name");
    }

    Map<String, Object> getAtomSetAuxiliaryInfo(int n) {
        return this.atomSetAuxiliaryInfo[n >= this.atomSetCount ? this.atomSetCount - 1 : n];
    }

    public Properties setAtomNames(Properties properties) {
        if (properties == null) {
            return null;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            String string = properties.getProperty(this.atoms[i].atomName);
            if (string == null) continue;
            this.atoms[i].atomName = string;
        }
        return null;
    }

    void toCartesian(SymmetryInterface symmetryInterface) {
        for (int i = this.getLastAtomSetAtomIndex(); i < this.atomCount; ++i) {
            symmetryInterface.toCartesian(this.atoms[i], true);
        }
    }
}

