/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolRendererInterface;

public class Hermite3D {
    private JmolRendererInterface g3d;
    private final Point3i[] pLeft = new Point3i[16];
    private final Point3i[] pRight = new Point3i[16];
    private final float[] sLeft = new float[16];
    private final float[] sRight = new float[16];
    private final Point3f[] pTopLeft = new Point3f[16];
    private final Point3f[] pTopRight = new Point3f[16];
    private final Point3f[] pBotLeft = new Point3f[16];
    private final Point3f[] pBotRight = new Point3f[16];
    private final Point3f a1;
    private final Point3f a2;
    private final Point3f b1;
    private final Point3f b2;
    private final Point3f c1;
    private final Point3f c2;
    private final Point3f d1;
    private final Point3f d2;
    private final Vector3f depth1;
    private final boolean[] needToFill;
    private final Vector3f T1;
    private final Vector3f T2;

    public Hermite3D(JmolRendererInterface jmolRendererInterface) {
        int n = 16;
        while (--n >= 0) {
            this.pLeft[n] = new Point3i();
            this.pRight[n] = new Point3i();
            this.pTopLeft[n] = new Point3f();
            this.pTopRight[n] = new Point3f();
            this.pBotLeft[n] = new Point3f();
            this.pBotRight[n] = new Point3f();
        }
        this.a1 = new Point3f();
        this.a2 = new Point3f();
        this.b1 = new Point3f();
        this.b2 = new Point3f();
        this.c1 = new Point3f();
        this.c2 = new Point3f();
        this.d1 = new Point3f();
        this.d2 = new Point3f();
        this.depth1 = new Vector3f();
        this.needToFill = new boolean[16];
        this.T1 = new Vector3f();
        this.T2 = new Vector3f();
        this.g3d = jmolRendererInterface;
    }

    static void getHermiteList(int n, Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, Tuple3f tuple3f4, Tuple3f tuple3f5, Tuple3f[] tuple3fArray, int n2, int n3) {
        int n4 = n3 + 1;
        float f = n3 - 1;
        float f2 = tuple3f2.x;
        float f3 = tuple3f2.y;
        float f4 = tuple3f2.z;
        float f5 = tuple3f3.x;
        float f6 = tuple3f3.y;
        float f7 = tuple3f3.z;
        float f8 = (f5 - tuple3f.x) * (float)n / 8.0f;
        float f9 = (f6 - tuple3f.y) * (float)n / 8.0f;
        float f10 = (f7 - tuple3f.z) * (float)n / 8.0f;
        float f11 = (tuple3f4.x - f2) * (float)n / 8.0f;
        float f12 = (tuple3f4.y - f3) * (float)n / 8.0f;
        float f13 = (tuple3f4.z - f4) * (float)n / 8.0f;
        float f14 = (tuple3f5.x - f5) * (float)n / 8.0f;
        float f15 = (tuple3f5.y - f6) * (float)n / 8.0f;
        float f16 = (tuple3f5.z - f7) * (float)n / 8.0f;
        tuple3fArray[n2] = tuple3f2;
        for (int i = 0; i < n4; ++i) {
            double d = (float)i / f;
            if (i == n4 - 1) {
                f2 = f5;
                f3 = f6;
                f4 = f7;
                f5 = tuple3f4.x;
                f6 = tuple3f4.y;
                f7 = tuple3f4.z;
                f8 = f11;
                f9 = f12;
                f10 = f13;
                f11 = f14;
                f12 = f15;
                f13 = f16;
                d -= 1.0;
            }
            double d2 = d * d;
            double d3 = d2 * d;
            double d4 = 2.0 * d3 - 3.0 * d2 + 1.0;
            double d5 = -2.0 * d3 + 3.0 * d2;
            double d6 = d3 - 2.0 * d2 + d;
            double d7 = d3 - d2;
            float f17 = (float)(d4 * (double)f2 + d5 * (double)f5 + d6 * (double)f8 + d7 * (double)f11);
            float f18 = (float)(d4 * (double)f3 + d5 * (double)f6 + d6 * (double)f9 + d7 * (double)f12);
            float f19 = (float)(d4 * (double)f4 + d5 * (double)f7 + d6 * (double)f10 + d7 * (double)f13);
            tuple3fArray[n2 + i] = tuple3fArray instanceof Point3f[] ? new Point3f(f17, f18, f19) : new Vector3f(f17, f18, f19);
        }
    }
}

