/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.api.JmolViewer;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BinaryDocument;
import org.jmol.util.CompoundDocument;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;
import org.jmol.viewer.DataManager;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileManager {
    protected Viewer viewer;
    String nameAsGiven = "zapped";
    String fullPathName;
    String fileName;
    private URL appletDocumentBase = null;
    private URL appletCodeBase = null;
    private String appletProxy;
    private static final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", "file:"};
    private static final String[] urlPrefixPairs = new String[]{"http:", "http://", "www.", "http://www.", "https:", "https://", "ftp:", "ftp://", "file:", "file:///"};
    private static String[] scriptFilePrefixes = new String[]{"/*file*/\"", "FILE0=\"", "FILE1=\""};

    FileManager(Viewer viewer) {
        this.viewer = viewer;
        this.clear();
    }

    void clear() {
        this.fileName = this.nameAsGiven = this.viewer.getZapName();
        this.fullPathName = this.nameAsGiven;
    }

    private void setLoadState(Map<String, Object> map) {
        if (this.viewer.getPreserveState()) {
            map.put("loadState", this.viewer.getLoadState());
        }
    }

    void setFileInfo(String[] stringArray) {
        this.fullPathName = stringArray[0];
        this.fileName = stringArray[1];
        this.nameAsGiven = stringArray[2];
    }

    String[] getFileInfo() {
        return new String[]{this.fullPathName, this.fileName, this.nameAsGiven};
    }

    String getFullPathName() {
        return this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
    }

    String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getAppletDocumentBase() {
        return this.appletDocumentBase == null ? "" : this.appletDocumentBase.toString();
    }

    void setAppletContext(URL uRL, URL uRL2, String string) {
        this.appletDocumentBase = uRL;
        this.appletCodeBase = uRL2;
        this.appletProxy = string;
        Logger.info("appletDocumentBase=" + this.appletDocumentBase + "\nappletCodeBase=" + this.appletCodeBase);
    }

    void setAppletProxy(String string) {
        this.appletProxy = string == null || string.length() == 0 ? null : string;
    }

    String getState(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringBuffer != null) {
            stringBuffer.append("  _setFileState;\n");
            stringBuffer2.append("function _setFileState() {\n\n");
        }
        this.viewer.appendLoadStates(stringBuffer2);
        if (stringBuffer2.indexOf("append") < 0 && this.viewer.getModelSetFileName().equals("zapped")) {
            stringBuffer2.append("  zap;\n");
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\n}\n\n");
        }
        return stringBuffer2.toString();
    }

    private static BufferedReader getBufferedReaderForString(String string) {
        return new BufferedReader(new StringReader(string));
    }

    Object createAtomSetCollectionFromFile(String string, Map<String, Object> map, boolean bl) {
        int n;
        if (map.get("atomDataOnly") == null) {
            this.setLoadState(map);
        }
        if (string.indexOf(61) == 0 || string.indexOf(36) == 0) {
            string = (String)this.viewer.setLoadFormat(string, string.charAt(0), true);
        }
        String string2 = (n = string.indexOf("::")) >= 0 ? string.substring(n + 2) : string;
        String string3 = n >= 0 ? string.substring(0, n) : null;
        Logger.info("\nFileManager.getAtomSetCollectionFromFile(" + string2 + ")" + (string.equals(string2) ? "" : " //" + string));
        String[] stringArray = this.classifyName(string2, true);
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        map.put("fullPathName", (string3 == null ? "" : string3 + "::") + string4.replace('\\', '/'));
        if (this.viewer.getMessageStyleChime() && this.viewer.getDebugScript()) {
            this.viewer.scriptStatus("Requesting " + string4);
        }
        FileReader fileReader = new FileReader(string5, string4, string2, string3, null, map, bl);
        fileReader.run();
        return fileReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromFiles(String[] stringArray, Map<String, Object> map, boolean bl) {
        this.setLoadState(map);
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        String[] stringArray4 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("::");
            String string = n >= 0 ? stringArray[i].substring(n + 2) : stringArray[i];
            String string2 = n >= 0 ? stringArray[i].substring(0, n) : null;
            String[] stringArray5 = this.classifyName(string, true);
            if (stringArray5.length == 1) {
                return stringArray5[0];
            }
            stringArray2[i] = stringArray5[0];
            stringArray[i] = stringArray5[0].replace('\\', '/');
            stringArray4[i] = string2;
            stringArray3[i] = string;
        }
        map.put("fullPathNames", stringArray2);
        map.put("fileTypes", stringArray4);
        FilesReader filesReader = new FilesReader(stringArray2, stringArray3, stringArray4, null, map, bl);
        filesReader.run();
        return filesReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromString(String string, StringBuffer stringBuffer, Map<String, Object> map, boolean bl, boolean bl2) {
        if (!bl2) {
            DataManager.getInlineData(stringBuffer, string, bl, this.viewer.getDefaultLoadFilter());
        }
        this.setLoadState(map);
        Logger.info("FileManager.getAtomSetCollectionFromString()");
        FileReader fileReader = new FileReader("string", "string", "string", null, FileManager.getBufferedReaderForString(string), map, bl);
        fileReader.run();
        if (!bl && !(fileReader.atomSetCollection instanceof String)) {
            this.viewer.zap(false, true, false);
            this.fileName = string == "1 0 C 0 0" ? "Jmol Model Kit" : "string";
            this.fullPathName = this.fileName;
        }
        return fileReader.atomSetCollection;
    }

    Object createAtomSeCollectionFromStrings(String[] stringArray, StringBuffer stringBuffer, Map<String, Object> map, boolean bl) {
        DataReader[] dataReaderArray;
        String[] stringArray2;
        if (!map.containsKey("isData")) {
            stringArray2 = "\"" + this.viewer.getDataSeparator() + "\"";
            dataReaderArray = "\"" + (bl ? "append" : "model") + " inline\"";
            StringBuffer stringBuffer2 = new StringBuffer("set dataSeparator \"~~~next file~~~\";\ndata ");
            stringBuffer2.append((String)dataReaderArray);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer2.append("~~~next file~~~");
                }
                stringBuffer2.append(stringArray[i]);
            }
            stringBuffer2.append("end ").append((String)dataReaderArray).append(";set dataSeparator ").append((String)stringArray2);
            stringBuffer.append(stringBuffer2);
        }
        this.setLoadState(map);
        Logger.info("FileManager.getAtomSetCollectionFromStrings(string[])");
        stringArray2 = new String[stringArray.length];
        dataReaderArray = new StringDataReader[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "string[" + i + "]";
            dataReaderArray[i] = new StringDataReader(stringArray[i]);
        }
        FilesReader filesReader = new FilesReader(stringArray2, stringArray2, null, dataReaderArray, map, bl);
        filesReader.run();
        return filesReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromDOM(Object object, Map<String, Object> map) {
        DOMReader dOMReader = new DOMReader(object, map);
        dOMReader.run();
        return dOMReader.atomSetCollection;
    }

    Object createAtomSetCollectionFromReader(String string, String string2, Reader reader, Map<String, Object> map) {
        FileReader fileReader = new FileReader(string2, string, string2, null, new BufferedReader(reader), map, false);
        fileReader.run();
        return fileReader.atomSetCollection;
    }

    BufferedInputStream getBufferedInputStream(String string) {
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, new String[2], true, true);
        return object instanceof BufferedInputStream ? (BufferedInputStream)object : null;
    }

    Object getInputStreamOrErrorMessageFromName(String string, boolean bl, boolean bl2) {
        return FileManager.getInputStreamOrPost(string, bl, null, bl2, this.appletDocumentBase, this.appletProxy);
    }

    private static Object getInputStreamOrPost(String string, boolean bl, byte[] byArray, boolean bl2, URL uRL, String string2) {
        String string3 = null;
        int n = urlPrefixes.length;
        while (--n >= 0 && !string.startsWith(urlPrefixes[n])) {
        }
        boolean bl3 = n >= 0;
        String string4 = null;
        if (bl3 && (n = string.indexOf("?POST?")) >= 0) {
            string4 = string.substring(n + 6);
            string = string.substring(0, n);
        }
        boolean bl4 = uRL != null;
        InputStream inputStream = null;
        try {
            if (bl4 || bl3) {
                if (bl4 && bl3 && string2 != null) {
                    string = string2 + "?url=" + URLEncoder.encode(string, "utf-8");
                }
                URL uRL2 = bl4 ? new URL(uRL, string) : new URL(string);
                string = uRL2.toString();
                if (bl && !bl2) {
                    Logger.info("FileManager opening " + uRL2.toString());
                }
                URLConnection uRLConnection = uRL2.openConnection();
                if (byArray != null && !bl2) {
                    uRLConnection.setRequestProperty("Content-Type", "application/octet-stream");
                    uRLConnection.setDoOutput(true);
                    uRLConnection.getOutputStream().write(byArray);
                } else if (string4 != null && !bl2) {
                    uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    uRLConnection.setDoOutput(true);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
                    outputStreamWriter.write(string4);
                    outputStreamWriter.flush();
                }
                inputStream = uRLConnection.getInputStream();
            } else {
                if (bl) {
                    Logger.info("FileManager opening " + string);
                }
                File file = new File(string);
                inputStream = new FileInputStream(file);
            }
            if (bl2) {
                inputStream.close();
                inputStream = null;
            }
            return inputStream;
        }
        catch (Exception exception) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string3 = "" + exception;
            return string3;
        }
    }

    String[] getFullPathNameOrError(String string) {
        String[] stringArray = this.classifyName(string, true);
        if (stringArray == null || stringArray[0] == null || stringArray.length < 2) {
            return new String[]{null, "cannot read file name: " + string};
        }
        String string2 = stringArray[0];
        String string3 = stringArray[0].replace('\\', '/');
        if (string2.indexOf("|") >= 0) {
            string2 = TextFormat.split(string2, "|")[0];
        }
        Object object = this.getInputStreamOrErrorMessageFromName(string2, false, true);
        return new String[]{string3, object instanceof String ? (String)object : null};
    }

    Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray, boolean bl, boolean bl2) {
        String[] stringArray2 = this.classifyName(string, true);
        if (stringArray2 == null) {
            return "cannot read file name: " + string;
        }
        if (stringArray != null) {
            stringArray[0] = stringArray2[0].replace('\\', '/');
        }
        return this.getUnzippedBufferedReaderOrErrorMessageFromName(stringArray2[0], false, bl, false, bl2);
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        String[] stringArray;
        String[] stringArray2 = null;
        String[] stringArray3 = stringArray = bl4 ? this.viewer.getModelAdapter().specialLoad(string, "filesNeeded?") : null;
        if (stringArray != null) {
            if (bl3) {
                return stringArray;
            }
            if (stringArray[2] != null) {
                CharSequence charSequence;
                String string2 = stringArray[1];
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                if (stringArray.length == 3) {
                    charSequence = this.getObjectAsSections(stringArray[2], string2, hashtable);
                    hashtable.put("OUTPUT", (String)charSequence);
                    stringArray = this.viewer.getModelAdapter().specialLoad(string, (String)hashtable.get(charSequence));
                    if (stringArray.length == 3) {
                        charSequence = this.getObjectAsSections(stringArray[2], string2, hashtable);
                        hashtable.put("OUTPUT", (String)charSequence);
                        stringArray = this.viewer.getModelAdapter().specialLoad(stringArray[1], (String)hashtable.get(charSequence));
                    }
                }
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append((String)hashtable.get(hashtable.get("OUTPUT")));
                for (int i = 2; i < stringArray.length; ++i) {
                    string = stringArray[i];
                    string = this.getObjectAsSections(string, string2, hashtable);
                    Logger.info("reading " + string);
                    String string3 = (String)hashtable.get(string);
                    ((StringBuffer)charSequence).append(string3);
                }
                return FileManager.getBufferedReaderForString(((StringBuffer)charSequence).toString());
            }
        }
        if (string.indexOf("|") >= 0) {
            stringArray2 = TextFormat.split(string, "|");
            string = stringArray2[0];
        }
        if ((object = this.getInputStreamOrErrorMessageFromName(string, true, false)) instanceof String) {
            return object;
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            if (CompoundDocument.isCompoundDocument(bufferedInputStream)) {
                CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                return FileManager.getBufferedReaderForString(compoundDocument.getAllData("Molecule", "Input").toString());
            }
            if (ZipUtil.isGzip(bufferedInputStream)) {
                while (ZipUtil.isGzip(bufferedInputStream = new BufferedInputStream(new GZIPInputStream(bufferedInputStream)))) {
                }
            } else if (ZipUtil.isZipFile(bufferedInputStream)) {
                if (bl) {
                    return new ZipInputStream(bufferedInputStream);
                }
                if (bl2) {
                    return ZipUtil.getZipFileContents(bufferedInputStream, stringArray2, 1, true);
                }
                String string4 = (String)ZipUtil.getZipFileContents(bufferedInputStream, stringArray2, 1, false);
                bufferedInputStream.close();
                return FileManager.getBufferedReaderForString(string4);
            }
            if (bl2) {
                return bufferedInputStream;
            }
            return new BufferedReader(new InputStreamReader(bufferedInputStream));
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    String[] getZipDirectory(String string, boolean bl) {
        return ZipUtil.getZipDirectoryAndClose((InputStream)this.getInputStreamOrErrorMessageFromName(string, false, false), bl);
    }

    private String getObjectAsSections(String string, String string2, Map<String, String> map) {
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        boolean bl = false;
        String string3 = string.replace('\\', '/');
        if (string.indexOf(":asBinaryString") >= 0) {
            bl = true;
            string = string.substring(0, string.indexOf(":asBinaryString"));
        }
        StringBuffer stringBuffer = null;
        if (map.containsKey(string3)) {
            return string3;
        }
        if (string.indexOf("#JMOL_MODEL ") >= 0) {
            map.put(string3, string3 + "\n");
            return string3;
        }
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.split(string, "|");
            string = stringArray[0];
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            Object object = this.getInputStreamOrErrorMessageFromName(string, false, false);
            if (object instanceof String) {
                map.put(string3, (String)object + "\n");
                return string3;
            }
            bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            if (CompoundDocument.isCompoundDocument(bufferedInputStream)) {
                CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                compoundDocument.getAllData(string.replace('\\', '/'), "Molecule", map);
            } else if (ZipUtil.isZipFile(bufferedInputStream)) {
                ZipUtil.getAllData(bufferedInputStream, stringArray, string.replace('\\', '/'), "Molecule", map);
            } else if (bl) {
                BinaryDocument binaryDocument = new BinaryDocument();
                binaryDocument.setStream(bufferedInputStream, false);
                stringBuffer = new StringBuffer();
                if (string2 != null) {
                    stringBuffer.append("BEGIN Directory Entry " + string3 + "\n");
                }
                try {
                    while (true) {
                        stringBuffer.append(Integer.toHexString(binaryDocument.readByte() & 0xFF)).append(' ');
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append('\n');
                    if (string2 != null) {
                        stringBuffer.append("\nEND Directory Entry " + string3 + "\n");
                    }
                    map.put(string3, stringBuffer.toString());
                }
            } else {
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ZipUtil.isGzip(bufferedInputStream) ? new GZIPInputStream(bufferedInputStream) : bufferedInputStream));
                stringBuffer = new StringBuffer();
                if (string2 != null) {
                    stringBuffer.append("BEGIN Directory Entry " + string3 + "\n");
                }
                while ((string4 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string4);
                    stringBuffer.append('\n');
                }
                bufferedReader.close();
                if (string2 != null) {
                    stringBuffer.append("\nEND Directory Entry " + string3 + "\n");
                }
                map.put(string3, stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            map.put(string3, exception.getMessage());
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!map.containsKey(string3)) {
            map.put(string3, "FILE NOT FOUND: " + string3 + "\n");
        }
        return string3;
    }

    Object getFileAsBytes(String string, OutputStream outputStream) {
        Object object;
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.split(string, "|");
            string = stringArray[0];
        }
        if ((object = this.getInputStreamOrErrorMessageFromName(string, false, false)) instanceof String) {
            return "Error:" + object;
        }
        try {
            BufferedInputStream bufferedInputStream;
            BufferedInputStream bufferedInputStream2 = bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            if (outputStream != null) {
                return FileManager.getStreamAsBytes(bufferedInputStream, outputStream);
            }
            Object object2 = ZipUtil.isZipFile(bufferedInputStream2) && stringArray != null && 1 < stringArray.length ? (Object)ZipUtil.getZipFileContentsAsBytes(bufferedInputStream2, stringArray, 1) : FileManager.getStreamAsBytes(bufferedInputStream, null);
            ((InputStream)bufferedInputStream2).close();
            return object2;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    private static Object getStreamAsBytes(BufferedInputStream bufferedInputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = outputStream == null ? new byte[4096] : null;
        int n = 0;
        int n2 = 0;
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            n2 += n;
            if (outputStream == null) {
                if (n2 >= byArray2.length) {
                    byArray2 = ArrayUtil.ensureLength(byArray2, n2 * 2);
                }
                System.arraycopy(byArray, 0, byArray2, n2 - n, n);
                continue;
            }
            outputStream.write(byArray, 0, n);
        }
        if (outputStream == null) {
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
            return byArray;
        }
        return n2 + " bytes";
    }

    boolean getFileDataOrErrorAsString(String[] stringArray, int n, boolean bl) {
        stringArray[1] = "";
        String string = stringArray[0];
        if (string == null) {
            return false;
        }
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, stringArray, false, bl);
        if (object instanceof String) {
            stringArray[1] = (String)object;
            return false;
        }
        try {
            BufferedReader bufferedReader = (BufferedReader)object;
            StringBuffer stringBuffer = new StringBuffer(8192);
            if (n == Integer.MAX_VALUE) {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2).append('\n');
                }
            } else {
                String string3;
                int n2;
                for (int i = 0; i < n && (string3 = bufferedReader.readLine()) != null; i += n2 + 1) {
                    n2 = string3.length();
                    if (n - i < n2 + 1) {
                        string3 = string3.substring(0, n - i - 1);
                    }
                    stringBuffer.append(string3).append('\n');
                }
            }
            bufferedReader.close();
            stringArray[1] = stringBuffer.toString();
            return true;
        }
        catch (Exception exception) {
            stringArray[1] = exception.getMessage();
            return false;
        }
    }

    Image getFileAsImage(String string, String[] stringArray) {
        Object object;
        if (string == null) {
            stringArray[0] = "";
            return null;
        }
        String[] stringArray2 = this.classifyName(string, true);
        if (stringArray2 == null) {
            stringArray[0] = "cannot read file name: " + string;
            return null;
        }
        Image image = null;
        String string2 = stringArray2[0].replace('\\', '/');
        if (string2.indexOf("|") > 0) {
            object = this.getFileAsBytes(string2, null);
            if (!(object instanceof byte[])) {
                stringArray[0] = "" + object;
                return null;
            }
            image = Toolkit.getDefaultToolkit().createImage((byte[])object);
        } else if (FileManager.urlTypeIndex(string2) >= 0) {
            try {
                image = Toolkit.getDefaultToolkit().createImage(new URL(string2));
            }
            catch (Exception exception) {
                stringArray[0] = "bad URL: " + string2;
                return null;
            }
        } else {
            image = Toolkit.getDefaultToolkit().createImage(string2);
        }
        try {
            object = new MediaTracker(this.viewer.getDisplay());
            ((MediaTracker)object).addImage(image, 0);
            ((MediaTracker)object).waitForID(0);
        }
        catch (Exception exception) {
            stringArray[0] = exception.getMessage() + " opening " + string2;
            return null;
        }
        if (image.getWidth(null) < 1) {
            stringArray[0] = "invalid or missing image " + string2;
            return null;
        }
        stringArray[0] = string2;
        return image;
    }

    private static int urlTypeIndex(String string) {
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!string.startsWith(urlPrefixes[i])) continue;
            return i;
        }
        return -1;
    }

    private String[] classifyName(String string, boolean bl) {
        String string2;
        int n;
        if (string == null) {
            return new String[]{null};
        }
        if (string.startsWith("?") && (string = this.viewer.dialogAsk("load", string.substring(1))) == null) {
            return new String[]{bl ? "#CANCELED#" : null};
        }
        File file = null;
        URL uRL = null;
        String[] stringArray = null;
        if (string.indexOf("=") == 0 || string.indexOf(36) == 0) {
            string = (String)this.viewer.setLoadFormat(string, string.charAt(0), false);
        }
        if (string.indexOf(":") < 0 && string.indexOf("/") != 0) {
            string = FileManager.addDirectory(this.viewer.getDefaultDirectory(), string);
        }
        if (this.appletDocumentBase != null) {
            try {
                if (string.indexOf(":\\") == 1 || string.indexOf(":/") == 1) {
                    string = "file:/" + string;
                }
                uRL = new URL(this.appletDocumentBase, string);
            }
            catch (MalformedURLException malformedURLException) {
                return new String[]{bl ? malformedURLException.getMessage() : null};
            }
        } else if (FileManager.urlTypeIndex(string) >= 0) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return new String[]{bl ? malformedURLException.getMessage() : null};
            }
        } else {
            file = new File(string);
            stringArray = new String[]{file.getAbsolutePath(), file.getName(), "file:/" + file.getAbsolutePath().replace('\\', '/')};
        }
        if (uRL != null) {
            stringArray = new String[3];
            stringArray[0] = stringArray[2] = uRL.toString();
            stringArray[1] = stringArray[0].substring(stringArray[0].lastIndexOf(47) + 1);
        }
        if (bl && (file != null || FileManager.urlTypeIndex(stringArray[0]) == 3) && (n = (string2 = file == null ? TextFormat.trim(stringArray[0].substring(5), "/") : stringArray[0]).length() - stringArray[1].length() - 1) > 0) {
            string2 = string2.substring(0, n);
            FileManager.setLocalPath(this.viewer, string2, true);
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String addDirectory(String string, String string2) {
        String string3;
        if (string.length() == 0) {
            return string2;
        }
        int n = string2.length() > 0 ? (int)string2.charAt(0) : 32;
        String string4 = string.toLowerCase();
        if ((string4.endsWith(".zip") || string4.endsWith(".tar")) && n != 124 && n != 47) {
            string = string + "|";
        }
        StringBuilder stringBuilder = new StringBuilder().append(string);
        if (n != 47 && n != 47) {
            char c = string.charAt(string.length() - 1);
            n = c;
            if (c != '|' && n != 47) {
                string3 = "/";
                return stringBuilder.append(string3).append(string2).toString();
            }
        }
        string3 = "";
        return stringBuilder.append(string3).append(string2).toString();
    }

    String getDefaultDirectory(String string) {
        String[] stringArray = this.classifyName(string, true);
        if (stringArray == null) {
            return "";
        }
        string = FileManager.fixPath(stringArray[0]);
        return stringArray == null ? "" : string.substring(0, string.lastIndexOf("/"));
    }

    private static String fixPath(String string) {
        string = string.replace('\\', '/');
        int n = (string = TextFormat.simpleReplace(string, "/./", "/")).lastIndexOf("//") + 1;
        if (n < 1) {
            n = string.indexOf(":/") + 1;
        }
        if (n < 1) {
            n = string.indexOf("/");
        }
        String string2 = string.substring(0, n);
        string = string.substring(n);
        while ((n = string.lastIndexOf("/../")) >= 0) {
            int n2 = string.substring(0, n).lastIndexOf("/");
            if (n2 < 0) {
                return TextFormat.simpleReplace(string2 + string, "/../", "/");
            }
            string = string.substring(0, n2) + string.substring(n + 3);
        }
        if (string.length() == 0) {
            string = "/";
        }
        return string2 + string;
    }

    public String getFilePath(String string, boolean bl, boolean bl2) {
        String[] stringArray = this.classifyName(string, false);
        return stringArray == null ? "" : (bl2 ? stringArray[1] : (bl ? stringArray[2] : stringArray[0].replace('\\', '/')));
    }

    public static File getLocalDirectory(JmolViewer jmolViewer, boolean bl) {
        File file;
        String string = (String)jmolViewer.getParameter(bl ? "currentLocalPath" : "defaultDirectoryLocal");
        if (string.length() == 0 && bl) {
            string = (String)jmolViewer.getParameter("defaultDirectoryLocal");
        }
        if (string.length() == 0) {
            return jmolViewer.isApplet() ? null : new File(System.getProperty("user.dir"));
        }
        if (jmolViewer.isApplet() && string.indexOf("file:/") == 0) {
            string = FileManager.getLocalPathForWritingFile(jmolViewer, string);
        }
        return (file = new File(string)).isDirectory() ? file : file.getParentFile();
    }

    public static void setLocalPath(JmolViewer jmolViewer, String string, boolean bl) {
        while (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        jmolViewer.setStringProperty("currentLocalPath", string);
        if (!bl) {
            jmolViewer.setStringProperty("defaultDirectoryLocal", string);
        }
    }

    public static String getLocalPathForWritingFile(JmolViewer jmolViewer, String string) {
        if (string.indexOf("file:/") == 0) {
            return string.substring(6);
        }
        if (string.indexOf("/") == 0 || string.indexOf(":") >= 0) {
            return string;
        }
        File file = FileManager.getLocalDirectory(jmolViewer, false);
        return file == null ? string : FileManager.fixPath(file.toString() + "/" + string);
    }

    public static String setScriptFileReferences(String string, String string2, String string3, String string4) {
        if (string2 != null) {
            string = FileManager.setScriptFileReferences(string, string2, true);
        }
        if (string3 != null) {
            string = FileManager.setScriptFileReferences(string, string3, false);
        }
        string = TextFormat.simpleReplace(string, "\u0001\"", "\"");
        if (string4 != null) {
            while (string4.endsWith("/")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            for (int i = 0; i < scriptFilePrefixes.length; ++i) {
                String string5 = scriptFilePrefixes[i];
                string = TextFormat.simpleReplace(string, string5 + ".", string5 + string4);
            }
        }
        return string;
    }

    private static String setScriptFileReferences(String string, String string2, boolean bl) {
        if (string2 == null) {
            return string;
        }
        boolean bl2 = string2.length() == 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        FileManager.getFileReferences(string, arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            String string4 = string3;
            int n2 = FileManager.urlTypeIndex(string4);
            if (bl == (n2 < 0 || n2 == 3)) {
                int n3;
                int n4 = n3 = bl2 ? -1 : string4.indexOf("/" + string2 + "/");
                if (n3 >= 0) {
                    string4 = string4.substring(n3 + 1);
                } else {
                    n3 = string4.lastIndexOf("/");
                    if (n3 < 0 && !bl2) {
                        string4 = "/" + string4;
                    }
                    if (n3 < 0 || bl2) {
                        ++n3;
                    }
                    string4 = string2 + string4.substring(n3);
                }
            }
            Logger.info("FileManager substituting " + string3 + " --> " + string4);
            arrayList2.add("\"" + string3 + "\"");
            arrayList3.add("\u0001\"" + string4 + "\"");
        }
        return TextFormat.replaceStrings(string, arrayList2, arrayList3);
    }

    public static void getFileReferences(String string, List<String> list) {
        for (int i = 0; i < scriptFilePrefixes.length; ++i) {
            String string2 = scriptFilePrefixes[i];
            int n = -1;
            while ((n = string.indexOf(string2, n + 1)) >= 0) {
                String string3 = Parser.getNextQuotedString(string, n);
                if (string3.indexOf("::") >= 0) {
                    string3 = TextFormat.split(string3, "::")[1];
                }
                list.add(string3);
            }
        }
    }

    String createZipSet(String string, String string2, boolean bl) {
        String string3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        FileManager.getFileReferences(string2, arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        int n = arrayList2.size();
        string = string.replace('\\', '/');
        String string4 = string.substring(string.lastIndexOf("/") + 1);
        if (string4.indexOf(".") >= 0) {
            string4 = string4.substring(0, string4.indexOf("."));
        }
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            string3 = (String)arrayList2.get(i);
            int n2 = FileManager.urlTypeIndex(string3);
            boolean bl3 = bl2 = n2 < 0 || n2 == 3;
            if (bl2 || bl) {
                arrayList.add(string3);
                int n3 = Math.max(string3.lastIndexOf("|"), string3.lastIndexOf("/"));
                String string5 = "$SCRIPT_PATH$/" + string3.substring(n3 + 1);
                if (bl2 && string3.indexOf("|") < 0) {
                    arrayList.add(null);
                } else {
                    Object object = this.getFileAsBytes(string3, null);
                    if (!(object instanceof byte[])) {
                        return (String)object;
                    }
                    arrayList.add(object);
                }
                string3 = string5;
            }
            arrayList3.add(string3);
        }
        String string6 = string4 + ".spt";
        arrayList.add("JmolManifest.txt");
        string3 = "# Jmol Manifest Zip Format 1.0\n# Created " + DateFormat.getDateInstance().format(new Date()) + "\n" + "# JmolVersion " + Viewer.getJmolVersion() + "\n" + string6;
        arrayList.add(string3.getBytes());
        string2 = TextFormat.replaceQuotedStrings(string2, arrayList2, arrayList3);
        arrayList.add(string6);
        arrayList.add(string2.getBytes());
        Object object = this.viewer.getImageAs("PNG", -1, -1, -1, null, null, JmolConstants.embedScript(string2));
        if (object instanceof byte[]) {
            arrayList.add(string4 + ".png");
            arrayList.add(object);
        }
        return FileManager.writeZipFile(string, arrayList, false, "OK JMOL");
    }

    private static String writeZipFile(String string, List<Object> list, boolean bl, String string2) {
        byte[] byArray = new byte[1024];
        long l = 0L;
        long l2 = 0L;
        Logger.info("creating zip file " + string + "...");
        String string3 = null;
        String string4 = "";
        try {
            String string5;
            ByteArrayOutputStream byteArrayOutputStream = string.startsWith("http://") ? new ByteArrayOutputStream() : null;
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream == null ? new FileOutputStream(string) : byteArrayOutputStream);
            for (int i = 0; i < list.size(); i += 2) {
                string5 = (String)list.get(i);
                if (string5.indexOf("file:/") == 0) {
                    string5 = string5.substring(6);
                }
                byte[] byArray2 = (byte[])list.get(i + 1);
                String string6 = string5;
                if (!bl || string5.indexOf("|") >= 0) {
                    int n = Math.max(string5.lastIndexOf("|"), string5.lastIndexOf("/"));
                    string6 = string6.substring(n + 1);
                }
                Logger.info("...adding " + string5);
                String string7 = ";" + string6 + ";";
                if (string4.indexOf(string7) >= 0) {
                    Logger.info("duplicate entry");
                    continue;
                }
                string4 = string4 + string7;
                zipOutputStream.putNextEntry(new ZipEntry(string6));
                if (byArray2 == null) {
                    int n;
                    FileInputStream fileInputStream = new FileInputStream(string5);
                    while ((n = fileInputStream.read(byArray)) > 0) {
                        zipOutputStream.write(byArray, 0, n);
                        l += (long)n;
                    }
                    fileInputStream.close();
                } else {
                    zipOutputStream.write(byArray2, 0, byArray2.length);
                    l += (long)byArray2.length;
                }
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            Logger.info(l + " bytes prior to compression");
            if (byteArrayOutputStream != null) {
                string3 = string;
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                l2 = byArray3.length;
                string5 = FileManager.postByteArray(string, byArray3);
                if (string5 != null) {
                    return string5;
                }
            } else {
                File file = new File(string);
                string3 = file.getAbsolutePath().replace('\\', '/');
                l2 = file.length();
            }
        }
        catch (IOException iOException) {
            Logger.info(iOException.getMessage());
            return iOException.getMessage();
        }
        return string2 + " " + l2 + " " + string3;
    }

    private static String postByteArray(String string, byte[] byArray) {
        return null;
    }

    public static String fixFileNameVariables(String string, String string2) {
        String string3 = TextFormat.simpleReplace(string, "%FILE", string2);
        if (string3.indexOf("%LC") < 0) {
            return string3;
        }
        string2 = string2.toLowerCase();
        string3 = TextFormat.simpleReplace(string3, "%LCFILE", string2);
        if (string2.length() == 4) {
            string3 = TextFormat.simpleReplace(string3, "%LC13", string2.substring(1, 3));
        }
        return string3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DOMReader {
        private Object aDOMNode;
        Object atomSetCollection;
        Map<String, Object> htParams;

        DOMReader(Object object, Map<String, Object> map) {
            this.aDOMNode = object;
            this.htParams = map;
        }

        void run() {
            this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromDOM(this.aDOMNode, this.htParams);
            if (this.atomSetCollection instanceof String) {
                return;
            }
            FileManager.this.viewer.zap(false, true, false);
            FileManager.this.nameAsGiven = "JSNode";
            FileManager.this.fileName = "JSNode";
            FileManager.this.fullPathName = "JSNode";
        }
    }

    abstract class DataReader
    extends BufferedReader {
        DataReader(Reader reader) {
            super(reader);
        }

        BufferedReader getBufferedReader() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileReader {
        private String fileNameIn;
        private String fullPathNameIn;
        private String nameAsGivenIn;
        private String fileTypeIn;
        Object atomSetCollection;
        private BufferedReader reader;
        private Map<String, Object> htParams;
        private boolean isAppend;

        FileReader(String string, String string2, String string3, String string4, BufferedReader bufferedReader, Map<String, Object> map, boolean bl) {
            this.fileNameIn = string;
            this.fullPathNameIn = string2;
            this.nameAsGivenIn = string3;
            this.fileTypeIn = string4;
            this.reader = bufferedReader;
            this.htParams = map;
            this.isAppend = bl;
        }

        void run() {
            if (!this.isAppend && FileManager.this.viewer.displayLoadErrors) {
                FileManager.this.viewer.zap(false, true, false);
            }
            String string = null;
            Object object = null;
            if (this.reader == null && ((object = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(this.fullPathNameIn, true, false, false, true)) == null || object instanceof String)) {
                String string2 = string = object == null ? "error opening:" + this.nameAsGivenIn : (String)object;
                if (!string.startsWith("NOTE:")) {
                    Logger.error("file ERROR: " + this.fullPathNameIn + "\n" + string);
                }
                this.atomSetCollection = string;
                return;
            }
            if (this.reader == null) {
                if (object instanceof BufferedReader) {
                    this.reader = (BufferedReader)object;
                } else if (object instanceof ZipInputStream) {
                    String string3 = this.fullPathNameIn;
                    String[] stringArray = null;
                    if (string3.indexOf("|") >= 0) {
                        stringArray = TextFormat.split(string3, "|");
                        string3 = stringArray[0];
                    }
                    if (stringArray != null) {
                        this.htParams.put("subFileList", stringArray);
                    }
                    ZipInputStream zipInputStream = (ZipInputStream)object;
                    String[] stringArray2 = FileManager.this.getZipDirectory(string3, true);
                    this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionOrBufferedReaderFromZip(zipInputStream, string3, stringArray2, this.htParams, false, false);
                    try {
                        zipInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.reader != null) {
                this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionReader(this.fullPathNameIn, this.fileTypeIn, this.reader, this.htParams);
                if (!(this.atomSetCollection instanceof String)) {
                    this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollection(this.atomSetCollection);
                }
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.atomSetCollection instanceof String) {
                return;
            }
            if (!this.isAppend && !FileManager.this.viewer.displayLoadErrors) {
                FileManager.this.viewer.zap(false, true, false);
            }
            FileManager.this.fullPathName = this.fullPathNameIn;
            FileManager.this.nameAsGiven = this.nameAsGivenIn;
            FileManager.this.fileName = this.fileNameIn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilesReader
    implements JmolFilesReaderInterface {
        private String[] fullPathNamesIn;
        private String[] namesAsGivenIn;
        private String[] fileTypesIn;
        Object atomSetCollection;
        private DataReader[] stringReaders;
        private Map<String, Object> htParams;
        private boolean isAppend;

        FilesReader(String[] stringArray, String[] stringArray2, String[] stringArray3, DataReader[] dataReaderArray, Map<String, Object> map, boolean bl) {
            this.fullPathNamesIn = stringArray;
            this.namesAsGivenIn = stringArray2;
            this.fileTypesIn = stringArray3;
            this.stringReaders = dataReaderArray;
            this.htParams = map;
            this.isAppend = bl;
        }

        void run() {
            if (!this.isAppend && FileManager.this.viewer.displayLoadErrors) {
                FileManager.this.viewer.zap(false, true, false);
            }
            boolean bl = !FileManager.this.viewer.displayLoadErrors;
            this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionReaders(this, this.fullPathNamesIn, this.fileTypesIn, this.htParams, bl);
            this.stringReaders = null;
            if (bl && !(this.atomSetCollection instanceof String)) {
                this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromSet(this.atomSetCollection, null, this.htParams);
            }
            if (this.atomSetCollection instanceof String) {
                Logger.error("file ERROR: " + this.atomSetCollection);
                return;
            }
            if (!this.isAppend && !FileManager.this.viewer.displayLoadErrors) {
                FileManager.this.viewer.zap(false, true, false);
            }
            FileManager.this.nameAsGiven = this.stringReaders == null ? "file[]" : "String[]";
            FileManager.this.fileName = FileManager.this.nameAsGiven;
            FileManager.this.fullPathName = FileManager.this.nameAsGiven;
        }

        @Override
        public Object getBufferedReaderOrBinaryDocument(int n, boolean bl) {
            Object object;
            if (this.stringReaders != null) {
                return bl ? null : this.stringReaders[n].getBufferedReader();
            }
            String string = this.fullPathNamesIn[n];
            String[] stringArray = null;
            this.htParams.remove("subFileList");
            if (string.indexOf("|") >= 0) {
                stringArray = TextFormat.split(string, "|");
                string = stringArray[0];
            }
            if ((object = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(string, true, bl, false, true)) instanceof ZipInputStream) {
                if (stringArray != null) {
                    this.htParams.put("subFileList", stringArray);
                }
                String[] stringArray2 = FileManager.this.getZipDirectory(string, true);
                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)FileManager.this.getInputStreamOrErrorMessageFromName(string, false, false), 8192);
                object = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionOrBufferedReaderFromZip(bufferedInputStream, string, stringArray2, this.htParams, true, bl);
            }
            if (object instanceof BufferedInputStream) {
                return new BinaryDocument((BufferedInputStream)object);
            }
            if (object instanceof BufferedReader || object instanceof BinaryDocument) {
                return object;
            }
            return object == null ? "error opening:" + this.namesAsGivenIn[n] : (String)object;
        }
    }

    class StringDataReader
    extends DataReader {
        StringDataReader(String string) {
            super(new StringReader(string));
        }
    }
}

