/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.control;

import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.control.GeneralLayoutNode;
import edu.colorado.phet.buildamolecule.model.CollectionBox;
import edu.colorado.phet.buildamolecule.model.Molecule;
import edu.colorado.phet.buildamolecule.view.view3d.JmolDialogProperty;
import edu.colorado.phet.buildamolecule.view.view3d.ShowMolecule3DButtonNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionBoxNode
extends GeneralLayoutNode {
    private final CollectionBox box;
    private final PNode boxNode = new PNode();
    private final PhetPPath blackBox;
    private final PNode moleculeLayer = new PNode();
    private final List<PNode> moleculeNodes = new LinkedList<PNode>();
    private final JmolDialogProperty dialog = new JmolDialogProperty();
    private final Map<Molecule, PNode> moleculeNodeMap = new HashMap<Molecule, PNode>();
    private Timer blinkTimer = null;
    private double button3dWidth;
    private int headerCount = 0;
    private final GeneralLayoutNode.LayoutMethod method = new GeneralLayoutNode.CompositeLayoutMethod(new GeneralLayoutNode.VerticalLayoutMethod(), new GeneralLayoutNode.HorizontalAlignMethod(GeneralLayoutNode.HorizontalAlignMethod.Align.Centered));
    private SimpleObserver locationUpdateObserver;

    public CollectionBoxNode(final CollectionBox collectionBox, final Function1<PNode, Rectangle2D> function1) {
        this.box = collectionBox;
        this.blackBox = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, 160.0, 50.0), BuildAMoleculeConstants.MOLECULE_COLLECTION_BOX_BACKGROUND){
            {
                super(shape, paint);
                final 1 var6_6 = this;
                CollectionBoxNode.this.locationUpdateObserver = new SimpleObserver(){

                    public void update() {
                        collectionBox.setDropBounds((Rectangle2D)function1.apply(var6_6));
                    }
                };
                ShowMolecule3DButtonNode showMolecule3DButtonNode = new ShowMolecule3DButtonNode(CollectionBoxNode.this.dialog, collectionBox.getMoleculeType()){
                    {
                        collectionBox.addListener(new CollectionBox.Adapter(){
                            {
                                this.updateVisibility();
                            }

                            private void updateVisibility() {
                                this.setVisible(collectionBox.quantity.get() > 0);
                            }

                            public void onAddedMolecule(Molecule molecule) {
                                this.updateVisibility();
                            }

                            public void onRemovedMolecule(Molecule molecule) {
                                this.updateVisibility();
                            }
                        });
                    }
                };
                this.addChild(showMolecule3DButtonNode);
                showMolecule3DButtonNode.centerFullBoundsOnPoint(this.getFullBounds().getWidth() - 10.0 - showMolecule3DButtonNode.getFullBounds().getWidth() / 2.0, this.getFullBounds().getHeight() / 2.0);
                CollectionBoxNode.this.button3dWidth = showMolecule3DButtonNode.getFullBounds().getWidth();
            }
        };
        this.boxNode.addChild(this.blackBox);
        this.boxNode.addChild(this.moleculeLayer);
        this.updateBoxGraphics();
        collectionBox.addListener(new CollectionBox.Listener(){

            public void onAddedMolecule(Molecule molecule) {
                CollectionBoxNode.this.addMolecule(molecule);
            }

            public void onRemovedMolecule(Molecule molecule) {
                CollectionBoxNode.this.removeMolecule(molecule);
            }

            public void onAcceptedMoleculeCreation(Molecule molecule) {
                CollectionBoxNode.this.blink();
            }
        });
        BuildAMoleculeConstants.MOLECULE_COLLECTION_BOX_HIGHLIGHT.addObserver(new SimpleObserver(){

            public void update() {
                CollectionBoxNode.this.updateBoxGraphics();
            }
        });
        LinkedList<PNode> linkedList = new LinkedList<PNode>();
        for (int i = 0; i < collectionBox.getCapacity(); ++i) {
            PNode pNode = collectionBox.getMoleculeType().createPseudo3DNode();
            pNode.setVisible(false);
            linkedList.add(pNode);
            this.moleculeLayer.addChild(pNode);
        }
        this.layOutMoleculeList(linkedList);
        this.centerMoleculesInBlackBox();
        this.addChild(this.boxNode, this.method, 3.0, 0.0, 0.0, 0.0);
    }

    protected void addHeaderNode(PNode pNode) {
        this.addChild(this.headerCount, pNode, this.method, 0.0, 0.0, -3.0, 0.0);
        ++this.headerCount;
    }

    private void addMolecule(Molecule molecule) {
        this.cancelBlinksInProgress();
        this.updateBoxGraphics();
        PNode pNode = molecule.getMatchingCompleteMolecule().createPseudo3DNode();
        this.moleculeLayer.addChild(pNode);
        this.moleculeNodes.add(pNode);
        this.moleculeNodeMap.put(molecule, pNode);
        this.updateMoleculeLayout();
    }

    private void removeMolecule(Molecule molecule) {
        this.cancelBlinksInProgress();
        this.updateBoxGraphics();
        PNode pNode = this.moleculeNodeMap.get(molecule);
        this.moleculeLayer.removeChild(pNode);
        this.moleculeNodes.remove(pNode);
        this.moleculeNodeMap.remove(molecule);
        this.updateMoleculeLayout();
    }

    private void updateMoleculeLayout() {
        this.layOutMoleculeList(this.moleculeNodes);
        if (this.box.quantity.get() > 0) {
            this.centerMoleculesInBlackBox();
        }
    }

    private void layOutMoleculeList(List<PNode> list) {
        double d = 0.0;
        for (PNode pNode : list) {
            d = Math.max(d, pNode.getFullBounds().getHeight());
        }
        double d2 = 0.0;
        for (PNode pNode : list) {
            pNode.setOffset(d2, (d - pNode.getFullBounds().getHeight()) / 2.0);
            d2 += pNode.getFullBounds().getWidth() + 5.0;
        }
    }

    private PBounds getMoleculeAreaInBlackBox() {
        PBounds pBounds = this.blackBox.getFullBounds();
        return new PBounds(pBounds.getX(), pBounds.getY(), pBounds.getWidth() - 10.0 - this.button3dWidth, pBounds.getHeight());
    }

    private void centerMoleculesInBlackBox() {
        PBounds pBounds = this.getMoleculeAreaInBlackBox();
        this.moleculeLayer.setScale(1.0);
        double d = (pBounds.getWidth() - 25.0) / this.moleculeLayer.getFullBounds().getWidth();
        double d2 = (pBounds.getHeight() - 25.0) / this.moleculeLayer.getFullBounds().getHeight();
        this.moleculeLayer.setScale(Math.min(d, d2));
        this.moleculeLayer.centerFullBoundsOnPoint(pBounds.getCenterX() - pBounds.getX(), pBounds.getCenterY() - pBounds.getY());
    }

    private void updateBoxGraphics() {
        this.blackBox.setStroke(new BasicStroke(4.0f));
        if (this.box.isFull()) {
            this.blackBox.setStrokePaint(BuildAMoleculeConstants.MOLECULE_COLLECTION_BOX_HIGHLIGHT.get());
        } else {
            this.blackBox.setStrokePaint(BuildAMoleculeConstants.MOLECULE_COLLECTION_BACKGROUND);
        }
    }

    public void updateLocation() {
        this.locationUpdateObserver.update();
    }

    private void blink() {
        double d = 1.3;
        int n = 100;
        final Property<Boolean> property = new Property<Boolean>(false);
        final Property<Integer> property2 = new Property<Integer>((int)(d * 1000.0 / (double)n));
        this.cancelBlinksInProgress();
        this.blinkTimer = new Timer();
        this.blinkTimer.schedule(new TimerTask(){

            public void run() {
                property2.set((Integer)property2.get() - 1);
                assert ((Integer)property2.get() >= 0);
                if ((Integer)property2.get() == 0) {
                    CollectionBoxNode.this.updateBoxGraphics();
                    CollectionBoxNode.this.blinkTimer.cancel();
                    CollectionBoxNode.this.blinkTimer = null;
                } else {
                    property.set((Boolean)property.get() == false);
                    if (((Boolean)property.get()).booleanValue()) {
                        CollectionBoxNode.this.blackBox.setPaint(BuildAMoleculeConstants.MOLECULE_COLLECTION_BOX_BACKGROUND_BLINK);
                        CollectionBoxNode.this.blackBox.setStrokePaint(BuildAMoleculeConstants.MOLECULE_COLLECTION_BOX_BORDER_BLINK);
                    } else {
                        CollectionBoxNode.this.blackBox.setPaint(BuildAMoleculeConstants.MOLECULE_COLLECTION_BOX_BACKGROUND);
                        CollectionBoxNode.this.blackBox.setStrokePaint(BuildAMoleculeConstants.MOLECULE_COLLECTION_BACKGROUND);
                    }
                    CollectionBoxNode.this.blackBox.repaint();
                }
            }
        }, 0L, (long)n);
    }

    private void cancelBlinksInProgress() {
        if (this.blinkTimer != null) {
            this.blinkTimer.cancel();
            this.blinkTimer = null;
        }
    }
}

