/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.control;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class GeneralLayoutNode
extends PNode {
    private boolean activelyLayingOut = false;
    private final List<LayoutElement> elements = new ArrayList<LayoutElement>();
    private boolean updateOnChildBounds;
    private PropertyChangeListener childBoundsListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("visible") || string.equals("fullBounds") || string.equals("bounds") || string.equals("transform")) {
                GeneralLayoutNode.this.updateLayout();
            }
        }
    };
    private final PNode invisibleBackground = new PNode(){
        {
            this.setVisible(false);
        }
    };

    public GeneralLayoutNode() {
        this(true);
    }

    public GeneralLayoutNode(boolean bl) {
        this.updateOnChildBounds = bl;
        this.addChild(this.invisibleBackground);
    }

    public LayoutProperties getLayoutProperties() {
        return new LayoutProperties(this.elements);
    }

    public void addChild(PNode pNode, LayoutMethod layoutMethod) {
        this.addChild(new LayoutElement(pNode, layoutMethod));
    }

    public void addChild(PNode pNode, LayoutMethod layoutMethod, double d, double d2, double d3, double d4) {
        this.addChild(new LayoutElement(pNode, layoutMethod, d, d2, d3, d4));
    }

    public void addChild(int n, PNode pNode, LayoutMethod layoutMethod, double d, double d2, double d3, double d4) {
        this.addChild(n, new LayoutElement(pNode, layoutMethod, d, d2, d3, d4));
    }

    public void addChild(LayoutElement layoutElement) {
        this.addChild(this.elements.size(), layoutElement);
    }

    public void addChild(int n, LayoutElement layoutElement) {
        this.elements.add(n, layoutElement);
        super.addChild(n + 1, layoutElement.node);
        if (this.updateOnChildBounds) {
            layoutElement.node.addPropertyChangeListener(this.childBoundsListener);
        }
        this.updateLayout();
    }

    public PNode removeChild(int n) {
        PNode pNode = super.getChild(n);
        for (LayoutElement layoutElement : new ArrayList<LayoutElement>(this.elements)) {
            if (layoutElement.node != pNode) continue;
            this.elements.remove(layoutElement);
            layoutElement.node.removePropertyChangeListener(this.childBoundsListener);
        }
        return super.removeChild(n);
    }

    public void updateLayout() {
        if (this.activelyLayingOut) {
            return;
        }
        this.activelyLayingOut = true;
        LayoutProperties layoutProperties = this.getLayoutProperties();
        for (int i = 0; i < this.elements.size(); ++i) {
            LayoutElement layoutElement = this.elements.get(i);
            layoutElement.method.layout(layoutElement, i, i > 0 ? this.elements.get(i - 1) : null, layoutProperties);
        }
        this.invisibleBackground.removeAllChildren();
        PBounds pBounds = this.getLayoutBounds();
        if (pBounds != null) {
            this.invisibleBackground.addChild(new PPath(pBounds){
                {
                    this.setStroke(null);
                }
            });
        }
        this.activelyLayingOut = false;
    }

    public PBounds getLayoutBounds() {
        PBounds pBounds = null;
        for (LayoutElement layoutElement : this.elements) {
            if (pBounds == null) {
                pBounds = layoutElement.getLayoutBounds();
                continue;
            }
            pBounds.add(layoutElement.getLayoutBounds());
        }
        return pBounds;
    }

    public static class CompositeLayoutMethod
    implements LayoutMethod {
        private final LayoutMethod[] methods;

        public CompositeLayoutMethod(LayoutMethod ... layoutMethodArray) {
            this.methods = layoutMethodArray;
        }

        public void layout(LayoutElement layoutElement, int n, LayoutElement layoutElement2, LayoutProperties layoutProperties) {
            for (LayoutMethod layoutMethod : this.methods) {
                layoutMethod.layout(layoutElement, n, layoutElement2, layoutProperties);
            }
        }
    }

    public static class HorizontalAlignMethod
    implements LayoutMethod {
        private final Align align;

        public HorizontalAlignMethod(Align align) {
            this.align = align;
        }

        public void layout(LayoutElement layoutElement, int n, LayoutElement layoutElement2, LayoutProperties layoutProperties) {
            switch (this.align) {
                case Left: {
                    layoutElement.setLeft(0.0);
                    break;
                }
                case Centered: {
                    layoutElement.setLeft((layoutProperties.maxWidth - layoutElement.getLayoutBounds().getWidth()) / 2.0);
                    break;
                }
                case Right: {
                    layoutElement.setLeft(layoutProperties.maxWidth - layoutElement.getLayoutBounds().getWidth());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Align
        extends Enum<Align> {
            public static final /* enum */ Align Left = new Align();
            public static final /* enum */ Align Centered = new Align();
            public static final /* enum */ Align Right = new Align();
            private static final /* synthetic */ Align[] $VALUES;

            public static Align[] values() {
                return (Align[])$VALUES.clone();
            }

            static {
                $VALUES = new Align[]{Left, Centered, Right};
            }
        }
    }

    public static class LayoutElement {
        public final PNode node;
        public final LayoutMethod method;
        public final double paddingTop;
        public final double paddingLeft;
        public final double paddingBottom;
        public final double paddingRight;

        public LayoutElement(PNode pNode, LayoutMethod layoutMethod) {
            this(pNode, layoutMethod, 0.0, 0.0, 0.0, 0.0);
        }

        public LayoutElement(PNode pNode, LayoutMethod layoutMethod, double d, double d2, double d3, double d4) {
            this.node = pNode;
            this.method = layoutMethod;
            this.paddingTop = d;
            this.paddingLeft = d2;
            this.paddingBottom = d3;
            this.paddingRight = d4;
        }

        public PBounds getFullBounds() {
            return this.node.getFullBounds();
        }

        public PBounds getLayoutBounds() {
            PBounds pBounds = this.getFullBounds();
            return new PBounds(pBounds.getX() - this.paddingLeft, pBounds.getY() - this.paddingTop, pBounds.getWidth() + this.paddingLeft + this.paddingRight, pBounds.getHeight() + this.paddingTop + this.paddingBottom);
        }

        public void setLeft(double d) {
            double d2 = this.node.getXOffset() - this.getFullBounds().getX();
            double d3 = d + this.paddingLeft + d2;
            if (this.node.getXOffset() != d3) {
                this.node.setOffset(d3, this.node.getYOffset());
            }
        }

        public void setTop(double d) {
            double d2 = this.node.getYOffset() - this.getFullBounds().getY();
            double d3 = d + this.paddingTop + d2;
            if (this.node.getYOffset() != d3) {
                this.node.setOffset(this.node.getXOffset(), d3);
            }
        }
    }

    public static interface LayoutMethod {
        public void layout(LayoutElement var1, int var2, LayoutElement var3, LayoutProperties var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LayoutProperties {
        public final double maxWidth;
        public final double maxHeight;

        public LayoutProperties(List<LayoutElement> list) {
            double d = 0.0;
            double d2 = 0.0;
            for (LayoutElement layoutElement : list) {
                d = Math.max(d, layoutElement.getLayoutBounds().getWidth());
                d2 = Math.max(d2, layoutElement.getLayoutBounds().getHeight());
            }
            this.maxWidth = d;
            this.maxHeight = d2;
        }
    }

    public static class VerticalLayoutMethod
    implements LayoutMethod {
        public void layout(LayoutElement layoutElement, int n, LayoutElement layoutElement2, LayoutProperties layoutProperties) {
            layoutElement.setTop(layoutElement2 == null ? 0.0 : layoutElement2.getLayoutBounds().getMaxY());
        }
    }
}

