/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.module;

import edu.colorado.phet.buildamolecule.model.Bucket;
import edu.colorado.phet.buildamolecule.model.CollectionBox;
import edu.colorado.phet.buildamolecule.model.CollectionList;
import edu.colorado.phet.buildamolecule.model.CompleteMolecule;
import edu.colorado.phet.buildamolecule.model.Kit;
import edu.colorado.phet.buildamolecule.model.KitCollection;
import edu.colorado.phet.buildamolecule.model.LayoutBounds;
import edu.colorado.phet.buildamolecule.model.MoleculeList;
import edu.colorado.phet.buildamolecule.model.MoleculeStructure;
import edu.colorado.phet.buildamolecule.view.BuildAMoleculeCanvas;
import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.piccolophet.SimSharingPiccoloModule;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Frame;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildAMoleculeModule
extends SimSharingPiccoloModule {
    protected final LayoutBounds bounds;
    protected BuildAMoleculeCanvas canvas;
    private CollectionList collectionList;
    private static Random random = new Random(System.currentTimeMillis());

    public AbstractBuildAMoleculeModule(IUserComponent iUserComponent, Frame frame, String string, LayoutBounds layoutBounds) {
        super(iUserComponent, string, new ConstantDtClock(30.0));
        this.bounds = layoutBounds;
        this.setClockControlPanel(null);
    }

    protected abstract BuildAMoleculeCanvas buildCanvas(CollectionList var1);

    protected void setInitialCollection(KitCollection kitCollection) {
        this.collectionList = new CollectionList(kitCollection, this.bounds);
        this.canvas = this.buildCanvas(this.collectionList);
        this.setSimulationPanel(this.canvas);
    }

    protected KitCollection generateModel() {
        return null;
    }

    public void addGeneratedCollection() {
        KitCollection kitCollection = this.generateModel();
        if (kitCollection != null) {
            this.collectionList.addCollection(kitCollection);
        }
    }

    public BuildAMoleculeCanvas getCanvas() {
        return this.canvas;
    }

    /*
     * WARNING - void declaration
     */
    protected KitCollection generateModel(boolean bl, int n) {
        int n3;
        Iterator iterator;
        HashSet<CompleteMolecule> hashSet = new HashSet<CompleteMolecule>();
        LinkedList<Kit> linkedList = new LinkedList<Kit>();
        LinkedList<CollectionBox> linkedList2 = new LinkedList<CollectionBox>();
        LinkedList<MoleculeStructure<Atom>> linkedList3 = new LinkedList<MoleculeStructure<Atom>>();
        for (int i = 0; i < n; ++i) {
            iterator = this.pickRandomMoleculeNotIn(hashSet);
            hashSet.add((CompleteMolecule)((Object)iterator));
            int n4 = bl ? random.nextInt(3) + 1 : 1;
            n3 = ((MoleculeStructure)((Object)iterator)).getHistogram().getQuantity(Element.C);
            if (n3 > 1) {
                n4 = Math.min(2, n4);
            }
            CollectionBox collectionBox = new CollectionBox((CompleteMolecule)((Object)iterator), n4);
            linkedList2.add(collectionBox);
            for (int n2 = 0; n2 < collectionBox.getCapacity(); ++n2) {
                linkedList3.add(((MoleculeStructure)((Object)iterator)).getAtomCopy());
            }
        }
        Collections.shuffle(linkedList3);
        while (!linkedList3.isEmpty()) {
            void var13_28;
            void var13_27;
            LinkedList<Bucket> linkedList4 = new LinkedList<Bucket>();
            iterator = (MoleculeStructure)linkedList3.get(0);
            HashSet<Element> hashSet2 = new HashSet<Element>();
            for (Atom atom : ((MoleculeStructure)((Object)iterator)).getAtoms()) {
                hashSet2.add(atom.getElement());
            }
            n3 = 0;
            for (MoleculeStructure moleculeStructure : linkedList3) {
                if (!moleculeStructure.getHillSystemFormulaFragment().equals(((MoleculeStructure)((Object)iterator)).getHillSystemFormulaFragment())) continue;
                ++n3;
            }
            boolean bl2 = bl && n3 > 1;
            int n2 = 1 + (bl2 ? n3 : 0);
            for (Element element : hashSet2) {
                int n4 = 0;
                for (Atom atom : ((MoleculeStructure)((Object)iterator)).getAtoms()) {
                    if (!atom.getElement().isSameElement(element)) continue;
                    ++n4;
                }
                int n5 = n4 * n2;
                if (!element.isCarbon() && (element.isHydrogen() || n5 < 4)) {
                    n5 += random.nextInt(2);
                }
                int n6 = Bucket.calculateIdealBucketWidth(element.getRadius(), n5);
                linkedList4.add(new Bucket(new PDimension(n6, 200.0), this.getClock(), element, n5));
            }
            linkedList.add(new Kit(this.bounds, linkedList4.toArray(new Bucket[linkedList4.size()])));
            linkedList3.remove(iterator);
            --var13_27;
            while (var13_28 > 0) {
                for (int i = 0; i < linkedList3.size(); ++i) {
                    if (!((MoleculeStructure)linkedList3.get(i)).getHillSystemFormulaFragment().equals(((MoleculeStructure)((Object)iterator)).getHillSystemFormulaFragment())) continue;
                    linkedList3.remove(i);
                    break;
                }
                --var13_28;
            }
        }
        KitCollection kitCollection = new KitCollection();
        for (Kit kit : linkedList) {
            kitCollection.addKit(kit);
        }
        for (CollectionBox collectionBox : linkedList2) {
            kitCollection.addCollectionBox(collectionBox);
        }
        return kitCollection;
    }

    private CompleteMolecule pickRandomMoleculeNotIn(Set<CompleteMolecule> set) {
        CompleteMolecule completeMolecule;
        while (set.contains(completeMolecule = MoleculeList.COLLECTION_BOX_MOLECULES[MoleculeList.random.nextInt(MoleculeList.COLLECTION_BOX_MOLECULES.length)])) {
        }
        return completeMolecule;
    }

    @Override
    public void reset() {
        this.collectionList.reset();
    }
}

