/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.view;

import edu.colorado.phet.buildamolecule.BuildAMoleculeApplication;
import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.BuildAMoleculeSimSharing;
import edu.colorado.phet.buildamolecule.model.Atom2D;
import edu.colorado.phet.buildamolecule.model.Bucket;
import edu.colorado.phet.buildamolecule.model.Kit;
import edu.colorado.phet.buildamolecule.model.Molecule;
import edu.colorado.phet.buildamolecule.view.AtomNode;
import edu.colorado.phet.buildamolecule.view.BuildAMoleculeCanvas;
import edu.colorado.phet.buildamolecule.view.MoleculeBondContainerNode;
import edu.colorado.phet.buildamolecule.view.MoleculeMetadataNode;
import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.nodes.BucketView;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class KitView {
    private PNode topLayer = new PNode();
    private PNode metadataLayer = new PNode();
    private PNode atomLayer = new PNode();
    private PNode bottomLayer = new PNode();
    private final Kit kit;
    private final BuildAMoleculeCanvas canvas;
    private Map<Molecule, MoleculeMetadataNode> metadataMap = new HashMap<Molecule, MoleculeMetadataNode>();
    private Map<Molecule, MoleculeBondContainerNode> bondMap = new HashMap<Molecule, MoleculeBondContainerNode>();
    private Map<Atom, AtomNode> atomNodeMap = new HashMap<Atom, AtomNode>();

    public KitView(final Kit kit, BuildAMoleculeCanvas buildAMoleculeCanvas) {
        this.kit = kit;
        this.canvas = buildAMoleculeCanvas;
        for (Bucket bucket : kit.getBuckets()) {
            BucketView bucketView = new BucketView(bucket, BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM, Color.BLACK, BucketView.DEFAULT_LABEL_FONT);
            this.topLayer.addChild(bucketView.getFrontNode());
            this.bottomLayer.addChild(bucketView.getHoleNode());
            for (final Atom2D atom2D : bucket.getAtoms()) {
                final AtomNode atomNode = new AtomNode(atom2D);
                this.atomNodeMap.put(atom2D, atomNode);
                this.atomLayer.addChild(atomNode);
                atomNode.addInputEventListener(new SimSharingDragHandler(UserComponentChain.chain((IUserComponent)BuildAMoleculeSimSharing.UserComponent.atom, atom2D.getId()), UserComponentTypes.sprite, true){

                    protected void startDrag(PInputEvent pInputEvent) {
                        super.startDrag(pInputEvent);
                        atom2D.setUserControlled(true);
                        Molecule molecule = kit.getMolecule(atom2D);
                        if (molecule != null) {
                            for (Atom atom : molecule.getAtoms()) {
                                ((AtomNode)KitView.this.atomNodeMap.get(atom)).moveToFront();
                            }
                        } else {
                            atomNode.moveToFront();
                        }
                    }

                    public void mouseDragged(PInputEvent pInputEvent) {
                        super.mouseDragged(pInputEvent);
                        PDimension pDimension = pInputEvent.getDeltaRelativeTo(atomNode.getParent());
                        Vector2D vector2D = BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM.viewToModelDelta(new Vector2D(pDimension.width, pDimension.height));
                        kit.atomDragged(atom2D, vector2D);
                    }

                    protected void endDrag(PInputEvent pInputEvent) {
                        super.endDrag(pInputEvent);
                        atom2D.setUserControlled(false);
                    }

                    protected ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                        return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.atomId, atom2D.getId()).with((IParameterKey)BuildAMoleculeSimSharing.ParameterKey.atomElement, atom2D.getSymbol());
                    }
                });
            }
        }
        kit.addMoleculeListener(new Kit.MoleculeAdapter(){

            public void addedMolecule(Molecule molecule) {
                MoleculeMetadataNode moleculeMetadataNode = new MoleculeMetadataNode(kit, molecule);
                KitView.this.metadataLayer.addChild(moleculeMetadataNode);
                KitView.this.metadataMap.put(molecule, moleculeMetadataNode);
                if (BuildAMoleculeApplication.allowBondBreaking.get().booleanValue()) {
                    KitView.this.addMoleculeBondNodes(molecule);
                }
            }

            public void removedMolecule(Molecule molecule) {
                MoleculeMetadataNode moleculeMetadataNode = (MoleculeMetadataNode)KitView.this.metadataMap.get(molecule);
                moleculeMetadataNode.destruct();
                KitView.this.metadataLayer.removeChild(moleculeMetadataNode);
                KitView.this.metadataMap.remove(molecule);
                if (BuildAMoleculeApplication.allowBondBreaking.get().booleanValue()) {
                    KitView.this.removeMoleculeBondNodes(molecule);
                }
            }
        });
        BuildAMoleculeApplication.allowBondBreaking.addObserver(new SimpleObserver(){

            public void update() {
                if (BuildAMoleculeApplication.allowBondBreaking.get().booleanValue()) {
                    for (Molecule molecule : KitView.this.metadataMap.keySet()) {
                        KitView.this.addMoleculeBondNodes(molecule);
                    }
                } else {
                    for (Molecule molecule : KitView.this.bondMap.keySet()) {
                        KitView.this.removeMoleculeBondNodes(molecule);
                    }
                }
            }
        });
        kit.visible.addObserver(new SimpleObserver(){

            public void update() {
                Boolean bl = kit.visible.get();
                KitView.this.topLayer.setVisible(bl);
                KitView.this.metadataLayer.setVisible(bl);
                KitView.this.atomLayer.setVisible(bl);
                KitView.this.bottomLayer.setVisible(bl);
            }
        });
    }

    public void addMoleculeBondNodes(Molecule molecule) {
        MoleculeBondContainerNode moleculeBondContainerNode = new MoleculeBondContainerNode(this.kit, molecule, this.canvas);
        this.metadataLayer.addChild(moleculeBondContainerNode);
        this.bondMap.put(molecule, moleculeBondContainerNode);
    }

    public void removeMoleculeBondNodes(Molecule molecule) {
        MoleculeBondContainerNode moleculeBondContainerNode = this.bondMap.get(molecule);
        moleculeBondContainerNode.destruct();
        this.metadataLayer.removeChild(moleculeBondContainerNode);
        this.bondMap.remove(molecule);
    }

    public PNode getTopLayer() {
        return this.topLayer;
    }

    public PNode getMetadataLayer() {
        return this.metadataLayer;
    }

    public PNode getAtomLayer() {
        return this.atomLayer;
    }

    public PNode getBottomLayer() {
        return this.bottomLayer;
    }
}

