/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chemistry.molecules;

import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.piccolophet.nodes.ShadedSphereNode;
import java.awt.Color;

public class AtomNode
extends ShadedSphereNode {
    private static final double MAX_RADIUS = Element.P.getRadius();
    private static final Function1<Double, Double> RADIUS_SCALING_FUNCTION = new Function1<Double, Double>(){

        @Override
        public Double apply(Double d) {
            double d2 = MAX_RADIUS - 0.75 * (MAX_RADIUS - d);
            return 0.11 * d2;
        }
    };

    public AtomNode(Element element) {
        this(element.getRadius(), element.getColor());
    }

    public AtomNode(double d, Color color) {
        super(2.0 * RADIUS_SCALING_FUNCTION.apply(d), color);
    }
}

