/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chemistry.molecules;

import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.chemistry.molecules.AtomNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;

public abstract class HorizontalMoleculeNode
extends PComposite {
    public HorizontalMoleculeNode(Element ... elementArray) {
        PComposite pComposite = new PComposite();
        this.addChild(pComposite);
        double d = 0.0;
        PNode pNode = null;
        for (Element element : elementArray) {
            AtomNode atomNode = new AtomNode(element);
            pComposite.addChild(atomNode);
            if (pNode != null) {
                d = pNode.getFullBoundsReference().getMaxX() + 0.25 * atomNode.getFullBoundsReference().getWidth();
            }
            atomNode.setOffset(d, 0.0);
            pNode = atomNode;
        }
        pComposite.setOffset(-PNodeLayoutUtils.getOriginXOffset(pComposite), -PNodeLayoutUtils.getOriginYOffset(pComposite));
    }

    public static class CO2Node
    extends HorizontalMoleculeNode {
        public CO2Node() {
            super(Element.O, Element.C, Element.O);
        }
    }

    public static class CS2Node
    extends HorizontalMoleculeNode {
        public CS2Node() {
            super(Element.S, Element.C, Element.S);
        }
    }

    public static class Cl2Node
    extends HorizontalMoleculeNode {
        public Cl2Node() {
            super(Element.Cl, Element.Cl);
        }
    }

    public static class F2Node
    extends HorizontalMoleculeNode {
        public F2Node() {
            super(Element.F, Element.F);
        }
    }

    public static class H2Node
    extends HorizontalMoleculeNode {
        public H2Node() {
            super(Element.H, Element.H);
        }
    }

    public static class N2Node
    extends HorizontalMoleculeNode {
        public N2Node() {
            super(Element.N, Element.N);
        }
    }

    public static class N2ONode
    extends HorizontalMoleculeNode {
        public N2ONode() {
            super(Element.N, Element.N, Element.O);
        }
    }

    public static class NONode
    extends HorizontalMoleculeNode {
        public NONode() {
            super(Element.N, Element.O);
        }
    }

    public static class O2Node
    extends HorizontalMoleculeNode {
        public O2Node() {
            super(Element.O, Element.O);
        }
    }
}

