/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PInputManager;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class PInputEvent {
    private final InputEvent inputEvent;
    private PPickPath pickPath;
    private final PInputManager inputManager;
    private boolean handled;

    public PInputEvent(PInputManager pInputManager, InputEvent inputEvent) {
        this.inputEvent = inputEvent;
        this.inputManager = pInputManager;
    }

    public PCamera getCamera() {
        return this.getPath().getBottomCamera();
    }

    public PCamera getTopCamera() {
        return this.getPath().getTopCamera();
    }

    public PComponent getComponent() {
        return this.getTopCamera().getComponent();
    }

    public PPickPath getPath() {
        return this.pickPath;
    }

    public void setPath(PPickPath pPickPath) {
        this.pickPath = pPickPath;
    }

    public PNode getPickedNode() {
        if (this.pickPath == null) {
            return null;
        }
        return this.pickPath.getPickedNode();
    }

    public int getModifiers() {
        if (!this.isFocusEvent()) {
            return this.inputEvent.getModifiers();
        }
        throw new IllegalStateException("Can't get modifiers from focus event");
    }

    public int getModifiersEx() {
        if (!this.isFocusEvent()) {
            return this.inputEvent.getModifiersEx();
        }
        throw new IllegalStateException("Can't get modifiers ex from focus event");
    }

    public int getClickCount() {
        if (this.isMouseEvent()) {
            return ((MouseEvent)this.inputEvent).getClickCount();
        }
        throw new IllegalStateException("Can't get clickcount from key event");
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void setHandled(boolean bl) {
        this.handled = bl;
    }

    public int getButton() {
        if (this.isMouseEvent()) {
            return ((MouseEvent)this.inputEvent).getButton();
        }
        throw new IllegalStateException("Can't get button from key event");
    }

    public InputEvent getSourceSwingEvent() {
        return this.inputEvent;
    }

    public boolean isMouseEvent() {
        return this.inputEvent instanceof MouseEvent;
    }

    public boolean isFocusEvent() {
        return this.inputEvent == null;
    }

    public boolean isMouseEnteredOrMouseExited() {
        if (this.isMouseEvent()) {
            return this.inputEvent.getID() == 504 || this.inputEvent.getID() == 505;
        }
        return false;
    }

    public Point2D getCanvasPosition() {
        return (Point2D)this.inputManager.getCurrentCanvasPosition().clone();
    }

    public PDimension getCanvasDelta() {
        Point2D point2D = this.inputManager.getLastCanvasPosition();
        Point2D point2D2 = this.inputManager.getCurrentCanvasPosition();
        return new PDimension(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
    }

    public Point2D getPositionRelativeTo(PNode pNode) {
        if (this.pickPath == null) {
            throw new RuntimeException("Attempting to use pickPath for a non-mouse event.");
        }
        Point2D point2D = this.getCanvasPosition();
        return this.pickPath.canvasToLocal(point2D, pNode);
    }

    public PDimension getDeltaRelativeTo(PNode pNode) {
        if (this.pickPath == null) {
            throw new RuntimeException("Attempting to use pickPath for a non-mouse event.");
        }
        PDimension pDimension = this.getCanvasDelta();
        return (PDimension)this.pickPath.canvasToLocal(pDimension, pNode);
    }

    public Point2D getPosition() {
        if (this.pickPath == null) {
            throw new RuntimeException("Attempting to use pickPath for a non-mouse event.");
        }
        Point2D point2D = this.getCanvasPosition();
        this.pickPath.canvasToLocal(point2D, (PNode)this.getCamera());
        return this.getCamera().localToView(point2D);
    }

    public PDimension getDelta() {
        if (this.pickPath == null) {
            throw new RuntimeException("Attempting to use pickPath for a non-mouse event.");
        }
        PDimension pDimension = this.getCanvasDelta();
        this.pickPath.canvasToLocal(pDimension, (PNode)this.getCamera());
        return (PDimension)this.getCamera().localToView(pDimension);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString().replaceAll(".*\\.", ""));
        stringBuffer.append('[');
        if (this.handled) {
            stringBuffer.append("handled");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

