/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.atomdata;

import org.jmol.script.Token;
import org.jmol.viewer.JmolConstants;

public class RadiusData {
    public int type;
    public int vdwType = 8;
    public float value = Float.NaN;
    public float valueExtended = 0.0f;
    public float[] values;

    public RadiusData() {
    }

    public RadiusData(float f, int n, int n2) {
        this.type = n;
        this.value = f;
        this.vdwType = n2;
    }

    public String toString() {
        if (Float.isNaN(this.value)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        block0 : switch (this.type) {
            case 0: {
                stringBuffer.append(this.value);
                break;
            }
            case 1: {
                stringBuffer.append(this.value > 0.0f ? "+" : "").append(this.value);
                break;
            }
            case 2: {
                stringBuffer.append((int)(this.value * 100.0f)).append("%");
                switch (this.vdwType) {
                    case 1112539137: 
                    case 1112539138: 
                    case 1112541194: 
                    case 1112541198: {
                        stringBuffer.append(Token.nameOf(this.vdwType));
                        break block0;
                    }
                }
                if (this.vdwType == 8) break;
                stringBuffer.append(JmolConstants.getVdwLabel(this.vdwType));
                break;
            }
            case 3: {
                stringBuffer.append((int)this.value);
            }
        }
        return stringBuffer.toString();
    }
}

