/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;

class Platform3D {
    int windowWidth;
    int windowHeight;
    int windowSize;
    int bufferWidth;
    int bufferHeight;
    int bufferSize;
    int bufferSizeT;
    Image imagePixelBuffer;
    int[] pBuffer;
    int[] pBufferT;
    int[] zBuffer;
    int[] zBufferT;
    int widthOffscreen;
    int heightOffscreen;
    Image imageOffscreen;
    Graphics gOffscreen;
    boolean useClearingThread = true;
    ClearingThread clearingThread;
    Graphics graphicsOffscreen;
    private static final DirectColorModel rgbColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private static final int[] sampleModelBitMasks = new int[]{0xFF0000, 65280, 255};
    private static boolean backgroundTransparent = false;

    Platform3D() {
    }

    static Platform3D createInstance(Component component) {
        if (component == null) {
            return null;
        }
        Platform3D platform3D = new Platform3D();
        platform3D.initialize(false);
        platform3D.graphicsOffscreen = platform3D.allocateOffscreenImage(1, 1).getGraphics();
        return platform3D;
    }

    final void initialize(boolean bl) {
        this.useClearingThread = bl;
        if (bl) {
            this.clearingThread = new ClearingThread();
            this.clearingThread.start();
        }
    }

    void allocateTBuffers(boolean bl) {
        this.bufferSizeT = bl ? this.bufferSize : this.windowSize;
        this.zBufferT = new int[this.bufferSizeT];
        this.pBufferT = new int[this.bufferSizeT];
    }

    void allocateBuffers(int n, int n2, boolean bl) {
        this.windowWidth = n;
        this.windowHeight = n2;
        this.windowSize = n * n2;
        if (bl) {
            this.bufferWidth = n * 2;
            this.bufferHeight = n2 * 2;
        } else {
            this.bufferWidth = n;
            this.bufferHeight = n2;
        }
        this.bufferSize = this.bufferWidth * this.bufferHeight;
        this.zBuffer = new int[this.bufferSize];
        this.pBuffer = new int[this.bufferSize];
        this.imagePixelBuffer = this.allocateImage();
    }

    void releaseBuffers() {
        this.bufferSize = -1;
        this.bufferHeight = -1;
        this.bufferWidth = -1;
        this.windowHeight = -1;
        this.windowWidth = -1;
        if (this.imagePixelBuffer != null) {
            this.imagePixelBuffer.flush();
            this.imagePixelBuffer = null;
        }
        this.pBuffer = null;
        this.zBuffer = null;
        this.pBufferT = null;
        this.zBufferT = null;
    }

    void clearScreenBuffer() {
        int n = this.bufferSize;
        while (--n >= 0) {
            this.zBuffer[n] = Integer.MAX_VALUE;
            this.pBuffer[n] = 0;
        }
    }

    void setBackgroundColor(int n) {
        if (this.pBuffer == null) {
            return;
        }
        int n2 = this.bufferSize;
        while (--n2 >= 0) {
            if (this.pBuffer[n2] != 0) continue;
            this.pBuffer[n2] = n;
        }
    }

    void clearTBuffer() {
        int n = this.bufferSizeT;
        while (--n >= 0) {
            this.zBufferT[n] = Integer.MAX_VALUE;
            this.pBufferT[n] = 0;
        }
    }

    final void obtainScreenBuffer() {
        if (this.useClearingThread) {
            this.clearingThread.obtainBufferForClient();
        } else {
            this.clearScreenBuffer();
        }
    }

    final void clearScreenBufferThreaded() {
        if (this.useClearingThread) {
            this.clearingThread.releaseBufferForClearing();
        }
    }

    void notifyEndOfRendering() {
    }

    boolean checkOffscreenSize(int n, int n2) {
        if (n <= this.widthOffscreen && n2 <= this.heightOffscreen) {
            return true;
        }
        if (this.imageOffscreen != null) {
            this.gOffscreen.dispose();
            this.imageOffscreen.flush();
        }
        if (n > this.widthOffscreen) {
            this.widthOffscreen = n + 63 & 0xFFFFFFC0;
        }
        if (n2 > this.heightOffscreen) {
            this.heightOffscreen = n2 + 15 & 0xFFFFFFF0;
        }
        this.imageOffscreen = this.allocateOffscreenImage(this.widthOffscreen, this.heightOffscreen);
        this.gOffscreen = this.getGraphics(this.imageOffscreen);
        return false;
    }

    Image allocateImage() {
        return new BufferedImage(rgbColorModel, Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, this.windowWidth, this.windowHeight, sampleModelBitMasks), new DataBufferInt(this.pBuffer, this.windowSize), null), false, null);
    }

    void setBackgroundTransparent(boolean bl) {
        backgroundTransparent = bl;
    }

    Image allocateOffscreenImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    Graphics getGraphics(Image image) {
        return Platform3D.getStaticGraphics(image);
    }

    static Graphics getStaticGraphics(Image image) {
        Graphics2D graphics2D = ((BufferedImage)image).createGraphics();
        if (backgroundTransparent) {
            // empty if block
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return graphics2D;
    }

    class ClearingThread
    extends Thread {
        boolean bufferHasBeenCleared = false;
        boolean clientHasBuffer = false;

        ClearingThread() {
        }

        synchronized void obtainBufferForClient() {
            while (!this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.clientHasBuffer = true;
        }

        synchronized void releaseBufferForClearing() {
            this.clientHasBuffer = false;
            this.bufferHasBeenCleared = false;
            this.notify();
        }

        synchronized void waitForClientRelease() {
            while (this.clientHasBuffer || this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized void notifyBufferReady() {
            this.bufferHasBeenCleared = true;
            this.notify();
        }

        public void run() {
            while (true) {
                this.waitForClientRelease();
                Platform3D.this.clearScreenBuffer();
                this.notifyBufferReady();
            }
        }
    }
}

