/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Monomer
extends Group {
    BioPolymer bioPolymer;
    protected final byte[] offsets;
    int monomerIndex;

    protected Monomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3);
        this.offsets = byArray;
        this.leadAtomIndex = n2 + (this.offsets[0] & 0xFF);
    }

    void setBioPolymer(BioPolymer bioPolymer, int n) {
        this.bioPolymer = bioPolymer;
        this.monomerIndex = n;
    }

    @Override
    public int getSelectedMonomerCount() {
        return this.bioPolymer.getSelectedMonomerCount();
    }

    @Override
    public int getSelectedMonomerIndex() {
        return this.monomerIndex >= 0 && this.bioPolymer.isMonomerSelected(this.monomerIndex) ? this.monomerIndex : -1;
    }

    public BioPolymer getBioPolymer() {
        return this.bioPolymer;
    }

    @Override
    public int getBioPolymerLength() {
        return this.bioPolymer == null ? 0 : this.bioPolymer.monomerCount;
    }

    @Override
    public int getMonomerIndex() {
        return this.monomerIndex;
    }

    @Override
    public int getBioPolymerIndexInModel() {
        return this.bioPolymer == null ? -1 : this.bioPolymer.bioPolymerIndexInModel;
    }

    protected static byte[] scanForOffsets(int n, int[] nArray, byte[] byArray) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4;
            int n5;
            byte by = byArray[n3];
            if (by < 0) {
                n5 = nArray[~by];
            } else {
                n5 = nArray[by];
                if (n5 < 0) {
                    return null;
                }
            }
            if (n5 < 0) {
                n4 = 255;
            } else {
                n4 = n5 - n;
                if (n4 < 0 || n4 > 254) {
                    Logger.warn("Monomer.scanForOffsets i=" + n3 + " atomID=" + by + " atomIndex:" + n5 + " firstAtomIndex:" + n + " offset out of 0-254 range. Groups aren't organized correctly. Is this really a protein?: " + n4);
                    if (by < 0) {
                        n4 = 255;
                    }
                }
            }
            byArray2[n3] = (byte)n4;
        }
        return byArray2;
    }

    @Override
    public boolean isProtein() {
        return this.isAmino;
    }

    void setStructure(ProteinStructure proteinStructure) {
    }

    public ProteinStructure getProteinStructure() {
        return null;
    }

    @Override
    public byte getProteinStructureType() {
        return 0;
    }

    public boolean isHelix() {
        return false;
    }

    public boolean isSheet() {
        return false;
    }

    @Override
    public void setProteinStructureId(int n) {
    }

    protected final Atom getAtomFromOffsetIndex(int n) {
        if (n > this.offsets.length) {
            return null;
        }
        int n2 = this.offsets[n] & 0xFF;
        if (n2 == 255) {
            return null;
        }
        return this.chain.getAtom(this.firstAtomIndex + n2);
    }

    @Override
    public boolean isLeadAtom(int n) {
        return n == this.leadAtomIndex;
    }

    @Override
    public final Atom getLeadAtom() {
        return this.getAtomFromOffsetIndex(0);
    }

    public final Atom getWingAtom() {
        return this.getAtomFromOffsetIndex(1);
    }

    Atom getInitiatorAtom() {
        return this.getLeadAtom();
    }

    Atom getTerminatorAtom() {
        return this.getLeadAtom();
    }

    abstract boolean isConnectedAfter(Monomer var1);

    @Override
    protected boolean calcBioParameters() {
        return this.bioPolymer.calcParameters();
    }

    @Override
    public boolean haveParameters() {
        return this.bioPolymer.haveParameters;
    }

    public Map<String, Object> getMyInfo() {
        ProteinStructure proteinStructure;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        char c = this.chain.getChainID();
        hashtable.put("chain", c == '\u0000' ? "" : "" + c);
        int n = this.getSeqNumber();
        char c2 = this.getInsertionCode();
        if (n > 0) {
            hashtable.put("sequenceNumber", n);
        }
        if (c2 != '\u0000') {
            hashtable.put("insertionCode", "" + c2);
        }
        hashtable.put("atomInfo1", this.chain.getAtom(this.firstAtomIndex).getInfo());
        hashtable.put("atomInfo2", this.chain.getAtom(this.lastAtomIndex).getInfo());
        hashtable.put("_apt1", this.firstAtomIndex);
        hashtable.put("_apt2", this.lastAtomIndex);
        hashtable.put("atomIndex1", this.firstAtomIndex);
        hashtable.put("atomIndex2", this.lastAtomIndex);
        float f = this.getGroupParameter(1112539143);
        if (!Float.isNaN(f)) {
            hashtable.put("phi", new Float(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1112539144))) {
            hashtable.put("psi", new Float(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1112539140))) {
            hashtable.put("mu", new Float(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1112539147))) {
            hashtable.put("theta", new Float(f));
        }
        if ((proteinStructure = this.getProteinStructure()) != null) {
            hashtable.put("structureId", proteinStructure.uniqueID);
            hashtable.put("structureType", JmolConstants.getProteinStructureName(proteinStructure.type, false));
        }
        hashtable.put("shapeVisibilityFlags", this.shapeVisibilityFlags);
        return hashtable;
    }

    @Override
    public String getStructureId() {
        ProteinStructure proteinStructure = this.getProteinStructure();
        return proteinStructure == null ? "" : JmolConstants.getProteinStructureName(proteinStructure.type, false);
    }

    void getConformation(Atom[] atomArray, BitSet bitSet, int n) {
        char c = '\u0000';
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            Atom atom = atomArray[i];
            char c2 = atom.getAlternateLocationID();
            if (c2 == '\u0000') continue;
            if (n >= 0 && c2 != c) {
                c = c2;
                --n;
            }
            if (n >= 0 || c2 == c) continue;
            bitSet.clear(i);
        }
    }

    final void updateOffsetsForAlternativeLocations(Atom[] atomArray, BitSet bitSet) {
        int n = this.offsets.length;
        block0: while (--n >= 0) {
            int n2;
            Atom atom;
            int n3 = this.offsets[n] & 0xFF;
            if (n3 == 255 || (atom = atomArray[n2 = this.firstAtomIndex + n3]).getAlternateLocationID() == '\u0000') continue;
            int n4 = this.lastAtomIndex - this.firstAtomIndex;
            for (int i = 1; i <= n4; ++i) {
                int n5;
                int n6 = n2 + i;
                if (n6 > this.lastAtomIndex) {
                    n6 -= n4 + 1;
                }
                if ((n5 = n6 - this.firstAtomIndex) < 0 || n5 > 255 || n6 == n2 || !bitSet.get(n6) || atomArray[n6].atomID != atomArray[n2].atomID || atomArray[n6].atomID == 0 && !atomArray[n6].getAtomName().equals(atomArray[n2].getAtomName())) continue;
                if (Logger.debugging) {
                    Logger.debug("Chain.udateOffsetsForAlternativeLocation " + atomArray[n6] + " was " + atomArray[n2]);
                }
                this.offsets[n] = (byte)n5;
                continue block0;
            }
        }
    }

    final void getMonomerSequenceAtoms(BitSet bitSet, BitSet bitSet2) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!bitSet.get(i)) continue;
            bitSet2.set(i);
        }
    }

    protected static final boolean checkOptional(byte[] byArray, byte by, int n, int n2) {
        if (byArray[by] >= 0) {
            return true;
        }
        if (n2 < 0) {
            return false;
        }
        byArray[by] = (byte)(n2 - n);
        return true;
    }

    Point3f getQuaternionFrameCenter(char c) {
        return null;
    }

    protected Object getHelixData2(int n, char c, int n2) {
        Quaternion quaternion;
        int n3 = this.monomerIndex - n2;
        Monomer monomer = n2 < 1 || this.monomerIndex <= 0 ? null : this.bioPolymer.monomers[n3];
        Quaternion quaternion2 = this.getQuaternion(c);
        Quaternion quaternion3 = n2 < 1 ? Quaternion.getQuaternionFrame(JmolConstants.axisX, JmolConstants.axisY, JmolConstants.axisZ, false) : (quaternion = monomer == null ? null : monomer.getQuaternion(c));
        if (quaternion == null || quaternion2 == null) {
            return super.getHelixData(n, c, n2);
        }
        Point3f point3f = n2 < 1 ? new Point3f(0.0f, 0.0f, 0.0f) : monomer.getQuaternionFrameCenter(c);
        Point3f point3f2 = this.getQuaternionFrameCenter(c);
        if (point3f == null || point3f2 == null) {
            return super.getHelixData(n, c, n2);
        }
        return Measure.computeHelicalAxis(n == 135184 ? "helixaxis" + this.getUniqueID() : null, n, point3f, point3f2, quaternion2.div(quaternion));
    }

    public String getUniqueID() {
        char c = this.getChainID();
        Atom atom = this.getLeadAtom();
        String string = (atom == null ? "" : "_" + atom.getModelIndex()) + "_" + this.getResno() + (c == '\u0000' ? "" : "" + c);
        char c2 = c = atom == null ? (char)'\u0000' : this.getLeadAtom().getAlternateLocationID();
        if (c != '\u0000') {
            string = string + c;
        }
        return string;
    }

    protected boolean getCrossLink(int n, List<Integer> list) {
        return this.getCrossLink(n, list, null);
    }

    private boolean getCrossLink(int n, List<Integer> list, Group group) {
        Atom atom = this.chain.getAtom(n);
        Bond[] bondArray = atom.getBonds();
        int n2 = this.getBioPolymerIndexInModel();
        if (n2 < 0 || bondArray == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = list == null && group == null;
        for (int i = 0; i < bondArray.length; ++i) {
            Atom atom2 = bondArray[i].getOtherAtom(atom);
            Group group2 = atom2.getGroup();
            if (group != null && group2 != group) continue;
            int n3 = group2.getBioPolymerIndexInModel();
            int n4 = group2.getMonomerIndex();
            if (bl2) {
                if (n3 != n2 || n4 != this.monomerIndex - 1) continue;
                return true;
            }
            if (n3 < 0 || n4 < 0 || n3 == n2 && n4 >= this.monomerIndex - 1 && n4 <= this.monomerIndex + 1) continue;
            bl = true;
            if (group != null) break;
            list.add(group2.leadAtomIndex);
        }
        return bl;
    }

    @Override
    public boolean isConnectedPrevious() {
        return true;
    }
}

